/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.predicates.SimplePredicate;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.CycleItemStackHandler;
import com.lowdragmc.lowdraglib.utils.ItemStackKey;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PatternPreviewWidget
extends WidgetGroup {
    private static TrackedDummyWorld LEVEL;
    private static BlockPos LAST_POS;
    private static final Map<MultiblockMachineDefinition, MBPattern[]> CACHE;
    private final SceneWidget sceneWidget;
    public final MultiblockMachineDefinition controllerDefinition;
    public final MBPattern[] patterns;
    private final List<SimplePredicate> predicates;
    private int index;
    public int layer;
    private SlotWidget[] slotWidgets;
    private SlotWidget[] candidates;

    protected PatternPreviewWidget(MultiblockMachineDefinition controllerDefinition) {
        super(0, 0, 176, 176);
        this.setClientSideWidget();
        this.controllerDefinition = controllerDefinition;
        this.predicates = new ArrayList<SimplePredicate>();
        this.layer = -1;
        this.sceneWidget = new SceneWidget(3, 3, 170, 170, (Level)LEVEL).setOnSelected(this::onPosSelected).setRenderFacing(false).setRenderFacing(false);
        this.addWidget((Widget)this.sceneWidget);
        if (ConfigHolder.INSTANCE.client.useVBO) {
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> ((SceneWidget)this.sceneWidget).useCacheBuffer());
            } else {
                this.sceneWidget.useCacheBuffer();
            }
        }
        this.addWidget((Widget)new ImageWidget(3, 3, 170, 10, (IGuiTexture)new TextTexture(controllerDefinition.getDescriptionId(), -1).setType(TextTexture.TextType.ROLL).setWidth(170).setDropShadow(true)));
        this.patterns = CACHE.computeIfAbsent(controllerDefinition, definition -> {
            HashSet<ItemStackKey> drops = new HashSet<ItemStackKey>();
            drops.add(new ItemStackKey(new ItemStack[]{this.controllerDefinition.asStack()}));
            return (MBPattern[])controllerDefinition.getMatchingShapes().stream().map(it -> this.initializePattern((MultiblockShapeInfo)it, drops)).filter(Objects::nonNull).toArray(MBPattern[]::new);
        });
        this.addWidget((Widget)new ButtonWidget(150, 40, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture(), new TextTexture("1").setSupplier(() -> "P:" + this.index)}), x -> this.setPage(this.index + 1 >= this.patterns.length ? 0 : this.index + 1)).setHoverBorderTexture(1, -1));
        this.addWidget((Widget)new ButtonWidget(150, 60, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture(), new TextTexture("1").setSupplier(() -> this.layer >= 0 ? "L:" + this.layer : "ALL")}), cd -> this.updateLayer()).setHoverBorderTexture(1, -1));
        this.setPage(0);
    }

    private void updateLayer() {
        MBPattern pattern = this.patterns[this.index];
        if (this.layer + 1 >= -1 && this.layer + 1 <= pattern.maxY - pattern.minY) {
            ++this.layer;
            if (pattern.controllerBase.isFormed()) {
                this.onFormedSwitch(false);
            }
        } else {
            this.layer = -1;
            if (!pattern.controllerBase.isFormed()) {
                this.onFormedSwitch(true);
            }
        }
        this.setupScene(pattern);
    }

    private void setupScene(MBPattern pattern) {
        Stream<BlockPos> stream = pattern.blockMap.keySet().stream().filter(pos -> this.layer == -1 || this.layer + pattern.minY == pos.m_123342_());
        if (pattern.controllerBase.isFormed()) {
            LongSet set = (LongSet)pattern.controllerBase.getMultiblockState().getMatchContext().getOrDefault("renderMask", LongSets.EMPTY_SET);
            Set modelDisabled = set.stream().map(BlockPos::m_122022_).collect(Collectors.toSet());
            if (!modelDisabled.isEmpty()) {
                this.sceneWidget.setRenderedCore((Collection)stream.filter(pos -> !modelDisabled.contains(pos)).collect(Collectors.toList()), null);
            } else {
                this.sceneWidget.setRenderedCore(stream.toList(), null);
            }
        } else {
            this.sceneWidget.setRenderedCore(stream.toList(), null);
        }
    }

    public static PatternPreviewWidget getPatternWidget(MultiblockMachineDefinition controllerDefinition) {
        if (LEVEL == null) {
            if (Minecraft.m_91087_().f_91073_ == null) {
                LDLib.LOGGER.error("Try to init pattern previews before level load");
                throw new IllegalStateException();
            }
            LEVEL = new TrackedDummyWorld();
        }
        return new PatternPreviewWidget(controllerDefinition);
    }

    public void setPage(int index) {
        if (index >= this.patterns.length || index < 0) {
            return;
        }
        this.index = index;
        this.layer = -1;
        MBPattern pattern = this.patterns[index];
        this.setupScene(pattern);
        if (this.slotWidgets != null) {
            for (SlotWidget slotWidget : this.slotWidgets) {
                this.removeWidget((Widget)slotWidget);
            }
        }
        this.slotWidgets = new SlotWidget[Math.min(pattern.parts.size(), 18)];
        CycleItemStackHandler itemHandler = new CycleItemStackHandler(pattern.parts);
        for (int i = 0; i < this.slotWidgets.length; ++i) {
            this.slotWidgets[i] = new SlotWidget((IItemTransfer)itemHandler, i, 7 + i % 9 * 18, 173 - ((this.slotWidgets.length - 1) / 9 + 1) * 18 + i / 9 * 18, false, false).setBackgroundTexture((IGuiTexture)ColorPattern.T_GRAY.rectTexture()).setIngredientIO(IngredientIO.INPUT);
            this.addWidget((Widget)this.slotWidgets[i]);
        }
    }

    private void onFormedSwitch(boolean isFormed) {
        MBPattern pattern = this.patterns[this.index];
        IMultiController controllerBase = pattern.controllerBase;
        if (isFormed) {
            this.layer = -1;
            this.loadControllerFormed(pattern.blockMap.keySet(), controllerBase);
        } else {
            this.sceneWidget.setRenderedCore(pattern.blockMap.keySet(), null);
            controllerBase.onStructureInvalid();
        }
    }

    private void onPosSelected(BlockPos pos, Direction facing) {
        if (this.index >= this.patterns.length || this.index < 0) {
            return;
        }
        TraceabilityPredicate predicate = this.patterns[this.index].predicateMap.get(pos);
        if (predicate != null) {
            this.predicates.clear();
            this.predicates.addAll(predicate.common);
            this.predicates.addAll(predicate.limited);
            this.predicates.removeIf(p -> p == null || p.candidates == null);
            if (this.candidates != null) {
                for (SlotWidget candidate : this.candidates) {
                    this.removeWidget((Widget)candidate);
                }
            }
            ArrayList<List<ItemStack>> candidateStacks = new ArrayList<List<ItemStack>>();
            ArrayList<List<Component>> predicateTips = new ArrayList<List<Component>>();
            for (SimplePredicate simplePredicate : this.predicates) {
                List<ItemStack> itemStacks = simplePredicate.getCandidates();
                if (itemStacks.isEmpty()) continue;
                candidateStacks.add(itemStacks);
                predicateTips.add(simplePredicate.getToolTips(predicate));
            }
            this.candidates = new SlotWidget[candidateStacks.size()];
            CycleItemStackHandler itemHandler = new CycleItemStackHandler(candidateStacks);
            int maxCol = (173 - ((this.slotWidgets.length - 1) / 9 + 1) * 18 - 35) % 18;
            for (int i = 0; i < candidateStacks.size(); ++i) {
                int finalI = i;
                this.candidates[i] = new SlotWidget((IItemTransfer)itemHandler, i, 9 + i / maxCol * 18, 33 + i % maxCol * 18, false, false).setBackgroundTexture((IGuiTexture)new ColorRectTexture(0x4FFFFFFF)).setOnAddedTooltips((slot, list) -> list.addAll((Collection)predicateTips.get(finalI)));
                this.addWidget((Widget)this.candidates[i]);
            }
        }
    }

    public static BlockPos locateNextRegion(int range) {
        BlockPos pos = LAST_POS;
        LAST_POS = LAST_POS.m_7918_(range, 0, range);
        return pos;
    }

    public void updateScreen() {
        super.updateScreen();
    }

    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableBlend();
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
    }

    private MBPattern initializePattern(MultiblockShapeInfo shapeInfo, HashSet<ItemStackKey> blockDrops) {
        HashMap<BlockPos, BlockInfo> blockMap = new HashMap<BlockPos, BlockInfo>();
        IMultiController controllerBase = null;
        BlockPos multiPos = PatternPreviewWidget.locateNextRegion(500);
        BlockInfo[][][] blocks = shapeInfo.getBlocks();
        for (int x = 0; x < blocks.length; ++x) {
            BlockInfo[][] aisle = blocks[x];
            for (int y = 0; y < aisle.length; ++y) {
                BlockInfo[] column = aisle[y];
                for (int z = 0; z < column.length; ++z) {
                    IMachineBlockEntity holder;
                    BlockState blockState = column[z].getBlockState();
                    BlockPos pos = multiPos.m_7918_(x, y, z);
                    Object object = column[z].getBlockEntity(pos);
                    if (object instanceof IMachineBlockEntity && (object = (holder = (IMachineBlockEntity)object).getMetaMachine()) instanceof IMultiController) {
                        IMultiController controller = (IMultiController)object;
                        holder.getSelf().m_142339_((Level)LEVEL);
                        controllerBase = controller;
                    }
                    blockMap.put(pos, BlockInfo.fromBlockState((BlockState)blockState));
                }
            }
        }
        LEVEL.addBlocks(blockMap);
        if (controllerBase != null) {
            LEVEL.setInnerBlockEntity(controllerBase.self().holder.getSelf());
        }
        Map<ItemStackKey, PartInfo> parts = this.gatherBlockDrops(blockMap);
        blockDrops.addAll(parts.keySet());
        HashMap<BlockPos, TraceabilityPredicate> predicateMap = new HashMap();
        if (controllerBase != null) {
            this.loadControllerFormed(predicateMap.keySet(), controllerBase);
            predicateMap = (Map)controllerBase.getMultiblockState().getMatchContext().get("predicates");
        }
        return controllerBase == null ? null : new MBPattern(blockMap, parts.values().stream().sorted((one, two) -> {
            if (one.isController) {
                return -1;
            }
            if (two.isController) {
                return 1;
            }
            if (one.isTile && !two.isTile) {
                return -1;
            }
            if (two.isTile && !one.isTile) {
                return 1;
            }
            if (one.blockId != two.blockId) {
                return two.blockId - one.blockId;
            }
            return two.amount - one.amount;
        }).map(PartInfo::getItemStack).filter(list -> !list.isEmpty()).toList(), predicateMap, controllerBase);
    }

    private void loadControllerFormed(Collection<BlockPos> poses, IMultiController controllerBase) {
        BlockPattern pattern = controllerBase.getPattern();
        if (pattern != null && pattern.checkPatternAt(controllerBase.getMultiblockState(), true)) {
            controllerBase.onStructureFormed();
        }
        if (controllerBase.isFormed()) {
            LongSet set = (LongSet)controllerBase.getMultiblockState().getMatchContext().getOrDefault("renderMask", LongSets.EMPTY_SET);
            Set modelDisabled = set.stream().map(BlockPos::m_122022_).collect(Collectors.toSet());
            if (!modelDisabled.isEmpty()) {
                this.sceneWidget.setRenderedCore((Collection)poses.stream().filter(pos -> !modelDisabled.contains(pos)).collect(Collectors.toList()), null);
            } else {
                this.sceneWidget.setRenderedCore(poses, null);
            }
        } else {
            GTCEu.LOGGER.warn("Pattern formed checking failed: {}", (Object)controllerBase.self().getDefinition());
        }
    }

    private Map<ItemStackKey, PartInfo> gatherBlockDrops(Map<BlockPos, BlockInfo> blocks) {
        Object2ObjectOpenHashMap partsMap = new Object2ObjectOpenHashMap();
        for (Map.Entry<BlockPos, BlockInfo> entry : blocks.entrySet()) {
            BlockPos pos = entry.getKey();
            BlockState blockState = LEVEL.m_8055_(pos);
            ItemStack itemStack = blockState.m_60734_().m_7397_((BlockGetter)LEVEL, pos, blockState);
            if (itemStack.m_41619_() && !blockState.m_60819_().m_76178_()) {
                Fluid fluid = blockState.m_60819_().m_76152_();
                itemStack = fluid.m_6859_().m_7968_();
            }
            ItemStackKey itemStackKey = new ItemStackKey(new ItemStack[]{itemStack});
            ++partsMap.computeIfAbsent(itemStackKey, (Function<ItemStackKey, PartInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$gatherBlockDrops$14(java.util.Map$Entry com.lowdragmc.lowdraglib.utils.ItemStackKey ), (Lcom/lowdragmc/lowdraglib/utils/ItemStackKey;)Lcom/gregtechceu/gtceu/api/gui/widget/PatternPreviewWidget$PartInfo;)(entry)).amount;
        }
        return partsMap;
    }

    private static /* synthetic */ PartInfo lambda$gatherBlockDrops$14(Map.Entry entry, ItemStackKey key) {
        return new PartInfo(key, (BlockInfo)entry.getValue());
    }

    static {
        LAST_POS = new BlockPos(0, 50, 0);
        CACHE = new HashMap<MultiblockMachineDefinition, MBPattern[]>();
    }

    private static class MBPattern {
        @Nonnull
        final List<List<ItemStack>> parts;
        @Nonnull
        final Map<BlockPos, TraceabilityPredicate> predicateMap;
        @Nonnull
        final Map<BlockPos, BlockInfo> blockMap;
        @Nonnull
        final IMultiController controllerBase;
        final int maxY;
        final int minY;

        public MBPattern(@Nonnull Map<BlockPos, BlockInfo> blockMap, List<List<ItemStack>> parts, @Nonnull Map<BlockPos, TraceabilityPredicate> predicateMap, @Nonnull IMultiController controllerBase) {
            this.parts = parts;
            this.blockMap = blockMap;
            this.predicateMap = predicateMap;
            this.controllerBase = controllerBase;
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (BlockPos pos : blockMap.keySet()) {
                min = Math.min(min, pos.m_123342_());
                max = Math.max(max, pos.m_123342_());
            }
            this.minY = min;
            this.maxY = max;
        }
    }

    private static class PartInfo {
        final ItemStackKey itemStackKey;
        boolean isController = false;
        boolean isTile = false;
        final int blockId;
        int amount = 0;

        PartInfo(ItemStackKey itemStackKey, BlockInfo blockInfo) {
            this.itemStackKey = itemStackKey;
            this.blockId = Block.m_49956_((BlockState)blockInfo.getBlockState());
            this.isTile = blockInfo.hasBlockEntity();
            Block block = blockInfo.getBlockState().m_60734_();
            if (block instanceof MetaMachineBlock) {
                MetaMachineBlock block2 = (MetaMachineBlock)block;
                if (block2.definition instanceof MultiblockMachineDefinition) {
                    this.isController = true;
                }
            }
        }

        public List<ItemStack> getItemStack() {
            return Arrays.stream(this.itemStackKey.getItemStack()).map(itemStack -> {
                ItemStack item = itemStack.m_41777_();
                item.m_41764_(this.amount);
                return item;
            }).filter(item -> !item.m_41619_()).toList();
        }
    }
}

