/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.lowdragmc.lowdraglib.client.scene.ISceneBlockRenderHook;
import com.lowdragmc.lowdraglib.client.scene.WorldSceneRenderer;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.BlockPosFace;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AutoOutputConfigurator
extends WidgetGroup {
    protected final MetaMachine machine;
    protected SceneWidget sceneWidget;
    @Nullable
    protected Direction side;

    public AutoOutputConfigurator(MetaMachine machine) {
        super(0, 0, 120, 80);
        this.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        this.machine = machine;
        if (!(machine instanceof IAutoOutputFluid) && !(machine instanceof IAutoOutputItem)) {
            throw new IllegalArgumentException("machine %s is not auto-outputable".formatted(machine));
        }
    }

    public void initWidget() {
        IAutoOutputFluid autoOutputFluid;
        IAutoOutputItem autoOutputItem;
        super.initWidget();
        this.sceneWidget = new SceneWidget(4, 4, 112, 72, this.gui.entityPlayer.m_9236_()).setRenderedCore(List.of(this.machine.getPos()), null).setRenderSelect(false).setOnSelected(this::onSideSelected);
        if (this.isRemote()) {
            this.sceneWidget.getRenderer().addRenderedBlocks(List.of(this.machine.getPos().m_7494_(), this.machine.getPos().m_7495_(), this.machine.getPos().m_122012_(), this.machine.getPos().m_122019_(), this.machine.getPos().m_122029_(), this.machine.getPos().m_122024_()), new ISceneBlockRenderHook(){

                @OnlyIn(value=Dist.CLIENT)
                public void apply(boolean isTESR, RenderType layer) {
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                }
            });
            this.sceneWidget.getRenderer().setAfterWorldRender(this::renderBlockOverLay);
            Vec2 playerRotation = this.gui.entityPlayer.m_20155_();
            this.sceneWidget.setCameraYawAndPitch(playerRotation.f_82470_, playerRotation.f_82471_ - 90.0f);
        }
        this.addWidget(this.sceneWidget.setBackground(new IGuiTexture[]{ColorPattern.BLACK.rectTexture()}));
        int leftButtonStartX = 4;
        int topLabelStartY = 4;
        MetaMachine metaMachine = this.machine;
        if (metaMachine instanceof IAutoOutputItem && (autoOutputItem = (IAutoOutputItem)((Object)metaMachine)).hasAutoOutputItem()) {
            this.addWidget((Widget)new ToggleButtonWidget(leftButtonStartX, 58, 18, 18, (IGuiTexture)GuiTextures.BUTTON_ITEM_OUTPUT, autoOutputItem::isAllowInputFromOutputSideItems, autoOutputItem::setAllowInputFromOutputSideItems).setShouldUseBaseBackground().setTooltipText("gtceu.gui.item_auto_output.allow_input"));
            this.addWidget((Widget)new LabelWidget(4, topLabelStartY, () -> autoOutputItem.isAutoOutputItems() && autoOutputItem.getOutputFacingItems() != null ? "gtceu.gui.auto_output.name" : "").setTextColor(-37361).setDropShadow(false));
            leftButtonStartX += 20;
            topLabelStartY += 10;
        }
        if ((metaMachine = this.machine) instanceof IAutoOutputFluid && (autoOutputFluid = (IAutoOutputFluid)((Object)metaMachine)).hasAutoOutputFluid()) {
            this.addWidget((Widget)new ToggleButtonWidget(leftButtonStartX, 58, 18, 18, (IGuiTexture)GuiTextures.BUTTON_FLUID_OUTPUT, autoOutputFluid::isAllowInputFromOutputSideFluids, autoOutputFluid::setAllowInputFromOutputSideFluids).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_auto_output.allow_input"));
            this.addWidget((Widget)new LabelWidget(4, topLabelStartY, () -> autoOutputFluid.isAutoOutputFluids() && autoOutputFluid.getOutputFacingFluids() != null ? "gtceu.gui.auto_output.name" : "").setTextColor(-16730881).setDropShadow(false));
            leftButtonStartX += 20;
            topLabelStartY += 10;
        }
    }

    private void onSideSelected(BlockPos blockPos, Direction direction) {
        if (blockPos.equals((Object)this.machine.getPos()) && this.side != direction) {
            this.side = direction;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderBlockOverLay(WorldSceneRenderer renderer) {
        this.sceneWidget.renderBlockOverLay(renderer);
        for (Direction face : Direction.values()) {
            IAutoOutputFluid autoOutputFluid;
            IAutoOutputItem autoOutputItem;
            BlockPosFace blockFace = new BlockPosFace(this.machine.getPos(), face);
            MetaMachine metaMachine = this.machine;
            if (metaMachine instanceof IAutoOutputItem && (autoOutputItem = (IAutoOutputItem)((Object)metaMachine)).getOutputFacingItems() == face) {
                this.sceneWidget.drawFacingBorder(new PoseStack(), blockFace, autoOutputItem.isAutoOutputItems() ? -37361 : -1879085553, 1);
            }
            if (!((metaMachine = this.machine) instanceof IAutoOutputFluid) || (autoOutputFluid = (IAutoOutputFluid)((Object)metaMachine)).getOutputFacingFluids() != face) continue;
            this.sceneWidget.drawFacingBorder(new PoseStack(), blockFace, autoOutputFluid.isAutoOutputFluids() ? -16730881 : -1895779073, 2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        BlockPosFace hover;
        Direction lastSide = this.side;
        boolean result = super.mouseClicked(mouseX, mouseY, button);
        if (this.isMouseOverElement(mouseX, mouseY) && this.side == lastSide && this.side != null && (hover = this.sceneWidget.getHoverPosFace()) != null && hover.pos.equals((Object)this.machine.getPos()) && hover.facing == this.side && this.machine.canSetIoOnSide(this.side)) {
            ClickData cd = new ClickData();
            this.writeClientAction(0, buf -> {
                cd.writeToBuf(buf);
                buf.m_130068_((Enum)this.side);
            });
        }
        return result;
    }

    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        if (id == 0) {
            IAutoOutputItem item;
            IAutoOutputItem item2;
            IAutoOutputFluid fluid;
            ClickData clickData = ClickData.readFromBuf((FriendlyByteBuf)buffer);
            Direction side = (Direction)buffer.m_130066_(Direction.class);
            boolean isItem = false;
            boolean isFluid = false;
            MetaMachine metaMachine = this.machine;
            if (metaMachine instanceof IAutoOutputFluid && (fluid = (IAutoOutputFluid)((Object)metaMachine)).hasAutoOutputFluid() && (metaMachine = this.machine) instanceof IAutoOutputItem && (item2 = (IAutoOutputItem)((Object)metaMachine)).hasAutoOutputItem()) {
                if (clickData.button == 0) {
                    isItem = true;
                } else if (clickData.button == 1) {
                    isFluid = true;
                }
            } else {
                IAutoOutputFluid fluid2;
                metaMachine = this.machine;
                if (metaMachine instanceof IAutoOutputFluid && (fluid2 = (IAutoOutputFluid)((Object)metaMachine)).hasAutoOutputFluid()) {
                    isFluid = true;
                } else {
                    IAutoOutputItem item3;
                    metaMachine = this.machine;
                    if (metaMachine instanceof IAutoOutputItem && (item3 = (IAutoOutputItem)((Object)metaMachine)).hasAutoOutputItem()) {
                        isItem = true;
                    }
                }
            }
            if (isItem && (item = (IAutoOutputItem)((Object)this.machine)).hasAutoOutputItem()) {
                if (item.getOutputFacingItems() != side) {
                    item.setOutputFacingItems(side);
                    item.setAutoOutputItems(false);
                } else if (!item.isAutoOutputItems()) {
                    item.setAutoOutputItems(true);
                } else {
                    item.setOutputFacingItems(null);
                }
            }
            if (isFluid && (fluid = (IAutoOutputFluid)((Object)this.machine)).hasAutoOutputFluid()) {
                if (fluid.getOutputFacingFluids() != side) {
                    fluid.setOutputFacingFluids(side);
                    fluid.setAutoOutputFluids(false);
                } else if (!fluid.isAutoOutputFluids()) {
                    fluid.setAutoOutputFluids(true);
                } else {
                    fluid.setOutputFacingFluids(null);
                }
            }
        } else {
            super.handleClientAction(id, buffer);
        }
    }
}

