/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui;

import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class WidgetUtils {
    public static List<Widget> getWidgetsById(WidgetGroup group, String regex) {
        return group.getWidgetsById(Pattern.compile(regex));
    }

    @Nullable
    public static Widget getFirstWidgetById(WidgetGroup group, String regex) {
        return group.getFirstWidgetById(Pattern.compile(regex));
    }

    public static void widgetByIdForEach(WidgetGroup group, String regex, Consumer<Widget> consumer) {
        WidgetUtils.getWidgetsById(group, regex).forEach(consumer);
    }

    public static <T extends Widget> void widgetByIdForEach(WidgetGroup group, String regex, Class<T> clazz, Consumer<T> consumer) {
        for (Widget widget : WidgetUtils.getWidgetsById(group, regex)) {
            if (!clazz.isInstance(widget)) continue;
            consumer.accept((Widget)clazz.cast(widget));
        }
    }

    public static int widgetIdIndex(Widget widget) {
        String id = widget.getId();
        if (id == null) {
            return -1;
        }
        String[] split = id.split("_");
        if (split.length == 0) {
            return -1;
        }
        String end = split[split.length - 1];
        try {
            return Integer.parseInt(end);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

