/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.fluids.store;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.fluids.FluidBuilder;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FluidStorage {
    private final Map<FluidStorageKey, FluidEntry> map = new Object2ObjectOpenHashMap();
    private Map<FluidStorageKey, FluidBuilder> toRegister = new Object2ObjectOpenHashMap();
    private boolean registered = false;

    public void enqueueRegistration(@NotNull FluidStorageKey key, @NotNull FluidBuilder builder) {
        if (this.registered) {
            throw new IllegalStateException("Cannot enqueue a builder after registration");
        }
        if (this.toRegister.containsKey(key)) {
            throw new IllegalArgumentException("FluidStorageKey " + key + " is already queued");
        }
        this.toRegister.put(key, builder);
    }

    @Nullable
    public FluidBuilder getQueuedBuilder(@NotNull FluidStorageKey key) {
        if (this.registered) {
            throw new IllegalArgumentException("FluidStorage has already been registered");
        }
        return this.toRegister.get(key);
    }

    @ApiStatus.Internal
    public void registerFluids(@NotNull Material material) {
        if (this.registered) {
            throw new IllegalStateException("FluidStorage has already been registered");
        }
        for (Map.Entry<FluidStorageKey, FluidBuilder> entry : this.toRegister.entrySet()) {
            if (this.map.containsKey(entry.getKey())) continue;
            this.storeWithLogging(entry.getKey(), new FluidEntry(entry.getValue().build("gtceu", material, entry.getKey()), entry.getValue().getStill(), entry.getValue().getFlowing()), material);
        }
        this.toRegister = null;
        this.registered = true;
    }

    @Nullable
    public Fluid get(@NotNull FluidStorageKey key) {
        return this.map.containsKey(key) ? this.map.get(key).getFluid().get() : null;
    }

    @Nullable
    public FluidEntry getEntry(@NotNull FluidStorageKey key) {
        return this.map.getOrDefault(key, null);
    }

    private void storeWithLogging(@NotNull FluidStorageKey key, @NotNull FluidEntry fluid, @NotNull Material material) {
        if (this.map.containsKey(key)) {
            GTCEu.LOGGER.error("{} already has an associated fluid for material {}", (Object)this, (Object)material);
            return;
        }
        this.map.put(key, fluid);
    }

    public void store(@NotNull FluidStorageKey key, @NotNull Fluid fluid) {
        if (this.map.containsKey(key)) {
            throw new IllegalArgumentException(key + " already has an associated fluid");
        }
        this.map.put(key, new FluidEntry(() -> fluid, null, null));
    }

    public static class FluidEntry {
        private Supplier<? extends Fluid> fluid;
        private ResourceLocation stillTexture;
        private ResourceLocation flowTexture;

        public FluidEntry(Supplier<? extends Fluid> fluid, ResourceLocation stillTexture, ResourceLocation flowTexture) {
            this.fluid = fluid;
            this.stillTexture = stillTexture;
            this.flowTexture = flowTexture;
        }

        public Supplier<? extends Fluid> getFluid() {
            return this.fluid;
        }

        public ResourceLocation getStillTexture() {
            return this.stillTexture;
        }

        public ResourceLocation getFlowTexture() {
            return this.flowTexture;
        }

        public void setStillTexture(ResourceLocation stillTexture) {
            this.stillTexture = stillTexture;
        }

        public void setFlowTexture(ResourceLocation flowTexture) {
            this.flowTexture = flowTexture;
        }
    }
}

