/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.ores;

import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.common.data.GTOres;
import com.gregtechceu.gtceu.config.ConfigHolder;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OreVeinUtil {
    private OreVeinUtil() {
    }

    public static boolean canPlaceOre(BlockState pState, Function<BlockPos, BlockState> pAdjacentStateAccessor, RandomSource pRandom, GTOreDefinition entry, OreConfiguration.TargetBlockState pTargetState, BlockPos.MutableBlockPos pMatablePos) {
        if (!pTargetState.f_161032_.m_213865_(pState, pRandom)) {
            return false;
        }
        if (OreVeinUtil.shouldSkipAirCheck(pRandom, entry.getDiscardChanceOnAirExposure())) {
            return true;
        }
        return !Feature.m_159750_(pAdjacentStateAccessor, (BlockPos)pMatablePos);
    }

    public static boolean canPlaceOre(BlockState pState, Function<BlockPos, BlockState> pAdjacentStateAccessor, RandomSource pRandom, GTOreDefinition entry, BlockPos.MutableBlockPos pMatablePos) {
        if (!entry.getLayer().getTarget().m_213865_(pState, pRandom)) {
            return false;
        }
        if (OreVeinUtil.shouldSkipAirCheck(pRandom, entry.getDiscardChanceOnAirExposure())) {
            return true;
        }
        return !Feature.m_159750_(pAdjacentStateAccessor, (BlockPos)pMatablePos);
    }

    protected static boolean shouldSkipAirCheck(RandomSource pRandom, float pChance) {
        return pChance <= 0.0f || !(pChance >= 1.0f) && pRandom.m_188501_() >= pChance;
    }

    public static Optional<BlockPos> getVeinCenter(ChunkPos chunkPos, RandomSource random) {
        int gridSize = ConfigHolder.INSTANCE.worldgen.oreVeins.oreVeinGridSize;
        int randomOffset = ConfigHolder.INSTANCE.worldgen.oreVeins.oreVeinRandomOffset;
        if (chunkPos.f_45578_ % gridSize != 0 || chunkPos.f_45579_ % gridSize != 0) {
            return Optional.empty();
        }
        BlockPos chunkCenter = chunkPos.m_151394_(0);
        if (randomOffset == 0) {
            return Optional.of(chunkCenter);
        }
        return Optional.of(chunkCenter.m_7918_(random.m_216339_(-randomOffset, randomOffset), 0, random.m_216339_(-randomOffset, randomOffset)));
    }

    static int getMaxVeinSearchDistance() {
        double halfVeinSize = (double)GTOres.getLargestVeinSize() / 2.0;
        int randomOffset = ConfigHolder.INSTANCE.worldgen.oreVeins.oreVeinRandomOffset;
        return (int)Math.ceil((halfVeinSize + (double)randomOffset) / 16.0);
    }

    static int getMaxIndicatorSearchDistance() {
        return OreVeinUtil.getMaxVeinSearchDistance() + (int)Math.ceil((double)GTOres.getLargestIndicatorOffset() / 16.0);
    }
}

