/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.ores;

import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GeneratedVein {
    private final ChunkPos origin;
    private final IWorldGenLayer layer;
    private final Map<ChunkPos, Map<BlockPos, OreBlockPlacer>> generatedOres;

    public GeneratedVein(ChunkPos origin, IWorldGenLayer layer, Map<BlockPos, OreBlockPlacer> oresByPosition) {
        this.origin = origin;
        this.layer = layer;
        this.generatedOres = WorldGeneratorUtils.groupByChunks(oresByPosition);
    }

    public Map<BlockPos, OreBlockPlacer> consumeOres(ChunkPos chunk) {
        return this.generatedOres.getOrDefault(chunk, Map.of());
    }

    public String toString() {
        return "GeneratedVein[origin=" + this.origin + ", chunks={" + this.generatedOres.keySet().stream().map(ChunkPos::toString).collect(Collectors.joining(", ")) + "}]";
    }

    public ChunkPos getOrigin() {
        return this.origin;
    }

    public IWorldGenLayer getLayer() {
        return this.layer;
    }
}

