/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.properties;

import com.gregtechceu.gtceu.api.data.chemical.material.properties.AlloyBlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.BlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.DustProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.GemProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IngotProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PolymerProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.RotorProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WoodProperty;

public class PropertyKey<T extends IMaterialProperty<T>> {
    public static final PropertyKey<BlastProperty> BLAST = new PropertyKey<BlastProperty>("blast", BlastProperty.class);
    public static final PropertyKey<AlloyBlastProperty> ALLOY_BLAST = new PropertyKey<AlloyBlastProperty>("blast_alloy", AlloyBlastProperty.class);
    public static final PropertyKey<DustProperty> DUST = new PropertyKey<DustProperty>("dust", DustProperty.class);
    public static final PropertyKey<FluidPipeProperties> FLUID_PIPE = new PropertyKey<FluidPipeProperties>("fluid_pipe", FluidPipeProperties.class);
    public static final PropertyKey<FluidProperty> FLUID = new PropertyKey<FluidProperty>("fluid", FluidProperty.class);
    public static final PropertyKey<GemProperty> GEM = new PropertyKey<GemProperty>("gem", GemProperty.class);
    public static final PropertyKey<IngotProperty> INGOT = new PropertyKey<IngotProperty>("ingot", IngotProperty.class);
    public static final PropertyKey<PolymerProperty> POLYMER = new PropertyKey<PolymerProperty>("polymer", PolymerProperty.class);
    public static final PropertyKey<ItemPipeProperties> ITEM_PIPE = new PropertyKey<ItemPipeProperties>("item_pipe", ItemPipeProperties.class);
    public static final PropertyKey<OreProperty> ORE = new PropertyKey<OreProperty>("ore", OreProperty.class);
    public static final PropertyKey<ToolProperty> TOOL = new PropertyKey<ToolProperty>("tool", ToolProperty.class);
    public static final PropertyKey<RotorProperty> ROTOR = new PropertyKey<RotorProperty>("rotor", RotorProperty.class);
    public static final PropertyKey<WireProperties> WIRE = new PropertyKey<WireProperties>("wire", WireProperties.class);
    public static final PropertyKey<WoodProperty> WOOD = new PropertyKey<WoodProperty>("wood", WoodProperty.class);
    public static final PropertyKey<EmptyProperty> EMPTY = new PropertyKey<EmptyProperty>("empty", EmptyProperty.class);
    private final String key;
    private final Class<T> type;

    public PropertyKey(String key, Class<T> type) {
        this.key = key;
        this.type = type;
    }

    protected String getKey() {
        return this.key;
    }

    protected T constructDefault() {
        try {
            return (T)((IMaterialProperty)this.type.newInstance());
        }
        catch (Exception e) {
            return null;
        }
    }

    public T cast(IMaterialProperty<?> property) {
        return (T)((IMaterialProperty)this.type.cast(property));
    }

    public boolean equals(Object o) {
        if (o instanceof PropertyKey) {
            return ((PropertyKey)o).getKey().equals(this.key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key;
    }

    private static class EmptyProperty
    implements IMaterialProperty<EmptyProperty> {
        private EmptyProperty() {
        }

        @Override
        public void verifyProperty(MaterialProperties properties) {
        }
    }
}

