/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.cover.filter;

import com.gregtechceu.gtceu.api.cover.filter.FluidFilter;
import com.gregtechceu.gtceu.api.cover.filter.TagFilter;
import com.gregtechceu.gtceu.utils.OreDictExprFilter;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;

public class TagFluidFilter
extends TagFilter<FluidStack, FluidFilter>
implements FluidFilter {
    private final Object2BooleanMap<Fluid> cache = new Object2BooleanOpenHashMap();

    protected TagFluidFilter() {
    }

    public static TagFluidFilter loadFilter(ItemStack itemStack) {
        return TagFluidFilter.loadFilter(itemStack.m_41784_(), filter -> itemStack.m_41751_(filter.saveFilter()));
    }

    private static TagFluidFilter loadFilter(CompoundTag tag, Consumer<FluidFilter> itemWriter) {
        TagFluidFilter handler = new TagFluidFilter();
        handler.itemWriter = itemWriter;
        handler.oreDictFilterExpression = tag.m_128461_("oreDict");
        handler.matchRules.clear();
        handler.cache.clear();
        OreDictExprFilter.parseExpression(handler.matchRules, handler.oreDictFilterExpression);
        return handler;
    }

    @Override
    public void setOreDict(String oreDict) {
        this.cache.clear();
        super.setOreDict(oreDict);
    }

    @Override
    public boolean test(FluidStack fluidStack) {
        if (this.oreDictFilterExpression.isEmpty()) {
            return true;
        }
        if (this.cache.containsKey((Object)fluidStack.getFluid())) {
            return this.cache.getOrDefault((Object)fluidStack.getFluid(), false);
        }
        if (OreDictExprFilter.matchesOreDict((List<OreDictExprFilter.MatchRule>)this.matchRules, fluidStack)) {
            this.cache.put((Object)fluidStack.getFluid(), true);
            return true;
        }
        this.cache.put((Object)fluidStack.getFluid(), false);
        return false;
    }

    @Override
    public long testFluidAmount(FluidStack fluidStack) {
        return this.test(fluidStack) ? Long.MAX_VALUE : 0L;
    }
}

