/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.cover.filter;

import com.gregtechceu.gtceu.api.cover.filter.FluidFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.ScrollablePhantomFluidWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SimpleFluidFilter
implements FluidFilter {
    protected boolean isBlackList;
    protected boolean ignoreNbt;
    protected FluidStack[] matches = new FluidStack[9];
    protected Consumer<FluidFilter> itemWriter = filter -> {};
    protected Consumer<FluidFilter> onUpdated = filter -> this.itemWriter.accept((FluidFilter)filter);
    protected long maxStackSize = 1L;
    private FluidStorage[] fluidStorageSlots = new FluidStorage[9];

    protected SimpleFluidFilter() {
        Arrays.fill(this.matches, FluidStack.empty());
    }

    public static SimpleFluidFilter loadFilter(ItemStack itemStack) {
        return SimpleFluidFilter.loadFilter(itemStack.m_41784_(), filter -> itemStack.m_41751_(filter.saveFilter()));
    }

    private static SimpleFluidFilter loadFilter(CompoundTag tag, Consumer<FluidFilter> itemWriter) {
        SimpleFluidFilter handler = new SimpleFluidFilter();
        handler.itemWriter = itemWriter;
        handler.isBlackList = tag.m_128471_("isBlackList");
        handler.ignoreNbt = tag.m_128471_("matchNbt");
        ListTag list = tag.m_128437_("matches", 10);
        for (int i = 0; i < list.size(); ++i) {
            handler.matches[i] = FluidStack.loadFromTag((CompoundTag)((CompoundTag)list.get(i)));
        }
        return handler;
    }

    @Override
    public void setOnUpdated(Consumer<FluidFilter> onUpdated) {
        this.onUpdated = filter -> {
            this.itemWriter.accept((FluidFilter)filter);
            onUpdated.accept((FluidFilter)filter);
        };
    }

    @Override
    public CompoundTag saveFilter() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("isBlackList", this.isBlackList);
        tag.m_128379_("matchNbt", this.ignoreNbt);
        ListTag list = new ListTag();
        for (FluidStack match : this.matches) {
            list.add((Object)match.saveToTag(new CompoundTag()));
        }
        tag.m_128365_("matches", (Tag)list);
        return tag;
    }

    public void setBlackList(boolean blackList) {
        this.isBlackList = blackList;
        this.onUpdated.accept(this);
    }

    public void setIgnoreNbt(boolean ingoreNbt) {
        this.ignoreNbt = ingoreNbt;
        this.onUpdated.accept(this);
    }

    @Override
    public WidgetGroup openConfigurator(int x, int y) {
        WidgetGroup group = new WidgetGroup(x, y, 79, 54);
        this.fluidStorageSlots = new FluidStorage[9];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int index = i * 3 + j;
                this.fluidStorageSlots[index] = new FluidStorage(this.maxStackSize);
                this.fluidStorageSlots[index].setFluid(this.matches[index]);
                ScrollablePhantomFluidWidget tank = new ScrollablePhantomFluidWidget((IFluidStorage)this.fluidStorageSlots[index], i * 18, j * 18){

                    public void updateScreen() {
                        super.updateScreen();
                        this.setShowAmount(SimpleFluidFilter.this.maxStackSize > 1L);
                    }

                    public void detectAndSendChanges() {
                        super.detectAndSendChanges();
                        this.setShowAmount(SimpleFluidFilter.this.maxStackSize > 1L);
                    }
                };
                tank.setChangeListener(() -> {
                    this.matches[index] = this.fluidStorageSlots[index].getFluidInTank(0);
                    this.onUpdated.accept(this);
                }).setBackground((IGuiTexture)GuiTextures.SLOT);
                group.addWidget((Widget)tank);
            }
        }
        group.addWidget((Widget)new ToggleButtonWidget(59, 0, 20, 20, (IGuiTexture)GuiTextures.BUTTON_BLACKLIST, this::isBlackList, this::setBlackList));
        group.addWidget((Widget)new ToggleButtonWidget(59, 20, 20, 20, (IGuiTexture)GuiTextures.BUTTON_FILTER_NBT, this::isIgnoreNbt, this::setIgnoreNbt));
        return group;
    }

    @Override
    public boolean test(FluidStack other) {
        return this.testFluidAmount(other) > 0L;
    }

    @Override
    public long testFluidAmount(FluidStack fluidStack) {
        long totalFluidAmount = this.getTotalConfiguredFluidAmount(fluidStack);
        if (this.isBlackList) {
            return totalFluidAmount > 0L ? 0L : Long.MAX_VALUE;
        }
        return totalFluidAmount;
    }

    public long getTotalConfiguredFluidAmount(FluidStack fluidStack) {
        long totalAmount = 0L;
        for (FluidStack candidate : this.matches) {
            if (this.ignoreNbt && candidate.getFluid() == fluidStack.getFluid()) {
                totalAmount += candidate.getAmount();
                continue;
            }
            if (!candidate.isFluidEqual(fluidStack)) continue;
            totalAmount += candidate.getAmount();
        }
        return totalAmount;
    }

    public void setMaxStackSize(long maxStackSize) {
        this.maxStackSize = maxStackSize;
        for (FluidStorage fluidStorage : this.fluidStorageSlots) {
            if (fluidStorage == null) continue;
            fluidStorage.setCapacity(maxStackSize);
        }
        for (FluidStorage fluidStorage : this.matches) {
            if (fluidStorage.isEmpty()) continue;
            fluidStorage.setAmount(Math.min(fluidStorage.getAmount(), maxStackSize));
        }
    }

    @Override
    public boolean isBlackList() {
        return this.isBlackList;
    }

    public boolean isIgnoreNbt() {
        return this.ignoreNbt;
    }

    public FluidStack[] getMatches() {
        return this.matches;
    }

    public long getMaxStackSize() {
        return this.maxStackSize;
    }
}

