/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.forge;

import com.gregtechceu.gtceu.api.capability.IPlatformEnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class GTEnergyHelperImpl {
    public static IPlatformEnergyStorage toPlatformEnergyStorage(final IEnergyStorage handler) {
        return new IPlatformEnergyStorage(){

            @Override
            public long insert(long maxAmount, boolean simulate) {
                return handler.receiveEnergy((int)maxAmount, simulate);
            }

            @Override
            public long extract(long maxAmount, boolean simulate) {
                return handler.extractEnergy((int)maxAmount, simulate);
            }

            @Override
            public long getAmount() {
                return handler.getEnergyStored();
            }

            @Override
            public long getCapacity() {
                return handler.getMaxEnergyStored();
            }

            @Override
            public boolean supportsInsertion() {
                return handler.canReceive();
            }

            @Override
            public boolean supportsExtraction() {
                return handler.canExtract();
            }
        };
    }

    public static IEnergyStorage toEnergyStorage(final IPlatformEnergyStorage energyStorage) {
        return new IEnergyStorage(){

            public int receiveEnergy(int i, boolean bl) {
                return (int)Math.min(energyStorage.insert(i, bl), Integer.MAX_VALUE);
            }

            public int extractEnergy(int i, boolean bl) {
                return (int)Math.min(energyStorage.extract(i, bl), Integer.MAX_VALUE);
            }

            public int getEnergyStored() {
                return (int)Math.min(energyStorage.getAmount(), Integer.MAX_VALUE);
            }

            public int getMaxEnergyStored() {
                return (int)Math.min(energyStorage.getCapacity(), Integer.MAX_VALUE);
            }

            public boolean canExtract() {
                return energyStorage.supportsExtraction();
            }

            public boolean canReceive() {
                return energyStorage.supportsInsertion();
            }
        };
    }
}

