/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.blockentity;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.BlockProperties;
import com.gregtechceu.gtceu.api.block.MaterialPipeBlock;
import com.gregtechceu.gtceu.api.block.PipeBlock;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IToolable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IToolGridHighLight;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.pipenet.IAttachData;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.api.pipenet.PipeCoverContainer;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.syncdata.EnhancedFieldManagedStorage;
import com.gregtechceu.gtceu.api.syncdata.IEnhancedManaged;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAsyncAutoSyncBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAutoPersistBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class PipeBlockEntity<PipeType extends Enum<PipeType>, NodeDataType extends IAttachData>
extends BlockEntity
implements IPipeNode<PipeType, NodeDataType>,
IEnhancedManaged,
IAsyncAutoSyncBlockEntity,
IAutoPersistBlockEntity,
IToolGridHighLight,
IToolable {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PipeBlockEntity.class);
    private final EnhancedFieldManagedStorage syncStorage = new EnhancedFieldManagedStorage(this);
    private final long offset = GTValues.RNG.m_188503_(20);
    @DescSynced
    @Persisted(key="cover")
    protected final PipeCoverContainer coverContainer = new PipeCoverContainer(this);
    @DescSynced
    @Persisted
    @RequireRerender
    protected int connections = 0;
    @Persisted
    @DescSynced
    @RequireRerender
    private int paintingColor = -1;
    @Persisted
    @DescSynced
    @RequireRerender
    private String frameMaterial;
    private final List<TickableSubscription> serverTicks = new ArrayList<TickableSubscription>();
    private final List<TickableSubscription> waitingToAdd = new ArrayList<TickableSubscription>();

    public PipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Override
    public void scheduleRenderUpdate() {
        IPipeNode.super.scheduleRenderUpdate();
    }

    public IManagedStorage getRootStorage() {
        return this.syncStorage;
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        Level level = this.m_58904_();
        if (level != null && !level.f_46443_ && level.m_7654_() != null) {
            level.m_7654_().execute(() -> ((PipeBlockEntity)this).m_6596_());
        }
    }

    @Override
    public long getOffsetTimer() {
        return this.f_58857_ == null ? this.offset : this.f_58857_.m_46467_() + this.offset;
    }

    public void m_7651_() {
        super.m_7651_();
        this.coverContainer.onUnload();
    }

    public void m_6339_() {
        super.m_6339_();
        this.coverContainer.onLoad();
    }

    @Override
    public int getNumConnections() {
        int count = 0;
        for (int connections = this.getConnections(); connections > 0; connections &= connections - 1) {
            ++count;
        }
        return count;
    }

    @Override
    @Nullable
    public TickableSubscription subscribeServerTick(Runnable runnable) {
        if (!this.isRemote()) {
            Level level;
            TickableSubscription subscription = new TickableSubscription(runnable);
            this.waitingToAdd.add(subscription);
            BlockState blockState = this.m_58900_();
            if (!((Boolean)blockState.m_61143_((Property)BlockProperties.SERVER_TICK)).booleanValue() && (level = this.m_58904_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                blockState = (BlockState)blockState.m_61124_((Property)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(true));
                this.m_155250_(blockState);
                serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, () -> serverLevel.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(true)))));
            }
            return subscription;
        }
        return null;
    }

    @Override
    public void unsubscribe(@Nullable TickableSubscription current) {
        if (current != null) {
            current.unsubscribe();
        }
    }

    @Override
    public final void serverTick() {
        if (!this.waitingToAdd.isEmpty()) {
            this.serverTicks.addAll(this.waitingToAdd);
            this.waitingToAdd.clear();
        }
        Iterator<TickableSubscription> iter = this.serverTicks.iterator();
        while (iter.hasNext()) {
            TickableSubscription tickable = iter.next();
            if (tickable.isStillSubscribed()) {
                tickable.run();
            }
            if (tickable.isStillSubscribed()) continue;
            iter.remove();
        }
        if (this.serverTicks.isEmpty() && this.waitingToAdd.isEmpty()) {
            this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public boolean isBlocked(Direction side) {
        return (this.connections & 1 << side.ordinal()) == 0;
    }

    @Override
    public void setBlocked(Direction side, boolean isBlocked) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.connections = !isBlocked ? (this.connections |= 1 << side.ordinal()) : (this.connections &= ~(1 << side.ordinal()));
            this.getPipeBlock().getWorldPipeNet(serverLevel).updateBlockedConnections(this.m_58899_(), side, isBlocked);
            this.updateConnections();
            this.notifyBlockUpdate();
        }
    }

    @Override
    public int getVisualConnections() {
        int visualConnections = this.connections;
        for (Direction side : Direction.values()) {
            CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
            if (cover == null || !cover.blockPipePassThrough()) continue;
            visualConnections |= 1 << side.ordinal();
        }
        return visualConnections;
    }

    @Override
    public boolean shouldRenderGrid(Player player, ItemStack held, GTToolType toolType) {
        if (this.canToolTunePipe(toolType) || toolType == GTToolType.SCREWDRIVER) {
            return true;
        }
        for (CoverBehavior cover : this.coverContainer.getCovers()) {
            if (!cover.shouldRenderGrid(player, held, toolType)) continue;
            return true;
        }
        return false;
    }

    public ResourceTexture getPipeTexture(boolean isBlock) {
        return isBlock ? GuiTextures.TOOL_PIPE_CONNECT : GuiTextures.TOOL_PIPE_BLOCK;
    }

    @Override
    public ResourceTexture sideTips(Player player, GTToolType toolType, Direction side) {
        if (this.canToolTunePipe(toolType)) {
            return this.getPipeTexture(this.isBlocked(side));
        }
        CoverBehavior cover = this.coverContainer.getCoverAtSide(side);
        if (cover != null) {
            return cover.sideTips(player, toolType, side);
        }
        return null;
    }

    @Override
    public InteractionResult onToolClick(@NotNull GTToolType toolType, ItemStack itemStack, UseOnContext context) {
        CoverBehavior coverBehavior;
        Player playerIn = context.m_43723_();
        if (playerIn == null) {
            return InteractionResult.PASS;
        }
        InteractionHand hand = context.m_43724_();
        BlockHitResult hitResult = new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), false);
        Direction gridSide = ICoverable.determineGridSideHit(hitResult);
        CoverBehavior coverBehavior2 = coverBehavior = gridSide == null ? null : this.coverContainer.getCoverAtSide(gridSide);
        if (gridSide == null) {
            gridSide = hitResult.m_82434_();
        }
        if (toolType == GTToolType.SCREWDRIVER) {
            if (coverBehavior != null) {
                return coverBehavior.onScrewdriverClick(playerIn, hand, hitResult);
            }
        } else if (toolType == GTToolType.SOFT_MALLET) {
            if (coverBehavior != null) {
                return coverBehavior.onSoftMalletClick(playerIn, hand, hitResult);
            }
        } else {
            if (this.canToolTunePipe(toolType)) {
                IPipeNode node;
                this.setBlocked(gridSide, !this.isBlocked(gridSide));
                if (!this.isBlocked(gridSide) && (node = this.getPipeBlock().getPileTile((BlockGetter)this.getPipeLevel(), this.getPipePos().m_121945_(gridSide))) != null && node.isBlocked(gridSide.m_122424_())) {
                    node.setBlocked(gridSide.m_122424_(), false);
                }
                return InteractionResult.CONSUME;
            }
            if (toolType == GTToolType.CROWBAR && coverBehavior != null) {
                if (!this.isRemote()) {
                    this.getCoverContainer().removeCover(gridSide, playerIn);
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    protected boolean canToolTunePipe(GTToolType toolType) {
        return toolType == GTToolType.WRENCH;
    }

    @Override
    public int getDefaultPaintingColor() {
        int n;
        PipeBlock pipeBlock = this.getPipeBlock();
        if (pipeBlock instanceof MaterialPipeBlock) {
            MaterialPipeBlock materialPipeBlock = (MaterialPipeBlock)pipeBlock;
            n = materialPipeBlock.material.getMaterialRGB();
        } else {
            n = IPipeNode.super.getDefaultPaintingColor();
        }
        return n;
    }

    @Override
    @Nullable
    public Material getFrameMaterial() {
        return this.frameMaterial == null ? null : (Material)GTRegistries.MATERIALS.get(this.frameMaterial);
    }

    public EnhancedFieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }

    @Override
    public PipeCoverContainer getCoverContainer() {
        return this.coverContainer;
    }

    @Override
    public int getConnections() {
        return this.connections;
    }

    @Override
    public void setConnections(int connections) {
        this.connections = connections;
    }

    @Override
    public int getPaintingColor() {
        return this.paintingColor;
    }

    @Override
    public void setPaintingColor(int paintingColor) {
        this.paintingColor = paintingColor;
    }
}

