/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.block;

import com.gregtechceu.gtceu.api.block.PipeBlock;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.pipenet.IAttachData;
import com.gregtechceu.gtceu.api.pipenet.IMaterialPipeType;
import com.gregtechceu.gtceu.client.model.PipeModel;
import com.gregtechceu.gtceu.client.renderer.block.PipeBlockRenderer;
import com.lowdragmc.lowdraglib.pipelike.LevelPipeNet;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class MaterialPipeBlock<PipeType extends Enum<PipeType> & IMaterialPipeType<NodeDataType>, NodeDataType extends IAttachData, WorldPipeNetType extends LevelPipeNet<NodeDataType, ? extends PipeNet<NodeDataType>>>
extends PipeBlock<PipeType, NodeDataType, WorldPipeNetType> {
    public final Material material;
    public final PipeBlockRenderer renderer;
    public final PipeModel model;

    public MaterialPipeBlock(BlockBehaviour.Properties properties, PipeType pipeType, Material material) {
        super(properties, pipeType);
        this.material = material;
        this.model = this.createPipeModel();
        this.renderer = new PipeBlockRenderer(this.model);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor tintedColor() {
        return (blockState, level, blockPos, index) -> {
            Block patt2093$temp = blockState.m_60734_();
            if (patt2093$temp instanceof MaterialPipeBlock) {
                PipeBlockEntity pipe;
                BlockEntity patt2226$temp;
                MaterialPipeBlock block = (MaterialPipeBlock)patt2093$temp;
                if (blockPos != null && level != null && (patt2226$temp = level.m_7702_(blockPos)) instanceof PipeBlockEntity && (pipe = (PipeBlockEntity)patt2226$temp).isPainted()) {
                    return pipe.getRealColor();
                }
                return block.tinted(blockState, level, blockPos, index);
            }
            return -1;
        };
    }

    public int tinted(BlockState blockState, @Nullable BlockAndTintGetter blockAndTintGetter, @Nullable BlockPos blockPos, int index) {
        return index == 0 || index == 1 ? this.material.getMaterialRGB() : -1;
    }

    @Override
    protected PipeModel getPipeModel() {
        return this.model;
    }

    @Override
    public final NodeDataType createRawData(BlockState pState, @Nullable ItemStack pStack) {
        return this.createMaterialData();
    }

    @Override
    @Nullable
    public PipeBlockRenderer getRenderer(BlockState state) {
        return this.renderer;
    }

    @Override
    public final NodeDataType getFallbackType() {
        return this.createMaterialData();
    }

    protected abstract NodeDataType createMaterialData();

    protected abstract PipeModel createPipeModel();

    public String m_7705_() {
        return ((IMaterialPipeType)((Object)this.pipeType)).getTagPrefix().getUnlocalizedName(this.material);
    }

    public MutableComponent m_49954_() {
        return ((IMaterialPipeType)((Object)this.pipeType)).getTagPrefix().getLocalizedName(this.material);
    }
}

