/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;

public class OverlayedItemHandler {
    private final OverlayedItemHandlerSlot[] originalSlots;
    private final OverlayedItemHandlerSlot[] slots;
    private final IItemTransfer overlayedHandler;

    public OverlayedItemHandler(@Nonnull IItemTransfer toOverlay) {
        this.slots = new OverlayedItemHandlerSlot[toOverlay.getSlots()];
        this.originalSlots = new OverlayedItemHandlerSlot[toOverlay.getSlots()];
        this.overlayedHandler = toOverlay;
    }

    public void reset() {
        for (int i = 0; i < this.originalSlots.length; ++i) {
            if (this.originalSlots[i] == null) continue;
            this.slots[i] = this.originalSlots[i].copy();
        }
    }

    public int getSlots() {
        return this.overlayedHandler.getSlots();
    }

    private void initSlot(int slot) {
        if (this.originalSlots[slot] == null) {
            ItemStack stackToMirror = this.overlayedHandler.getStackInSlot(slot);
            int slotLimit = this.overlayedHandler.getSlotLimit(slot);
            this.originalSlots[slot] = new OverlayedItemHandlerSlot(stackToMirror, slotLimit);
            this.slots[slot] = new OverlayedItemHandlerSlot(stackToMirror, slotLimit);
        }
    }

    public int insertStackedItemStack(@Nonnull ItemStack stack, int amountToInsert) {
        int insertedAmount;
        int canInsertUpTo;
        int lastKnownPopulatedSlot = 0;
        int i = 0;
        while (i < this.slots.length) {
            this.initSlot(i);
            ItemStack slotKey = this.slots[i].getItemStack();
            if ((slotKey.m_41619_() || ItemStackHashStrategy.comparingAllButCount().equals(slotKey, stack)) && (canInsertUpTo = this.slots[i].getSlotLimit() - this.slots[i].getCount()) > 0) {
                insertedAmount = Math.min(canInsertUpTo, amountToInsert);
                this.slots[i].setItemStack(stack.m_41777_());
                this.slots[i].setCount(this.slots[i].getCount() + insertedAmount);
                amountToInsert -= insertedAmount;
            }
            lastKnownPopulatedSlot = i++;
            if (amountToInsert != 0) continue;
            return 0;
        }
        if (amountToInsert > 0) {
            for (i = lastKnownPopulatedSlot + 1; i < this.slots.length; ++i) {
                OverlayedItemHandlerSlot slot = this.slots[i];
                if (!slot.getItemStack().m_41619_()) continue;
                canInsertUpTo = Math.min(stack.m_41741_(), slot.getSlotLimit());
                if (canInsertUpTo > 0) {
                    insertedAmount = Math.min(canInsertUpTo, amountToInsert);
                    slot.setItemStack(stack.m_41777_());
                    slot.setCount(insertedAmount);
                    amountToInsert -= insertedAmount;
                }
                if (amountToInsert != 0) continue;
                return 0;
            }
        }
        return amountToInsert;
    }

    private static class OverlayedItemHandlerSlot {
        private ItemStack itemStack = ItemStack.f_41583_;
        private int count = 0;
        private int slotLimit;

        protected OverlayedItemHandlerSlot(@Nonnull ItemStack stackToMirror, int slotLimit) {
            if (!stackToMirror.m_41619_()) {
                this.itemStack = stackToMirror.m_41777_();
                this.count = stackToMirror.m_41613_();
                this.slotLimit = Math.min(this.itemStack.m_41741_(), slotLimit);
            } else {
                this.slotLimit = slotLimit;
            }
        }

        protected OverlayedItemHandlerSlot(@Nonnull ItemStack itemStack, int slotLimit, int count) {
            this.itemStack = itemStack;
            this.count = count;
            this.slotLimit = slotLimit;
        }

        public int getSlotLimit() {
            return this.slotLimit;
        }

        public int getCount() {
            return this.count;
        }

        @Nonnull
        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public void setItemStack(@Nonnull ItemStack itemStack) {
            if (!ItemStackHashStrategy.comparingAllButCount().equals(this.itemStack, itemStack)) {
                this.itemStack = itemStack;
                this.slotLimit = Math.min(itemStack.m_41741_(), this.slotLimit);
            }
        }

        public void setCount(int count) {
            this.count = count;
        }

        @Nonnull
        OverlayedItemHandlerSlot copy() {
            return new OverlayedItemHandlerSlot(this.itemStack, this.slotLimit, this.count);
        }
    }
}

