/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.misc.FluidTransferList;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public class OverlayedFluidHandler {
    private final List<OverlayedTank> overlayedTanks = new ArrayList<OverlayedTank>();

    public OverlayedFluidHandler(@Nonnull FluidTransferList tank) {
        FluidStack[] entries = (FluidStack[])IntStream.range(0, tank.getTanks()).mapToObj(arg_0 -> ((FluidTransferList)tank).getFluidInTank(arg_0)).toArray(FluidStack[]::new);
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStorage storage = new FluidStorage(tank.getTankCapacity(i));
            storage.setFluid(entries[i]);
            this.overlayedTanks.add(new OverlayedTank((IFluidStorage)storage, tank.isFluidValid(i, entries[i])));
        }
    }

    public void reset() {
        for (OverlayedTank overlayedTank : this.overlayedTanks) {
            overlayedTank.reset();
        }
    }

    public long insertFluid(@Nonnull FluidStack fluid, long amountToInsert) {
        long inserted;
        if (amountToInsert <= 0L) {
            return 0L;
        }
        long totalInserted = 0L;
        boolean distinctFillPerformed = false;
        for (OverlayedTank overlayedTank : this.overlayedTanks) {
            if (overlayedTank.fluid == null || !fluid.isFluidEqual(overlayedTank.fluid)) continue;
            inserted = overlayedTank.tryInsert(fluid, amountToInsert);
            if (inserted > 0L) {
                totalInserted += inserted;
                if ((amountToInsert -= inserted) <= 0L) {
                    return totalInserted;
                }
            }
            if (overlayedTank.allowSameFluidFill) continue;
            distinctFillPerformed = true;
        }
        for (OverlayedTank overlayedTank : this.overlayedTanks) {
            if (distinctFillPerformed && !overlayedTank.allowSameFluidFill || !overlayedTank.isEmpty() || !overlayedTank.property.isFluidValid(fluid) || (inserted = overlayedTank.tryInsert(fluid, amountToInsert)) <= 0L) continue;
            totalInserted += inserted;
            if ((amountToInsert -= inserted) <= 0L) {
                return totalInserted;
            }
            if (overlayedTank.allowSameFluidFill) continue;
            distinctFillPerformed = true;
        }
        return totalInserted;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean lineBreak) {
        StringBuilder stb = new StringBuilder("OverlayedFluidHandler[").append(this.overlayedTanks.size()).append(";");
        if (lineBreak) {
            stb.append("\n  ");
        }
        for (int i = 0; i < this.overlayedTanks.size(); ++i) {
            if (i != 0) {
                stb.append(',');
            }
            if (lineBreak) {
                stb.append("\n  ");
            }
            OverlayedTank overlayedTank = this.overlayedTanks.get(i);
            FluidStack fluid = overlayedTank.fluid;
            if (fluid == null || fluid.getAmount() == 0L) {
                stb.append("None 0 / ").append(overlayedTank.property.getCapacity());
                continue;
            }
            stb.append(FluidHelper.getDisplayName((FluidStack)fluid)).append(' ').append(fluid.getAmount()).append(" / ").append(overlayedTank.property.getCapacity());
        }
        if (lineBreak) {
            stb.append('\n');
        }
        return stb.append(']').toString();
    }

    private static class OverlayedTank {
        private final IFluidStorage property;
        private final boolean allowSameFluidFill;
        private FluidStack fluid;

        OverlayedTank(@Nonnull IFluidStorage property, boolean allowSameFluidFill) {
            this.property = property;
            this.allowSameFluidFill = allowSameFluidFill;
            this.reset();
        }

        public boolean isEmpty() {
            return this.fluid == FluidStack.empty() || this.fluid.getAmount() <= 0L;
        }

        public long tryInsert(@Nonnull FluidStack fluid, long amount) {
            if (this.fluid == FluidStack.empty()) {
                this.fluid = fluid.copy();
                this.fluid.setAmount(Math.min(this.property.getCapacity(), amount));
                return this.fluid.getAmount();
            }
            long maxInsert = Math.min(this.property.getCapacity() - this.fluid.getAmount(), amount);
            if (maxInsert > 0L) {
                this.fluid.setAmount(this.fluid.getAmount() + maxInsert);
                return maxInsert;
            }
            return 0L;
        }

        public void reset() {
            FluidStack fluid = this.property.getFluid();
            this.fluid = fluid != FluidStack.empty() ? fluid.copy() : FluidStack.empty();
        }
    }
}

