/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.google.common.collect.Lists;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.core.mixins.IngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.IntersectionIngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.StrictNBTIngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.TagValueAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.common.crafting.StrictNBTIngredient;

public class IngredientEquality {
    public static final Comparator<ItemStack> STACK_COMPARATOR = Comparator.comparing(stack -> BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
    public static final Comparator<Ingredient.Value> INGREDIENT_VALUE_COMPARATOR = new Comparator<Ingredient.Value>(){

        @Override
        public int compare(Ingredient.Value value1, Ingredient.Value value2) {
            if (value1 instanceof Ingredient.TagValue) {
                Ingredient.TagValue tagValue = (Ingredient.TagValue)value1;
                if (!(value2 instanceof Ingredient.TagValue)) {
                    return 1;
                }
                Ingredient.TagValue tagValue1 = (Ingredient.TagValue)value2;
                if (((TagValueAccessor)tagValue).getTag() != ((TagValueAccessor)tagValue1).getTag()) {
                    return 1;
                }
            } else if (value1 instanceof Ingredient.ItemValue) {
                if (!(value2 instanceof Ingredient.ItemValue)) {
                    return 1;
                }
                for (ItemStack item1 : value1.m_6223_()) {
                    for (ItemStack item2 : value2.m_6223_()) {
                        int result = STACK_COMPARATOR.compare(item1, item2);
                        if (result == 0) continue;
                        return result;
                    }
                }
            }
            return 0;
        }
    };
    public static final Comparator<Ingredient> INGREDIENT_COMPARATOR = new Comparator<Ingredient>(){

        @Override
        public int compare(Ingredient first, Ingredient second) {
            Ingredient.Value[] values2;
            if (first instanceof StrictNBTIngredient) {
                StrictNBTIngredient strict1 = (StrictNBTIngredient)first;
                if (second instanceof StrictNBTIngredientAccessor) {
                    StrictNBTIngredientAccessor strict2 = (StrictNBTIngredientAccessor)second;
                    return strict1.test(strict2.getStack()) ? 0 : 1;
                }
                return 1;
            }
            if (first instanceof IntersectionIngredient) {
                IntersectionIngredient intersection1 = (IntersectionIngredient)first;
                if (second instanceof IntersectionIngredient) {
                    IntersectionIngredient intersection2 = (IntersectionIngredient)second;
                    ArrayList ingredients1 = Lists.newArrayList(((IntersectionIngredientAccessor)intersection1).getChildren());
                    ArrayList ingredients2 = Lists.newArrayList(((IntersectionIngredientAccessor)intersection2).getChildren());
                    if (ingredients1.size() != ingredients2.size()) {
                        return 1;
                    }
                    ingredients1.sort(this);
                    ingredients2.sort(this);
                    for (int i = 0; i < ingredients1.size(); ++i) {
                        Ingredient ingredient2;
                        Ingredient ingredient1 = (Ingredient)ingredients1.get(i);
                        int result = this.compare(ingredient1, ingredient2 = (Ingredient)ingredients2.get(i));
                        if (result == 0) continue;
                        return result;
                    }
                    return 0;
                }
                return 1;
            }
            if (((IngredientAccessor)first).getValues().length != ((IngredientAccessor)second).getValues().length) {
                return 1;
            }
            Ingredient.Value[] values1 = ((IngredientAccessor)first).getValues();
            if (values1.length != (values2 = ((IngredientAccessor)second).getValues()).length) {
                return 1;
            }
            Arrays.parallelSort(values1, INGREDIENT_VALUE_COMPARATOR);
            Arrays.parallelSort(values2, INGREDIENT_VALUE_COMPARATOR);
            for (int i = 0; i < values1.length; ++i) {
                Ingredient.Value value1 = values1[i];
                Ingredient.Value value2 = values2[i];
                int result = INGREDIENT_VALUE_COMPARATOR.compare(value1, value2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    };

    public static boolean ingredientEquals(Ingredient first, Ingredient second) {
        if (first == second) {
            return true;
        }
        if (first instanceof SizedIngredient) {
            SizedIngredient sized1 = (SizedIngredient)first;
            if (second instanceof SizedIngredient) {
                SizedIngredient sized2 = (SizedIngredient)second;
                return IngredientEquality.cmp(sized1.getInner(), sized2.getInner());
            }
            return IngredientEquality.cmp(sized1, second);
        }
        if (second instanceof SizedIngredient) {
            SizedIngredient sized2 = (SizedIngredient)second;
            return IngredientEquality.cmp(first, sized2.getInner());
        }
        return IngredientEquality.cmp(first, second);
    }

    private static boolean cmp(Ingredient first, Ingredient second) {
        return INGREDIENT_COMPARATOR.compare(first, second) == 0;
    }
}

