/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.steam.SimpleSteamMachine;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableSteamMachineRenderer;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.gregtechceu.gtceu.integration.kjs.builders.machine.MachineFunctionPresets;
import com.gregtechceu.gtceu.utils.FormattingUtil;

public class SteamMachineBuilder
extends MachineBuilder<MachineDefinition> {
    public SteamMachineBuilder(String id, boolean isHighPressure, Object ... args) {
        super(GTRegistration.REGISTRATE, id, MachineDefinition::createDefinition, (IMachineBlockEntity holder) -> new SimpleSteamMachine((IMachineBlockEntity)holder, isHighPressure, args), MetaMachineBlock::new, MetaMachineItem::new, MetaMachineBlockEntity::createBlockEntity);
    }

    public static <T extends MachineBuilder<? extends MachineDefinition>> void simple(T builder, int tier) {
        builder.langValue("%s %s %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName(builder.id.m_135815_()), GTValues.VLVT[tier])).rotationState(RotationState.NON_Y_AXIS).recipeModifier(SimpleSteamMachine::recipeModifier).renderer(() -> new WorkableSteamMachineRenderer(tier > 0, GTCEu.id("block/machines/" + builder.id.m_135815_())));
    }

    private static SteamMachineBuilder[] createBuilder(String name, boolean hasHighPressure, Object ... args) {
        SteamMachineBuilder[] steamMachineBuilderArray;
        SteamMachineBuilder lp = new SteamMachineBuilder("lp_" + name, false, args);
        if (hasHighPressure) {
            SteamMachineBuilder[] steamMachineBuilderArray2 = new SteamMachineBuilder[2];
            steamMachineBuilderArray2[0] = lp;
            steamMachineBuilderArray = steamMachineBuilderArray2;
            steamMachineBuilderArray2[1] = new SteamMachineBuilder("hp_" + name, true, args);
        } else {
            SteamMachineBuilder[] steamMachineBuilderArray3 = new SteamMachineBuilder[1];
            steamMachineBuilderArray = steamMachineBuilderArray3;
            steamMachineBuilderArray3[0] = lp;
        }
        return steamMachineBuilderArray;
    }

    public static MachineBuilder<MachineDefinition> createBoth(String name, Object ... args) {
        MachineBuilder[] builders;
        if (args.length > 0) {
            boolean hasHighPressure;
            Object[] argsCopy;
            Object object = args[0];
            if (object instanceof Boolean) {
                Boolean hasHP = (Boolean)object;
                argsCopy = MachineFunctionPresets.copyArgs(args, 1);
                hasHighPressure = hasHP;
            } else {
                argsCopy = args;
                hasHighPressure = true;
            }
            builders = SteamMachineBuilder.createBuilder(name, hasHighPressure, argsCopy);
        } else {
            builders = SteamMachineBuilder.createBuilder(name, true, args);
        }
        return MachineFunctionPresets.builder((String)name, (MachineBuilder[])builders, SteamMachineBuilder.class, MachineDefinition::createDefinition, MetaMachineBlock::new, MetaMachineBlockEntity::createBlockEntity);
    }
}

