/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs;

import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.Context;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FunctionalInterface
public interface Validator {
    public ValidationResult run(ResourceLocation var1);

    public static void validate(ResourceLocation id, Validator ... validators) {
        long errors = Arrays.stream(validators).map(validator -> validator.run(id)).filter(result -> result == ValidationResult.ERROR).count();
        if (errors > 0L) {
            ConsoleJS.getCurrent((Context)null).error((Object)"VALIDATION FAILED! Cannot build %s".formatted(id));
            throw new IllegalStateException("Validation failed for %s. Please check your KubeJS logs for details.".formatted(id));
        }
    }

    public static Validator onlySetDefault(@Nullable Object value, Runnable defaultSetter) {
        return id -> {
            if (value != null) {
                return ValidationResult.SUCCESS;
            }
            defaultSetter.run();
            return ValidationResult.SILENT;
        };
    }

    public static Validator warnRecommendedIfNull(@Nullable Object value, String name) {
        return Validator.warnRecommendedIfNull(value, name, () -> {});
    }

    public static Validator warnRecommendedIfNull(@Nullable Object value, String name, Runnable defaultSetter) {
        return id -> {
            if (value != null) {
                return ValidationResult.SUCCESS;
            }
            ConsoleJS.getCurrent((Context)null).warn((Object)"Value %s is not defined in %s. It is recommended to set a value.".formatted(name, id));
            defaultSetter.run();
            return ValidationResult.WARNING;
        };
    }

    public static Validator warnDefaultIfNull(@Nullable Object value, String name, Runnable defaultSetter) {
        return Validator.warnDefaultIfNull(value, name, null, defaultSetter);
    }

    public static Validator warnDefaultIfNull(@Nullable Object value, String name, @Nullable String defaultExplanation, Runnable defaultSetter) {
        return id -> {
            if (value != null) {
                return ValidationResult.SUCCESS;
            }
            String explanation = defaultExplanation != null ? defaultExplanation : "Using a default value.";
            ConsoleJS.getCurrent((Context)null).warn((Object)"Value %s is not defined in %s. %s".formatted(name, id, explanation));
            defaultSetter.run();
            return ValidationResult.WARNING;
        };
    }

    public static Validator errorIfNull(@Nullable Object value, String name) {
        return id -> {
            if (value != null) {
                return ValidationResult.SUCCESS;
            }
            String message = "Cannot build %s: %s is not set.".formatted(id, name);
            ConsoleJS.getCurrent((Context)null).error((Object)message);
            return ValidationResult.ERROR;
        };
    }

    public static enum ValidationResult {
        SUCCESS,
        SILENT,
        WARNING,
        ERROR;

    }
}

