/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.integration.jade.provider.CapabilityBlockProvider;
import com.gregtechceu.gtceu.utils.GTUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class RecipeLogicProvider
extends CapabilityBlockProvider<RecipeLogic> {
    public RecipeLogicProvider() {
        super(GTCEu.id("recipe_logic_provider"));
    }

    @Override
    @Nullable
    protected RecipeLogic getCapability(Level level, BlockPos pos, @Nullable Direction side) {
        return GTCapabilityHelper.getRecipeLogic(level, pos, side);
    }

    @Override
    protected void write(CompoundTag data, RecipeLogic capability) {
        data.m_128379_("Working", capability.isWorking());
        CompoundTag recipeInfo = new CompoundTag();
        GTRecipe recipe = capability.getLastRecipe();
        if (recipe != null) {
            long EUt = RecipeHelper.getInputEUt(recipe);
            boolean isInput = true;
            if (EUt == 0L) {
                isInput = false;
                EUt = RecipeHelper.getOutputEUt(recipe);
            }
            recipeInfo.m_128356_("EUt", EUt);
            recipeInfo.m_128379_("isInput", isInput);
        }
        if (!recipeInfo.m_128456_()) {
            data.m_128365_("Recipe", (Tag)recipeInfo);
        }
        IRecipeLogicMachine machine = capability.machine;
    }

    @Override
    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor block, BlockEntity blockEntity, IPluginConfig config) {
        CompoundTag recipeInfo;
        if (capData.m_128471_("Working") && !(recipeInfo = capData.m_128469_("Recipe")).m_128456_()) {
            long EUt = recipeInfo.m_128454_("EUt");
            boolean isInput = recipeInfo.m_128471_("isInput");
            long absEUt = Math.abs(EUt);
            byte tier = GTUtil.getTierByVoltage(absEUt);
            MutableComponent text = Component.m_237113_((String)Long.toString(absEUt)).m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237113_((String)" EU/t").m_130940_(ChatFormatting.RESET).m_7220_((Component)Component.m_237113_((String)" (").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)GTValues.VNF[tier]).m_130938_(style -> style.m_178520_(GTValues.VC[tier]))).m_7220_((Component)Component.m_237113_((String)")").m_130940_(ChatFormatting.GREEN))));
            if (EUt > 0L) {
                if (isInput) {
                    tooltip.add((Component)Component.m_237115_((String)"gtceu.top.energy_consumption").m_130946_(" ").m_7220_((Component)text));
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"gtceu.top.energy_production").m_130946_(" ").m_7220_((Component)text));
                }
            }
        }
    }
}

