/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.util;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.google.common.collect.Lists;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.AEConfigWidget;
import com.gregtechceu.gtceu.integration.ae2.machine.MEInputHatchPartMachine;
import com.gregtechceu.gtceu.integration.ae2.util.AEConfigSlot;
import com.gregtechceu.gtceu.integration.ae2.util.ExportOnlyAESlot;
import com.gregtechceu.gtceu.integration.ae2.util.IConfigurableSlot;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.ingredient.Target;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.lowdragmc.lowdraglib.side.fluid.FluidActionResult;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class AEFluidConfigSlot
extends AEConfigSlot {
    public static final int LOAD_PHANTOM_FLUID_STACK_FROM_NBT = 13;

    public AEFluidConfigSlot(int x, int y, AEConfigWidget widget, int index) {
        super(new Position(x, y), new Size(18, 36), widget, index);
    }

    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        String amountStr;
        FluidStack stack;
        AEFluidKey key;
        AEKey aEKey;
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        GenericStack config = slot.getConfig();
        GenericStack stock = slot.getStock();
        GuiTextures.FLUID_SLOT.draw(graphics, mouseX, mouseY, (float)position.x, (float)position.y, 18, 18);
        GuiTextures.FLUID_SLOT.draw(graphics, mouseX, mouseY, (float)position.x, (float)(position.y + 18), 18, 18);
        GuiTextures.CONFIG_ARROW.draw(graphics, mouseX, mouseY, (float)position.x, (float)position.y, 18, 18);
        if (this.select) {
            GuiTextures.SELECT_BOX.draw(graphics, mouseX, mouseY, (float)position.x, (float)position.y, 18, 18);
        }
        int stackX = position.x + 1;
        int stackY = position.y + 1;
        if (config != null) {
            FluidStack fluidStack;
            aEKey = config.what();
            if (aEKey instanceof AEFluidKey) {
                key = (AEFluidKey)aEKey;
                fluidStack = FluidStack.create((Fluid)key.getFluid(), (long)config.amount(), (CompoundTag)key.getTag());
            } else {
                fluidStack = FluidStack.empty();
            }
            stack = fluidStack;
            DrawerHelper.drawFluidForGui((GuiGraphics)graphics, (FluidStack)stack, (long)config.amount(), (int)stackX, (int)stackY, (int)17, (int)17);
            amountStr = TextFormattingUtil.formatLongToCompactString((long)config.amount(), (int)4) + "mB";
            DrawerHelper.drawStringFixedCorner((GuiGraphics)graphics, (String)amountStr, (float)(stackX + 17), (float)(stackY + 17), (int)0xFFFFFF, (boolean)true, (float)0.5f);
        }
        if (stock != null) {
            FluidStack fluidStack;
            aEKey = stock.what();
            if (aEKey instanceof AEFluidKey) {
                key = (AEFluidKey)aEKey;
                fluidStack = FluidStack.create((Fluid)key.getFluid(), (long)stock.amount(), (CompoundTag)key.getTag());
            } else {
                fluidStack = FluidStack.empty();
            }
            stack = fluidStack;
            DrawerHelper.drawFluidForGui((GuiGraphics)graphics, (FluidStack)stack, (long)stock.amount(), (int)stackX, (int)(stackY + 18), (int)17, (int)17);
            amountStr = TextFormattingUtil.formatLongToCompactString((long)stock.amount(), (int)4) + "mB";
            DrawerHelper.drawStringFixedCorner((GuiGraphics)graphics, (String)amountStr, (float)(stackX + 17), (float)(stackY + 18 + 17), (int)0xFFFFFF, (boolean)true, (float)0.5f);
        }
        if (this.mouseOverConfig(mouseX, mouseY)) {
            AEFluidConfigSlot.drawSelectionOverlay(graphics, stackX, stackY, 16, 16);
        } else if (this.mouseOverStock(mouseX, mouseY)) {
            AEFluidConfigSlot.drawSelectionOverlay(graphics, stackX, stackY + 18, 16, 16);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.mouseOverConfig(mouseX, mouseY)) {
            if (button == 1) {
                this.parentWidget.disableAmount();
                this.writeClientAction(1000, buf -> {});
            } else if (button == 0) {
                ItemStack hold = this.gui.getModularUIContainer().m_142621_();
                FluidStack fluid = FluidTransferHelper.getFluidContained((ItemStack)hold);
                if (fluid != null) {
                    this.writeClientAction(1001, buf -> {
                        buf.m_130085_(BuiltInRegistries.f_257020_.m_7981_((Object)fluid.getFluid()));
                        buf.m_130103_(fluid.getAmount());
                    });
                }
                this.parentWidget.enableAmount(this.index);
                this.select = true;
            }
            return true;
        }
        if (this.mouseOverStock(mouseX, mouseY) && button == 0) {
            GenericStack stack = this.parentWidget.getDisplay(this.index).getStock();
            if (stack != null) {
                this.writeClientAction(1003, buf -> buf.writeBoolean(AEFluidConfigSlot.isShiftDown()));
            }
            return true;
        }
        return false;
    }

    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        boolean isShiftKeyDown;
        int clickResult;
        FluidStack fluid;
        super.handleClientAction(id, buffer);
        IConfigurableSlot slot = this.parentWidget.getConfig(this.index);
        if (id == 1000) {
            slot.setConfig(null);
            this.parentWidget.disableAmount();
            this.writeUpdateInfo(1000, buf -> {});
        }
        if (id == 1001) {
            fluid = FluidStack.create((Fluid)((Fluid)BuiltInRegistries.f_257020_.m_7745_(buffer.m_130281_())), (long)buffer.m_130258_());
            slot.setConfig(new GenericStack((AEKey)AEFluidKey.of((Fluid)fluid.getFluid()), fluid.getAmount()));
            this.parentWidget.enableAmount(this.index);
            if (fluid != FluidStack.empty()) {
                this.writeUpdateInfo(1001, buf -> {
                    buf.m_130085_(BuiltInRegistries.f_257020_.m_7981_((Object)fluid.getFluid()));
                    buf.m_130103_(fluid.getAmount());
                });
            }
        }
        if (id == 1002 && slot.getConfig() != null) {
            int amt = buffer.readInt();
            slot.setConfig(ExportOnlyAESlot.copy(slot.getConfig(), amt));
            this.writeUpdateInfo(1002, buf -> buf.writeInt(amt));
        }
        if (id == 1003 && slot.getStock() != null && (clickResult = this.tryClickContainer(isShiftKeyDown = buffer.readBoolean())) >= 0) {
            this.writeUpdateInfo(1003, buf -> buf.m_130130_(clickResult));
        }
        if (id == 13) {
            fluid = FluidStack.loadFromTag((CompoundTag)buffer.m_130260_());
            slot.setConfig(new GenericStack((AEKey)AEFluidKey.of((Fluid)fluid.getFluid()), fluid.getAmount()));
            this.parentWidget.enableAmount(this.index);
            if (fluid != FluidStack.empty()) {
                this.writeUpdateInfo(1001, buf -> {
                    buf.m_130085_(BuiltInRegistries.f_257020_.m_7981_((Object)fluid.getFluid()));
                    buf.m_130103_(fluid.getAmount());
                });
            }
        }
    }

    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        AEKey aEKey;
        super.readUpdateInfo(id, buffer);
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        if (id == 1000) {
            slot.setConfig(null);
        }
        if (id == 1001) {
            FluidStack fluid = FluidStack.create((Fluid)((Fluid)BuiltInRegistries.f_257020_.m_7745_(buffer.m_130281_())), (long)buffer.m_130258_());
            slot.setConfig(new GenericStack((AEKey)AEFluidKey.of((Fluid)fluid.getFluid()), fluid.getAmount()));
        }
        if (id == 1002 && slot.getConfig() != null) {
            int amt = buffer.readInt();
            slot.setConfig(ExportOnlyAESlot.copy(slot.getConfig(), amt));
        }
        if (id == 1003 && slot.getStock() != null && (aEKey = slot.getStock().what()) instanceof AEFluidKey) {
            GenericStack stack1;
            AEFluidKey key = (AEFluidKey)aEKey;
            ItemStack currentStack = this.gui.getModularUIContainer().m_142621_();
            int newStackSize = buffer.m_130242_();
            currentStack.m_41764_(newStackSize);
            this.gui.getModularUIContainer().m_142503_(currentStack);
            FluidStack stack = FluidStack.create((Fluid)key.getFluid(), (long)slot.getStock().amount());
            if (key.hasTag()) {
                stack.setTag(key.getTag().m_6426_());
            }
            slot.setStock((stack1 = ExportOnlyAESlot.copy(slot.getStock(), Math.max(0L, slot.getStock().amount() - stack.getAmount()))).amount() == 0L ? null : stack1);
        }
    }

    @Override
    public List<Target> getPhantomTargets(Object ingredient) {
        if (GTUtil.getFluidFromContainer(ingredient) == null) {
            return Collections.emptyList();
        }
        final Rect2i rectangle = this.toRectangleBox();
        rectangle.m_173058_(rectangle.m_110091_() / 2);
        return Lists.newArrayList((Object[])new Target[]{new Target(){

            @Nonnull
            public Rect2i getArea() {
                return rectangle;
            }

            public void accept(@Nonnull Object ingredient) {
                FluidStack stack = GTUtil.getFluidFromContainer(ingredient);
                if (stack != null) {
                    CompoundTag compound = stack.saveToTag(new CompoundTag());
                    AEFluidConfigSlot.this.writeClientAction(13, buf -> buf.m_130079_(compound));
                }
            }
        }});
    }

    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        long amt;
        FluidStack fluid;
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        Rect2i rectangle = this.toRectangleBox();
        rectangle.m_173058_(rectangle.m_110091_() / 2);
        if (slot.getConfig() == null || wheelDelta == 0.0 || !rectangle.m_110087_((int)mouseX, (int)mouseY)) {
            return false;
        }
        AEKey aEKey = slot.getConfig().what();
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)aEKey;
            v0 = FluidStack.create((Fluid)fluidKey.getFluid(), (long)slot.getConfig().amount(), (CompoundTag)fluidKey.getTag());
        } else {
            v0 = fluid = FluidStack.empty();
        }
        if (AEFluidConfigSlot.isCtrlDown()) {
            amt = wheelDelta > 0.0 ? fluid.getAmount() * 2L : fluid.getAmount() / 2L;
        } else {
            long l = amt = wheelDelta > 0.0 ? fluid.getAmount() + 1L : fluid.getAmount() - 1L;
        }
        if (amt > 0L && amt < 0x80000000L) {
            int finalAmt = (int)amt;
            this.writeClientAction(1002, buf -> buf.writeInt(finalAmt));
            return true;
        }
        return false;
    }

    private int tryClickContainer(boolean isShiftKeyDown) {
        int maxAttempts;
        MEInputHatchPartMachine.ExportOnlyAEFluid fluid;
        MEInputHatchPartMachine.ExportOnlyAEFluid fluidTank;
        IConfigurableSlot iConfigurableSlot = this.parentWidget.getConfig(this.index);
        MEInputHatchPartMachine.ExportOnlyAEFluid exportOnlyAEFluid = fluidTank = iConfigurableSlot instanceof MEInputHatchPartMachine.ExportOnlyAEFluid ? (fluid = (MEInputHatchPartMachine.ExportOnlyAEFluid)iConfigurableSlot) : null;
        if (fluidTank == null) {
            return -1;
        }
        Player player = this.gui.entityPlayer;
        ItemStack currentStack = this.gui.getModularUIContainer().m_142621_();
        IFluidTransfer handler = FluidTransferHelper.getFluidTransfer((Player)this.gui.entityPlayer, (AbstractContainerMenu)this.gui.getModularUIContainer());
        if (handler == null) {
            return -1;
        }
        int n = maxAttempts = isShiftKeyDown ? currentStack.m_41613_() : 1;
        if (fluidTank.getFluidAmount() > 0L) {
            FluidActionResult result;
            boolean performedFill = false;
            FluidStack initialFluid = fluidTank.getFluid();
            for (int i = 0; i < maxAttempts && (result = FluidTransferHelper.tryFillContainer((ItemStack)currentStack, (IFluidTransfer)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)false)).isSuccess(); ++i) {
                ItemStack remainingStack = FluidTransferHelper.tryFillContainer((ItemStack)currentStack, (IFluidTransfer)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)true).getResult();
                currentStack.m_41774_(1);
                performedFill = true;
                if (remainingStack.m_41619_() || player.m_36356_(remainingStack)) continue;
                Block.m_49840_((Level)player.m_9236_(), (BlockPos)player.m_20097_(), (ItemStack)remainingStack);
                break;
            }
            if (performedFill) {
                SoundEvent soundevent = FluidHelper.getFillSound((FluidStack)initialFluid);
                if (soundevent != null) {
                    player.m_9236_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_ + 0.5, player.m_20182_().f_82481_, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.gui.getModularUIContainer().m_142503_(currentStack);
                return currentStack.m_41613_();
            }
        }
        return -1;
    }
}

