/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc.alloyblast;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.BlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GCyMRecipeTypes;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.CraftingComponent;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.level.material.Fluid;

public class AlloyBlastRecipeProducer {
    public static final AlloyBlastRecipeProducer DEFAULT_PRODUCER = new AlloyBlastRecipeProducer();

    public void produce(@Nonnull Material material, @Nonnull BlastProperty property, Consumer<FinishedRecipe> provider) {
        Fluid molten;
        if (material.hasFlag(MaterialFlags.DISABLE_ALLOY_BLAST)) {
            return;
        }
        int componentAmount = material.getMaterialComponents().size();
        if (componentAmount < 2) {
            return;
        }
        if (TagPrefix.ingotHot.doGenerateItem(material)) {
            molten = GTUtil.getMoltenFluid(material);
            this.addFreezerRecipes(material, molten, property.getBlastTemperature(), provider);
        } else {
            molten = material.getFluid();
        }
        if (molten == null) {
            return;
        }
        GTRecipeBuilder builder = this.createBuilder(property, material);
        int outputAmount = this.addInputs(material, builder);
        if (outputAmount <= 0) {
            return;
        }
        this.buildRecipes(property, molten, outputAmount, componentAmount, builder, provider);
    }

    @Nonnull
    protected GTRecipeBuilder createBuilder(@Nonnull BlastProperty property, @Nonnull Material material) {
        GTRecipeBuilder builder = GCyMRecipeTypes.ALLOY_BLAST_RECIPES.recipeBuilder(material.getName(), new Object[0]);
        int duration = property.getDurationOverride();
        if (duration < 0) {
            duration = Math.max(1, (int)(material.getMass() * (long)property.getBlastTemperature() / 100L));
        }
        builder.duration(duration);
        int EUt = property.getEUtOverride();
        if (EUt < 0) {
            EUt = GTValues.VA[2];
        }
        builder.EUt(EUt);
        return builder.blastFurnaceTemp(property.getBlastTemperature());
    }

    protected int addInputs(@Nonnull Material material, @Nonnull GTRecipeBuilder builder) {
        int outputAmount = 0;
        int fluidAmount = 0;
        for (MaterialStack materialStack : material.getMaterialComponents()) {
            Material msMat = materialStack.material();
            int msAmount = (int)materialStack.amount();
            if (msMat.hasProperty(PropertyKey.DUST)) {
                builder.inputItems(TagPrefix.dust, msMat, msAmount);
            } else if (msMat.hasProperty(PropertyKey.FLUID)) {
                if (fluidAmount >= 2) {
                    return -1;
                }
                ++fluidAmount;
                builder.inputFluids(msMat.getFluid(1000L * (long)msAmount));
            } else {
                return -1;
            }
            outputAmount += msAmount;
        }
        return outputAmount;
    }

    protected void buildRecipes(@Nonnull BlastProperty property, @Nonnull Fluid molten, int outputAmount, int componentAmount, @Nonnull GTRecipeBuilder builder, Consumer<FinishedRecipe> provider) {
        builder.outputFluids(FluidStack.create((Fluid)molten, (long)(144L * (long)outputAmount)));
        int duration = builder.duration * outputAmount * 3 / 4;
        if (property.getGasTier() != null) {
            GTRecipeBuilder builderGas = builder.copy(builder.id.m_135815_() + "_gas");
            FluidIngredient gas = CraftingComponent.EBF_GASES.get((Object)property.getGasTier()).copy();
            gas.setAmount(gas.getAmount() * (long)outputAmount);
            builderGas.circuitMeta(this.getGasCircuitNum(componentAmount)).inputFluids(gas).duration((int)((double)duration * 0.67)).save(provider);
        }
        builder.circuitMeta(this.getCircuitNum(componentAmount)).duration(duration).save(provider);
    }

    protected int getCircuitNum(int componentAmount) {
        return componentAmount;
    }

    protected int getGasCircuitNum(int componentAmount) {
        return componentAmount + 10;
    }

    protected void addFreezerRecipes(@Nonnull Material material, @Nonnull Fluid molten, int temperature, Consumer<FinishedRecipe> provider) {
        GTRecipeBuilder freezerBuilder = GTRecipeTypes.VACUUM_RECIPES.recipeBuilder(material.getName(), new Object[0]).inputFluids(FluidStack.create((Fluid)molten, (long)144L)).duration((int)material.getMass() * 3).notConsumable(GTItems.SHAPE_MOLD_INGOT.asStack()).outputItems(TagPrefix.ingot, material);
        if (temperature >= 5000) {
            freezerBuilder.inputFluids(GTMaterials.Helium.getFluid(FluidStorageKeys.LIQUID, 500L)).outputFluids(GTMaterials.Helium.getFluid(250L));
        }
        freezerBuilder.save(provider);
    }
}

