/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterials;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.BlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.DustProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.GemProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IngotProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CraftingComponent;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MaterialRecipeHandler {
    private static final List<TagPrefix> GEM_ORDER = ConfigHolder.INSTANCE.recipes.generateLowQualityGems ? Arrays.asList(TagPrefix.gemChipped, TagPrefix.gemFlawed, TagPrefix.gem, TagPrefix.gemFlawless, TagPrefix.gemExquisite) : Arrays.asList(TagPrefix.gem, TagPrefix.gemFlawless, TagPrefix.gemExquisite);

    public static void init(Consumer<FinishedRecipe> provider) {
        TagPrefix.ingot.executeHandler(PropertyKey.INGOT, (tagPrefix, material, property) -> MaterialRecipeHandler.processIngot(tagPrefix, material, property, provider));
        TagPrefix.nugget.executeHandler(PropertyKey.DUST, (tagPrefix, material, property) -> MaterialRecipeHandler.processNugget(tagPrefix, material, property, provider));
        TagPrefix.block.executeHandler(PropertyKey.DUST, (tagPrefix, material, property) -> MaterialRecipeHandler.processBlock(tagPrefix, material, property, provider));
        TagPrefix.frameGt.executeHandler(PropertyKey.DUST, (tagPrefix, material, property) -> MaterialRecipeHandler.processFrame(tagPrefix, material, property, provider));
        TagPrefix.dust.executeHandler(PropertyKey.DUST, (tagPrefix, material, property) -> MaterialRecipeHandler.processDust(tagPrefix, material, property, provider));
        TagPrefix.dustSmall.executeHandler(PropertyKey.DUST, (tagPrefix, material, property) -> MaterialRecipeHandler.processSmallDust(tagPrefix, material, property, provider));
        TagPrefix.dustTiny.executeHandler(PropertyKey.DUST, (tagPrefix, material, property) -> MaterialRecipeHandler.processTinyDust(tagPrefix, material, property, provider));
        for (TagPrefix orePrefix : GEM_ORDER) {
            orePrefix.executeHandler(PropertyKey.GEM, (tagPrefix, material, property) -> MaterialRecipeHandler.processGemConversion(tagPrefix, material, property, provider));
        }
    }

    public static void processDust(TagPrefix dustPrefix, Material mat, DustProperty property, Consumer<FinishedRecipe> provider) {
        OreProperty oreProperty;
        String id = "%s_%s_".formatted(FormattingUtil.toLowerCaseUnder(dustPrefix.name), mat.getName().toLowerCase(Locale.ROOT));
        ItemStack dustStack = ChemicalHelper.get(dustPrefix, mat);
        OreProperty oreProperty2 = oreProperty = mat.hasProperty(PropertyKey.ORE) ? mat.getProperty(PropertyKey.ORE) : null;
        if (mat.hasProperty(PropertyKey.GEM)) {
            Material smeltingResult;
            ItemStack gemStack = ChemicalHelper.get(TagPrefix.gem, mat);
            if (mat.hasFlag(MaterialFlags.CRYSTALLIZABLE)) {
                GTRecipeTypes.AUTOCLAVE_RECIPES.recipeBuilder("autoclave_" + id + "_water", new Object[0]).inputItems(dustStack).inputFluids(GTMaterials.Water.getFluid(250L)).chancedOutput(gemStack, 7000, 1000).duration(1200).EUt(24L).save(provider);
                GTRecipeTypes.AUTOCLAVE_RECIPES.recipeBuilder("autoclave_" + id + "_distilled", new Object[0]).inputItems(dustStack).inputFluids(GTMaterials.DistilledWater.getFluid(50L)).outputItems(gemStack).duration(600).EUt(24L).save(provider);
            }
            if (!mat.hasFlag(MaterialFlags.EXPLOSIVE) && !mat.hasFlag(MaterialFlags.FLAMMABLE)) {
                GTRecipeTypes.IMPLOSION_RECIPES.recipeBuilder("implode_" + id + "_tnt", new Object[0]).inputItems(GTUtil.copyAmount(4, dustStack)).outputItems(GTUtil.copyAmount(3, gemStack)).chancedOutput(TagPrefix.dust, GTMaterials.DarkAsh, 2500, 0).explosivesAmount(2).save(provider);
            }
            if (oreProperty != null && (smeltingResult = oreProperty.getDirectSmeltResult()) != null) {
                VanillaRecipeHelper.addSmeltingRecipe(provider, id + "_ingot", ChemicalHelper.getTag(dustPrefix, mat), ChemicalHelper.get(TagPrefix.ingot, smeltingResult));
            }
        } else if (mat.hasProperty(PropertyKey.INGOT)) {
            if (!mat.hasAnyOfFlags(MaterialFlags.FLAMMABLE, MaterialFlags.NO_SMELTING)) {
                int blastTemp;
                Material smeltingResult;
                boolean hasHotIngot = TagPrefix.ingotHot.doGenerateItem(mat);
                ItemStack ingotStack = ChemicalHelper.get(hasHotIngot ? TagPrefix.ingotHot : TagPrefix.ingot, mat);
                if (ingotStack.m_41619_() && oreProperty != null && (smeltingResult = oreProperty.getDirectSmeltResult()) != null) {
                    ingotStack = ChemicalHelper.get(TagPrefix.ingot, smeltingResult);
                }
                if ((blastTemp = mat.getBlastTemperature()) <= 0) {
                    if (!mat.hasFlag(MaterialFlags.IS_MAGNETIC)) {
                        VanillaRecipeHelper.addSmeltingRecipe(provider, id + "_demagnetize_from_dust", ChemicalHelper.getTag(dustPrefix, mat), ingotStack);
                    }
                } else {
                    IngotProperty ingotProperty = mat.getProperty(PropertyKey.INGOT);
                    BlastProperty blastProperty = mat.getProperty(PropertyKey.BLAST);
                    MaterialRecipeHandler.processEBFRecipe(mat, blastProperty, ingotStack, provider);
                    if (ingotProperty.getMagneticMaterial() != null) {
                        MaterialRecipeHandler.processEBFRecipe(ingotProperty.getMagneticMaterial(), blastProperty, ingotStack, provider);
                    }
                }
            }
        } else {
            ItemStack ingotStack;
            Material smeltingResult;
            if (mat.hasFlag(MaterialFlags.GENERATE_PLATE) && !mat.hasFlag(MaterialFlags.EXCLUDE_PLATE_COMPRESSOR_RECIPE)) {
                GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compress_plate_" + id, new Object[0]).inputItems(dustStack).outputItems(TagPrefix.plate, mat).save(provider);
            }
            if (oreProperty != null && (smeltingResult = oreProperty.getDirectSmeltResult()) != null && !(ingotStack = ChemicalHelper.get(TagPrefix.ingot, smeltingResult)).m_41619_()) {
                VanillaRecipeHelper.addSmeltingRecipe(provider, id + "_dust_to_ingot", ChemicalHelper.getTag(dustPrefix, mat), ingotStack);
            }
        }
    }

    private static void processEBFRecipe(Material material, BlastProperty property, ItemStack output, Consumer<FinishedRecipe> provider) {
        int EUt;
        int blastTemp = property.getBlastTemperature();
        BlastProperty.GasTier gasTier = property.getGasTier();
        int duration = property.getDurationOverride();
        if (duration <= 0) {
            duration = Math.max(1, (int)(material.getMass() * (long)blastTemp / 50L));
        }
        if ((EUt = property.getEUtOverride()) <= 0) {
            EUt = GTValues.VA[2];
        }
        GTRecipeBuilder blastBuilder = GTRecipeTypes.BLAST_RECIPES.recipeBuilder("blast_" + material.getName(), new Object[0]).inputItems(TagPrefix.dust, material).outputItems(output).blastFurnaceTemp(blastTemp).EUt(EUt);
        if (gasTier != null) {
            FluidIngredient gas = CraftingComponent.EBF_GASES.get((Object)gasTier).copy();
            blastBuilder.copy("blast_" + material.getName()).circuitMeta(1).duration(duration).save(provider);
            blastBuilder.copy("blast_" + material.getName() + "_gas").circuitMeta(2).inputFluids(gas).duration((int)((double)duration * 0.67)).save(provider);
        } else {
            blastBuilder.duration(duration);
            if (material == GTMaterials.Silicon) {
                blastBuilder.circuitMeta(1);
            }
            blastBuilder.save(provider);
        }
        if (TagPrefix.ingotHot.doGenerateItem(material)) {
            if (blastTemp < 5000) {
                GTRecipeTypes.VACUUM_RECIPES.recipeBuilder("cool_hot_" + material.getName() + "_ingot", new Object[0]).inputItems(TagPrefix.ingotHot, material).outputItems(TagPrefix.ingot, material).duration((int)material.getMass() * 3).save(provider);
            } else {
                GTRecipeTypes.VACUUM_RECIPES.recipeBuilder("cool_hot_" + material.getName() + "_ingot", new Object[0]).inputItems(TagPrefix.ingotHot, material).inputFluids(GTMaterials.Helium.getFluid(FluidStorageKeys.LIQUID, 500L)).outputItems(TagPrefix.ingot, material).outputFluids(GTMaterials.Helium.getFluid(250L)).duration((int)material.getMass() * 3).save(provider);
            }
        }
    }

    public static void processSmallDust(TagPrefix orePrefix, Material material, DustProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack smallDustStack = ChemicalHelper.get(orePrefix, material);
        ItemStack dustStack = ChemicalHelper.get(TagPrefix.dust, material);
        VanillaRecipeHelper.addStrictShapedRecipe(provider, String.format("small_dust_disassembling_%s", material.getName()), GTUtil.copyAmount(4, smallDustStack), " X ", "   ", "   ", Character.valueOf('X'), new UnificationEntry(TagPrefix.dust, material));
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("small_dust_assembling_%s", material.getName()), dustStack, "XX", "XX", Character.valueOf('X'), new UnificationEntry(orePrefix, material));
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("package_" + material.getName() + "_small_dust", new Object[0]).inputItems(orePrefix, material, 4).circuitMeta(1).outputItems(dustStack).save(provider);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("unpackage_" + material.getName() + "_small_dust", new Object[0]).inputItems(TagPrefix.dust, material).circuitMeta(2).outputItems(GTUtil.copyAmount(4, smallDustStack)).save(provider);
    }

    public static void processTinyDust(TagPrefix orePrefix, Material material, DustProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack tinyDustStack = ChemicalHelper.get(orePrefix, material);
        ItemStack dustStack = ChemicalHelper.get(TagPrefix.dust, material);
        VanillaRecipeHelper.addStrictShapedRecipe(provider, String.format("tiny_dust_disassembling_%s", material.getName()), GTUtil.copyAmount(9, tinyDustStack), "X  ", "   ", "   ", Character.valueOf('X'), new UnificationEntry(TagPrefix.dust, material));
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("tiny_dust_assembling_%s", material.getName()), dustStack, "XXX", "XXX", "XXX", Character.valueOf('X'), new UnificationEntry(orePrefix, material));
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("package_" + material.getName() + "_tiny_dust", new Object[0]).inputItems(orePrefix, material, 9).circuitMeta(1).outputItems(dustStack).save(provider);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("unpackage_" + material.getName() + "_tiny_dust", new Object[0]).inputItems(TagPrefix.dust, material).circuitMeta(1).outputItems(GTUtil.copyAmount(9, tinyDustStack)).save(provider);
    }

    public static void processIngot(TagPrefix ingotPrefix, Material material, IngotProperty property, Consumer<FinishedRecipe> provider) {
        if (material.hasFlag(MaterialFlags.MORTAR_GRINDABLE)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("mortar_grind_%s", material.getName()), ChemicalHelper.get(TagPrefix.dust, material), "X", "m", Character.valueOf('X'), new UnificationEntry(ingotPrefix, material));
        }
        if (material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("stick_%s", material.getName()), ChemicalHelper.get(TagPrefix.rod, material), "f ", " X", Character.valueOf('X'), new UnificationEntry(ingotPrefix, material));
            if (!material.hasFlag(MaterialFlags.NO_WORKING)) {
                GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_to_rod", new Object[0]).inputItems(ingotPrefix, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_ROD).outputItems(TagPrefix.rod, material, 2).duration((int)material.getMass() * 2).EUt(6L * (long)MaterialRecipeHandler.getVoltageMultiplier(material)).save(provider);
            }
        }
        if (material.hasFluid()) {
            GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_ingot", new Object[0]).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_INGOT).inputFluids(material.getFluid(144L)).outputItems(ingotPrefix, material).duration(20).EUt(GTValues.VA[0]).save(provider);
        }
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_to_ingot", new Object[0]).inputItems(TagPrefix.dust, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_INGOT).outputItems(TagPrefix.ingot, material).duration(10).EUt(4L * (long)MaterialRecipeHandler.getVoltageMultiplier(material)).save(provider);
        }
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("alloy_smelt_" + material.getName() + "_to_nugget", new Object[0]).EUt(GTValues.VA[0]).duration((int)material.getMass()).inputItems(TagPrefix.ingot, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_NUGGET).outputItems(TagPrefix.nugget, material, 9).save(provider);
        if (!ChemicalHelper.get(TagPrefix.block, material).m_41619_()) {
            GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("alloy_smelt_" + material.getName() + "_to_ingot", new Object[0]).EUt(GTValues.VA[0]).duration((int)material.getMass() * 9).inputItems(TagPrefix.block, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_INGOT).outputItems(TagPrefix.ingot, material, 9).save(provider);
            GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compress_" + material.getName() + "_to_block", new Object[0]).EUt(2L).duration(300).inputItems(TagPrefix.ingot, material, (int)(TagPrefix.block.getMaterialAmount(material) / 3628800L)).outputItems(TagPrefix.block, material).save(provider);
        }
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE) && !material.hasFlag(MaterialFlags.NO_WORKING)) {
            ItemStack plateStack;
            if (!material.hasFlag(MaterialFlags.NO_SMASHING) && !(plateStack = ChemicalHelper.get(TagPrefix.plate, material)).m_41619_()) {
                GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_to_plate", new Object[0]).circuitMeta(1).inputItems(ingotPrefix, material).outputItems(plateStack).EUt(24L).duration((int)material.getMass()).save(provider);
                GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_to_plate", new Object[0]).inputItems(ingotPrefix, material, 3).outputItems(GTUtil.copyAmount(2, plateStack)).EUt(16L).duration((int)material.getMass()).save(provider);
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("plate_%s", material.getName()), plateStack, "h", "I", "I", Character.valueOf('I'), new UnificationEntry(ingotPrefix, material));
            }
            int voltageMultiplier = MaterialRecipeHandler.getVoltageMultiplier(material);
            if (!ChemicalHelper.get(TagPrefix.plate, material).m_41619_()) {
                GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_to_plate", new Object[0]).inputItems(ingotPrefix, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PLATE).outputItems(TagPrefix.plate, material).duration((int)material.getMass()).EUt(8L * (long)voltageMultiplier).save(provider);
                if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                    GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_plate", new Object[0]).inputItems(TagPrefix.dust, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PLATE).outputItems(TagPrefix.plate, material).duration((int)material.getMass()).EUt(8L * (long)voltageMultiplier).save(provider);
                }
            }
        }
    }

    public static void processGemConversion(TagPrefix gemPrefix, Material material, GemProperty property, Consumer<FinishedRecipe> provider) {
        TagPrefix prevPrefix;
        ItemStack prevStack;
        long materialAmount = gemPrefix.getMaterialAmount(material);
        ItemStack crushedStack = ChemicalHelper.getDust(material, materialAmount);
        if (material.hasFlag(MaterialFlags.MORTAR_GRINDABLE)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("gem_to_dust_%s_%s", material.getName(), FormattingUtil.toLowerCaseUnder(gemPrefix.name)), crushedStack, "X", "m", Character.valueOf('X'), new UnificationEntry(gemPrefix, material));
        }
        ItemStack itemStack = prevStack = (prevPrefix = (TagPrefix)GTUtil.getItem(GEM_ORDER, GEM_ORDER.indexOf(gemPrefix) - 1, null)) == null ? ItemStack.f_41583_ : ChemicalHelper.get(prevPrefix, material, 2);
        if (!prevStack.m_41619_() && prevPrefix != null) {
            VanillaRecipeHelper.addShapelessRecipe(provider, String.format("gem_to_gem_%s_%s", FormattingUtil.toLowerCaseUnder(prevPrefix.name), material.getName()), prevStack, "h", new UnificationEntry(gemPrefix, material));
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + material.getName() + "_" + FormattingUtil.toLowerCaseUnder(gemPrefix.name) + "_to_" + FormattingUtil.toLowerCaseUnder(prevPrefix.name), new Object[0]).inputItems(gemPrefix, material).outputItems(prevStack).duration(20).EUt(16L).save(provider);
            GTRecipeTypes.LASER_ENGRAVER_RECIPES.recipeBuilder("engrave_" + material.getName() + "_" + FormattingUtil.toLowerCaseUnder(gemPrefix.name) + "_to_" + FormattingUtil.toLowerCaseUnder(prevPrefix.name), new Object[0]).inputItems(prevStack).notConsumable(TagPrefix.lens, MarkerMaterials.Color.White).outputItems(gemPrefix, material).duration(300).EUt(240L).save(provider);
        }
    }

    public static void processNugget(TagPrefix orePrefix, Material material, DustProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack nuggetStack = ChemicalHelper.get(orePrefix, material);
        if (material.hasProperty(PropertyKey.INGOT)) {
            ItemStack ingotStack = ChemicalHelper.get(TagPrefix.ingot, material);
            if (!ConfigHolder.INSTANCE.recipes.disableManualCompression) {
                VanillaRecipeHelper.addShapelessRecipe(provider, String.format("nugget_disassembling_%s", material.getName()), GTUtil.copyAmount(9, nuggetStack), new UnificationEntry(TagPrefix.ingot, material));
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("nugget_assembling_%s", material.getName()), ingotStack, "XXX", "XXX", "XXX", Character.valueOf('X'), new UnificationEntry(orePrefix, material));
            }
            GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compress_" + material.getName() + "_nugget_to_ingot", new Object[0]).inputItems(TagPrefix.nugget, material, 9).outputItems(TagPrefix.ingot, material).EUt(2L).duration(300).save(provider);
            GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("alloy_smelt_" + material.getName() + "_nugget_to_ingot", new Object[0]).EUt(GTValues.VA[0]).duration((int)material.getMass()).inputItems(TagPrefix.nugget, material, 9).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_INGOT).outputItems(TagPrefix.ingot, material).save(provider);
            if (material.hasFluid()) {
                GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_nugget", new Object[0]).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_NUGGET).inputFluids(material.getFluid(144L)).outputItems(orePrefix, material, 9).duration((int)material.getMass()).EUt(GTValues.VA[0]).save(provider);
            }
        } else if (material.hasProperty(PropertyKey.GEM)) {
            ItemStack gemStack = ChemicalHelper.get(TagPrefix.gem, material);
            if (!ConfigHolder.INSTANCE.recipes.disableManualCompression) {
                VanillaRecipeHelper.addShapelessRecipe(provider, String.format("nugget_disassembling_%s", material.getName()), GTUtil.copyAmount(9, nuggetStack), new UnificationEntry(TagPrefix.gem, material));
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("nugget_assembling_%s", material.getName()), gemStack, "XXX", "XXX", "XXX", Character.valueOf('X'), new UnificationEntry(orePrefix, material));
            }
        }
    }

    public static void processFrame(TagPrefix framePrefix, Material material, DustProperty property, Consumer<FinishedRecipe> provider) {
        if (material.hasFlag(MaterialFlags.GENERATE_FRAME)) {
            boolean isWoodenFrame = material.hasProperty(PropertyKey.WOOD);
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("frame_%s", material.getName()), ChemicalHelper.get(framePrefix, material, 2), "SSS", isWoodenFrame ? "SsS" : "SwS", "SSS", Character.valueOf('S'), new UnificationEntry(TagPrefix.rod, material));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assemble_" + material.getName() + "_frame", new Object[0]).inputItems(TagPrefix.rod, material, 4).circuitMeta(4).outputItems(framePrefix, material).EUt(GTValues.VA[0]).duration(64).save(provider);
        }
    }

    public static void processBlock(TagPrefix blockPrefix, Material material, DustProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack plateStack;
        ItemStack blockStack = ChemicalHelper.get(blockPrefix, material);
        long materialAmount = blockPrefix.getMaterialAmount(material);
        if (material.hasFluid()) {
            GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_block", new Object[0]).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).inputFluids(material.getFluid((int)(materialAmount * 144L / 3628800L))).outputItems(blockStack).duration((int)material.getMass()).EUt(GTValues.VA[0]).save(provider);
        }
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE) && !(plateStack = ChemicalHelper.get(TagPrefix.plate, material)).m_41619_()) {
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + material.getName() + "_block_to_plate", new Object[0]).inputItems(blockPrefix, material).outputItems(GTUtil.copyAmount((int)(materialAmount / 3628800L), plateStack)).duration((int)(material.getMass() * 8L)).EUt(GTValues.VA[1]).save(provider);
        }
        UnificationEntry blockEntry = material.hasProperty(PropertyKey.GEM) ? new UnificationEntry(TagPrefix.gem, material) : (material.hasProperty(PropertyKey.INGOT) ? new UnificationEntry(TagPrefix.ingot, material) : new UnificationEntry(TagPrefix.dust, material));
        if (!material.hasFlag(MaterialFlags.EXCLUDE_BLOCK_CRAFTING_RECIPES)) {
            int size = (int)(materialAmount / 3628800L);
            int sizeSqrt = Math.round(Mth.m_14116_((float)size));
            if (!material.hasFlag(MaterialFlags.EXCLUDE_BLOCK_CRAFTING_BY_HAND_RECIPES) && !ConfigHolder.INSTANCE.recipes.disableManualCompression && sizeSqrt * sizeSqrt == size) {
                String patternString = "B".repeat(Math.max(0, sizeSqrt));
                Object[] pattern = new String[sizeSqrt];
                Arrays.fill(pattern, patternString);
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("block_compress_%s", material.getName()), blockStack, pattern, Character.valueOf('B'), blockEntry);
                VanillaRecipeHelper.addShapelessRecipe(provider, String.format("block_decompress_%s", material.getName()), GTUtil.copyAmount(size, ChemicalHelper.get(blockEntry.tagPrefix, blockEntry.material)), new UnificationEntry(blockPrefix, material));
            }
            if (material.hasProperty(PropertyKey.INGOT)) {
                int voltageMultiplier = MaterialRecipeHandler.getVoltageMultiplier(material);
                GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_block", new Object[0]).inputItems(TagPrefix.ingot, material, (int)(materialAmount / 3628800L)).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_BLOCK).outputItems(blockStack).duration(10).EUt(8L * (long)voltageMultiplier).save(provider);
                GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("alloy_smelt_" + material.getName() + "_ingot_to_block", new Object[0]).inputItems(TagPrefix.ingot, material, (int)(materialAmount / 3628800L)).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).outputItems(blockStack).duration(5).EUt(4L * (long)voltageMultiplier).save(provider);
            } else if (material.hasProperty(PropertyKey.GEM)) {
                GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compress_" + material.getName() + "_gem_to_block", new Object[0]).inputItems(TagPrefix.gem, material, (int)(TagPrefix.block.getMaterialAmount(material) / 3628800L)).outputItems(TagPrefix.block, material).duration(300).EUt(2L).save(provider);
                GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_block_to_gem", new Object[0]).inputItems(TagPrefix.block, material).outputItems(TagPrefix.gem, material, (int)(TagPrefix.block.getMaterialAmount(material) / 3628800L)).duration(100).EUt(24L).save(provider);
            }
        }
    }

    private static int getVoltageMultiplier(Material material) {
        return material.getBlastTemperature() >= 2800 ? GTValues.VA[1] : GTValues.VA[0];
    }
}

