/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.laser;

import com.gregtechceu.gtceu.api.capability.ILaserContainer;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.pipenet.PipeNetWalker;
import com.gregtechceu.gtceu.common.blockentity.LaserPipeBlockEntity;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeNet;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeProperties;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserRoutePath;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaserNetWalker
extends PipeNetWalker<LaserPipeBlockEntity, LaserPipeProperties, LaserPipeNet> {
    public static final LaserRoutePath FAILED_MARKER = new LaserRoutePath(null, null, 0);
    private static final Direction[] X_AXIS_FACINGS = new Direction[]{Direction.WEST, Direction.EAST};
    private static final Direction[] Y_AXIS_FACINGS = new Direction[]{Direction.UP, Direction.DOWN};
    private static final Direction[] Z_AXIS_FACINGS = new Direction[]{Direction.NORTH, Direction.SOUTH};
    private LaserRoutePath routePath;
    private BlockPos sourcePipe;
    private Direction facingToHandler;
    private Direction.Axis axis;

    @javax.annotation.Nullable
    public static LaserRoutePath createNetData(LaserPipeNet world, BlockPos sourcePipe, Direction faceToSourceHandler) {
        try {
            LaserNetWalker walker = new LaserNetWalker(world, sourcePipe, 1);
            walker.sourcePipe = sourcePipe;
            walker.facingToHandler = faceToSourceHandler;
            walker.axis = faceToSourceHandler.m_122434_();
            walker.traversePipeNet();
            return walker.routePath;
        }
        catch (Exception e) {
            return FAILED_MARKER;
        }
    }

    protected LaserNetWalker(LaserPipeNet world, BlockPos sourcePipe, int distance) {
        super(world, sourcePipe, distance);
    }

    @Override
    @NotNull
    protected PipeNetWalker<LaserPipeBlockEntity, LaserPipeProperties, LaserPipeNet> createSubWalker(LaserPipeNet net, Direction direction, BlockPos nextPos, int walkedBlocks) {
        LaserNetWalker walker = new LaserNetWalker(net, nextPos, walkedBlocks);
        walker.facingToHandler = this.facingToHandler;
        walker.sourcePipe = this.sourcePipe;
        walker.axis = this.axis;
        return walker;
    }

    @Override
    protected Class<LaserPipeBlockEntity> getBasePipeClass() {
        return LaserPipeBlockEntity.class;
    }

    @Override
    protected void checkPipe(LaserPipeBlockEntity pipeTile, BlockPos pos) {
    }

    @Override
    protected Direction[] getSurroundingPipeSides() {
        return switch (this.axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> X_AXIS_FACINGS;
            case Direction.Axis.Y -> Y_AXIS_FACINGS;
            case Direction.Axis.Z -> Z_AXIS_FACINGS;
        };
    }

    @Override
    protected void checkNeighbour(LaserPipeBlockEntity pipeNode, BlockPos pipePos, Direction faceToNeighbour, @Nullable BlockEntity neighbourTile) {
        ILaserContainer handler;
        if (neighbourTile == null || pipePos.equals((Object)this.sourcePipe) && faceToNeighbour == this.facingToHandler) {
            return;
        }
        if (((LaserNetWalker)this.root).routePath == null && (handler = (ILaserContainer)neighbourTile.getCapability(GTCapability.CAPABILITY_LASER, faceToNeighbour.m_122424_()).resolve().orElse(null)) != null) {
            ((LaserNetWalker)this.root).routePath = new LaserRoutePath(pipePos.m_7949_(), faceToNeighbour, this.getWalkedBlocks());
            this.stop();
        }
    }
}

