/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.fluidpipe;

import com.gregtechceu.gtceu.common.blockentity.FluidPipeBlockEntity;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PipeTankList
implements IFluidTransfer,
Iterable<FluidStorage> {
    private final FluidPipeBlockEntity pipe;
    private final FluidStorage[] tanks;
    private final Direction facing;

    public PipeTankList(FluidPipeBlockEntity pipe, Direction facing, FluidStorage ... fluidTanks) {
        this.tanks = fluidTanks;
        this.pipe = pipe;
        this.facing = facing;
    }

    private int findChannel(FluidStack stack) {
        if (stack.isEmpty() || this.tanks == null) {
            return -1;
        }
        int empty = -1;
        for (int i = this.tanks.length - 1; i >= 0; --i) {
            FluidStack f = this.tanks[i].getFluid();
            if (f.isEmpty()) {
                empty = i;
                continue;
            }
            if (!f.isFluidEqual(stack)) continue;
            return i;
        }
        return empty;
    }

    public int getTanks() {
        return this.tanks.length;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.tanks[tank].getFluid();
    }

    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        this.tanks[tank].setFluid(fluidStack);
    }

    public long getTankCapacity(int tank) {
        return this.tanks[tank].getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.tanks[tank].isFluidValid(stack);
    }

    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        if (this.pipe.isBlocked(this.facing) || resource == null || resource.getAmount() <= 0L) {
            return 0L;
        }
        return this.fill(resource, simulate, tank);
    }

    public boolean supportsFill(int tank) {
        return true;
    }

    @NotNull
    public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        FluidStorage storage = this.tanks[tank];
        FluidStack drained = storage.drain(resource, simulate, notifyChanges);
        if (!drained.isEmpty()) {
            return drained;
        }
        return FluidStack.empty();
    }

    public boolean supportsDrain(int tank) {
        return true;
    }

    public long fill(FluidStack resource, boolean simulate, boolean notifyChanges) {
        int channel;
        if (this.pipe.isBlocked(this.facing) || resource == null || resource.getAmount() <= 0L || (channel = this.findChannel(resource)) < 0) {
            return 0L;
        }
        return this.fill(resource, simulate, channel);
    }

    private long fullCapacity() {
        return (long)this.tanks.length * this.pipe.getCapacityPerTank();
    }

    private long fill(FluidStack resource, boolean simulate, int channel) {
        long toAdd;
        if (channel >= this.tanks.length) {
            return 0L;
        }
        FluidStorage tank = this.tanks[channel];
        FluidStack currentFluid = tank.getFluid();
        if (currentFluid.isEmpty() || currentFluid.getAmount() <= 0L) {
            FluidStack newFluid = resource.copy();
            newFluid.setAmount(Math.min(this.pipe.getCapacityPerTank(), newFluid.getAmount()));
            if (!simulate) {
                tank.setFluid(newFluid);
                this.pipe.receivedFrom(this.facing);
                this.pipe.checkAndDestroy(newFluid);
            }
            return newFluid.getAmount();
        }
        if (currentFluid.isFluidEqual(resource) && (toAdd = Math.min(tank.getCapacity() - currentFluid.getAmount(), resource.getAmount())) > 0L) {
            if (!simulate) {
                currentFluid.setAmount(currentFluid.getAmount() + toAdd);
                this.pipe.receivedFrom(this.facing);
                this.pipe.checkAndDestroy(currentFluid);
            }
            return toAdd;
        }
        return 0L;
    }

    @NotNull
    public FluidStack drain(long maxDrain, boolean doDrain, boolean notifyChanges) {
        if (maxDrain <= 0L) {
            return FluidStack.empty();
        }
        for (FluidStorage tank : this.tanks) {
            FluidStack drained = tank.drain(maxDrain, doDrain, notifyChanges);
            if (drained.isEmpty()) continue;
            return drained;
        }
        return FluidStack.empty();
    }

    @NotNull
    public Object createSnapshot() {
        return new Object();
    }

    public void restoreFromSnapshot(Object snapshot) {
    }

    @Nullable
    public FluidStack drain(FluidStack fluidStack, boolean doDrain) {
        if (fluidStack == null || fluidStack.getAmount() <= 0L) {
            return null;
        }
        fluidStack = fluidStack.copy();
        for (FluidStorage tank : this.tanks) {
            FluidStack drained = tank.drain(fluidStack, doDrain);
            if (drained.isEmpty()) continue;
            return drained;
        }
        return null;
    }

    @Override
    @NotNull
    public Iterator<FluidStorage> iterator() {
        return Arrays.stream(this.tanks).iterator();
    }
}

