/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.common.machine.storage.QuantumChestMachine;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.PhantomSlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.annotation.DropSaved;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class CreativeChestMachine
extends QuantumChestMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CreativeChestMachine.class, QuantumChestMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DropSaved
    private int itemsPerCycle = 1;
    @Persisted
    @DropSaved
    private int ticksPerCycle = 1;

    public CreativeChestMachine(IMachineBlockEntity holder) {
        super(holder, 14, -1, new Object[0]);
    }

    @Override
    protected NotifiableItemStackHandler createCacheItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, 1, IO.BOTH){

            @Override
            public int getSlotLimit(int slot) {
                return 1;
            }

            @Override
            public void setStackInSlot(int slot, ItemStack stack) {
                stack.m_41764_(1);
                this.storage.setStackInSlot(slot, stack);
                this.onContentsChanged();
            }

            @Override
            public void onContentsChanged() {
                super.onContentsChanged();
                if (!CreativeChestMachine.this.isRemote()) {
                    CreativeChestMachine.this.stored = this.getStackInSlot(0).m_41777_();
                    CreativeChestMachine.this.storedAmount = CreativeChestMachine.this.stored.m_41613_();
                    CreativeChestMachine.this.stored.m_41764_(1);
                }
            }
        };
    }

    @Override
    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % (long)this.ticksPerCycle == 0L) {
            if (this.isAutoOutputItems() && this.getOutputFacingItems() != null) {
                this.updateItemTick();
            }
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 131);
        group.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)this.cache, 0, 36, 6).setClearSlotOnRightClick(true).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT).setChangeListener(this::markDirty));
        group.addWidget((Widget)new LabelWidget(7, 9, "gtceu.creative.chest.item"));
        group.addWidget((Widget)new ImageWidget(7, 48, 154, 14, (IGuiTexture)GuiTextures.DISPLAY));
        group.addWidget((Widget)new TextFieldWidget(9, 50, 152, 10, () -> String.valueOf(this.itemsPerCycle), value -> {
            if (!value.isEmpty()) {
                this.itemsPerCycle = Integer.parseInt(value);
            }
        }).setMaxStringLength(11).setNumbersOnly(1, Integer.MAX_VALUE));
        group.addWidget((Widget)new LabelWidget(7, 28, "gtceu.creative.chest.ipc"));
        group.addWidget((Widget)new ImageWidget(7, 85, 154, 14, (IGuiTexture)GuiTextures.DISPLAY));
        group.addWidget((Widget)new TextFieldWidget(9, 87, 152, 10, () -> String.valueOf(this.ticksPerCycle), value -> {
            if (!value.isEmpty()) {
                this.ticksPerCycle = Integer.parseInt(value);
            }
        }).setMaxStringLength(11).setNumbersOnly(1, Integer.MAX_VALUE));
        group.addWidget((Widget)new LabelWidget(7, 65, "gtceu.creative.chest.tpc"));
        group.addWidget((Widget)new SwitchWidget(7, 101, 162, 20, (clickData, value) -> this.setWorkingEnabled((boolean)value)).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("gtceu.creative.activity.off")}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("gtceu.creative.activity.on")})).setPressed(this.isWorkingEnabled()));
        return group;
    }

    public void updateItemTick() {
        ItemStack stack;
        this.stored = stack = this.cache.getStackInSlot(0).m_41777_();
        if (this.ticksPerCycle == 0 || this.getOffsetTimer() % (long)this.ticksPerCycle != 0L) {
            return;
        }
        if (this.getLevel().f_46443_ || !this.isWorkingEnabled() || stack.m_41619_()) {
            return;
        }
        IItemTransfer transfer = ItemTransferHelper.getItemTransfer((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(this.getOutputFacingItems()), (Direction)this.getOutputFacingItems().m_122424_());
        if (transfer != null) {
            stack.m_41764_(this.itemsPerCycle);
            ItemStack remainder = GTTransferUtils.insertItem(transfer, stack, true);
            int amountToInsert = stack.m_41613_() - remainder.m_41613_();
            if (amountToInsert > 0) {
                GTTransferUtils.insertItem(transfer, stack, false);
            }
        }
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held;
        if (hit.m_82434_() == this.getFrontFacing() && !(held = player.m_21205_()).m_41619_() && (ItemTransferHelper.canItemStacksStack((ItemStack)held, (ItemStack)this.stored) || this.stored.m_41619_())) {
            if (!this.isRemote()) {
                ItemStack remaining = this.cache.insertItem(0, held, false);
                player.m_21008_(InteractionHand.MAIN_HAND, remaining);
            }
            return InteractionResult.SUCCESS;
        }
        return super.onUse(state, world, pos, player, hand, hit);
    }

    @Override
    public boolean onLeftClick(Player player, Level world, InteractionHand hand, BlockPos pos, Direction direction) {
        ItemStack drained;
        if (direction == this.getFrontFacing() && !this.isRemote() && !this.stored.m_41619_() && !(drained = this.cache.extractItem(0, player.m_6047_() ? this.stored.m_41720_().m_41459_() : 1, false)).m_41619_() && player.m_36356_(drained)) {
            Block.m_49840_((Level)world, (BlockPos)this.getPos().m_121945_(this.getFrontFacing()), (ItemStack)drained);
        }
        return super.onLeftClick(player, world, hand, pos, direction);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }
}

