/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.google.common.collect.ImmutableSet;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaxOffBehavior
implements IToolBehavior {
    public static final WaxOffBehavior INSTANCE = WaxOffBehavior.create();

    protected WaxOffBehavior() {
    }

    protected static WaxOffBehavior create() {
        return new WaxOffBehavior();
    }

    @Override
    @NotNull
    public InteractionResult onItemUse(UseOnContext context) {
        Object blocks;
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        InteractionHand hand = context.m_43724_();
        ItemStack stack = player.m_21120_(hand);
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (this.isBlockUnWaxable(stack, level, player, pos, context)) {
            if (aoeDefinition == AoESymmetrical.none()) {
                blocks = ImmutableSet.of((Object)pos);
            } else {
                HitResult rayTraceResult = ToolHelper.getPlayerDefaultRaytrace(player);
                if (rayTraceResult == null) {
                    return InteractionResult.PASS;
                }
                if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK) {
                    return InteractionResult.PASS;
                }
                if (!(rayTraceResult instanceof BlockHitResult)) {
                    return InteractionResult.PASS;
                }
                BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
                if (blockHitResult.m_82434_() == null) {
                    return InteractionResult.PASS;
                }
                blocks = WaxOffBehavior.getUnWaxableBlocks(stack, aoeDefinition, level, player, rayTraceResult);
                blocks.add(blockHitResult.m_82425_());
            }
        } else {
            return InteractionResult.PASS;
        }
        boolean pathed = false;
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos = (BlockPos)iterator.next();
            pathed |= level.m_7731_(blockPos, this.getUnWaxed(level.m_8055_(blockPos), new UseOnContext(player, hand, context.m_43718_().m_82430_(blockPos))), 3);
            level.m_5898_(player, 3004, blockPos, 0);
            if (!player.m_7500_()) {
                ToolHelper.damageItem(context.m_43722_(), (LivingEntity)context.m_43723_());
            }
            if (!stack.m_41619_()) continue;
            break;
        }
        if (pathed) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_144060_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static Set<BlockPos> getUnWaxableBlocks(ItemStack stack, AoESymmetrical aoeDefinition, Level Level2, Player player, HitResult rayTraceResult) {
        return ToolHelper.iterateAoE(stack, aoeDefinition, Level2, player, rayTraceResult, INSTANCE::isBlockUnWaxable);
    }

    protected boolean isBlockUnWaxable(ItemStack stack, Level level, Player player, BlockPos pos, UseOnContext context) {
        BlockState state = level.m_8055_(pos);
        BlockState newState = state.getToolModifiedState(context, ToolActions.AXE_WAX_OFF, false);
        return newState != null && newState != state;
    }

    protected BlockState getUnWaxed(BlockState unscrapedState, UseOnContext context) {
        return unscrapedState.getToolModifiedState(context, ToolActions.AXE_WAX_OFF, false);
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level Level2, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.gtceu.tool.behavior.remove_wax"));
    }
}

