/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TorchPlaceBehavior
implements IToolBehavior {
    public static final TorchPlaceBehavior INSTANCE = new TorchPlaceBehavior();

    protected TorchPlaceBehavior() {
    }

    @Override
    @NotNull
    public InteractionResult onItemUse(UseOnContext context) {
        InteractionHand hand;
        Player player = context.m_43723_();
        ItemStack stack = player.m_21120_(hand = context.m_43724_());
        CompoundTag behaviourTag = ToolHelper.getBehaviorsTag(stack);
        if (behaviourTag.m_128471_("TorchPlacing")) {
            int i;
            int cachedTorchSlot;
            ItemStack slotStack;
            if (behaviourTag.m_128471_("TorchPlacing$Slot") && TorchPlaceBehavior.checkAndPlaceTorch(context, slotStack = (cachedTorchSlot = behaviourTag.m_128451_("TorchPlacing$Slot")) < 0 ? (ItemStack)player.m_150109_().f_35976_.get(0) : (ItemStack)player.m_150109_().f_35974_.get(cachedTorchSlot))) {
                return InteractionResult.SUCCESS;
            }
            for (i = 0; i < player.m_150109_().f_35976_.size(); ++i) {
                slotStack = (ItemStack)player.m_150109_().f_35976_.get(i);
                if (!TorchPlaceBehavior.checkAndPlaceTorch(context, slotStack)) continue;
                behaviourTag.m_128405_("TorchPlacing$Slot", -(i + 1));
                return InteractionResult.SUCCESS;
            }
            for (i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                slotStack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (!TorchPlaceBehavior.checkAndPlaceTorch(context, slotStack)) continue;
                behaviourTag.m_128405_("TorchPlacing$Slot", i);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private static boolean checkAndPlaceTorch(UseOnContext context, ItemStack slotStack) {
        BlockItem slotItemBlock;
        Block slotBlock;
        Item slotItem;
        if (!slotStack.m_41619_() && (slotItem = slotStack.m_41720_()) instanceof BlockItem && ((slotBlock = (slotItemBlock = (BlockItem)slotItem).m_40614_()) == Blocks.f_50081_ || slotStack.m_204117_(TagUtil.createItemTag("torches")))) {
            BlockPos pos = context.m_8083_();
            BlockState state = context.m_43725_().m_8055_(pos);
            if (!state.m_247087_()) {
                pos = pos.m_121945_(context.m_43719_());
            }
            if (context.m_43723_().m_36204_(pos, context.m_43719_(), slotStack)) {
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(context);
                BlockState slotState = slotBlock.m_5573_(blockPlaceContext);
                if (slotItemBlock.m_40576_(blockPlaceContext).m_19077_()) {
                    slotState = context.m_43725_().m_8055_(pos);
                    SoundType soundtype = slotState.m_60734_().m_49962_(slotState);
                    context.m_43725_().m_5594_(context.m_43723_(), pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                    if (!context.m_43723_().m_7500_()) {
                        slotStack.m_41774_(1);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void addBehaviorNBT(@NotNull ItemStack stack, @NotNull CompoundTag tag) {
        tag.m_128379_("TorchPlacing", true);
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level Level2, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.gtceu.tool.behavior.torch_place"));
    }
}

