/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.common.item.tool.rotation.CustomBlockRotations;
import com.gregtechceu.gtceu.common.item.tool.rotation.ICustomRotationBehavior;
import com.lowdragmc.lowdraglib.utils.RayTraceHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockRotatingBehavior
implements IToolBehavior {
    public static final BlockRotatingBehavior INSTANCE = new BlockRotatingBehavior();

    protected BlockRotatingBehavior() {
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockEntity te = level.m_7702_(pos = context.m_8083_());
        if (te instanceof IMachineBlockEntity) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        BlockState state = level.m_8055_(pos);
        Block b = state.m_60734_();
        if (b instanceof BaseRailBlock) {
            return InteractionResult.FAIL;
        }
        if (!player.m_6144_()) {
            ICustomRotationBehavior behavior = CustomBlockRotations.getCustomRotation(b);
            if (behavior != null) {
                if (behavior.customRotate(state, level, pos, BlockRotatingBehavior.retraceBlock((BlockGetter)level, player, pos))) {
                    ToolHelper.onActionDone(player, level, context.m_43724_());
                    return InteractionResult.SUCCESS;
                }
            } else if (state.m_60717_(player.m_6350_().m_122427_() == context.m_43719_() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90) != state) {
                ToolHelper.onActionDone(player, level, context.m_43724_());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.gtceu.tool.behavior.block_rotation"));
    }

    public static BlockHitResult retraceBlock(BlockGetter level, Player player, BlockPos pos) {
        BlockHitResult raytraceTraceShape;
        Vec3 startVec = RayTraceHelper.getTraceOrigin((Player)player);
        Vec3 endVec = RayTraceHelper.getTraceTarget((Player)player, (double)ToolHelper.getPlayerBlockReach(player), (Vec3)startVec);
        BlockState state = level.m_8055_(pos);
        VoxelShape baseShape = state.m_60808_(level, pos);
        BlockHitResult baseTraceResult = baseShape.m_83220_(startVec, endVec, pos);
        if (baseTraceResult != null && (raytraceTraceShape = state.m_60771_(level, pos, CollisionContext.m_82750_((Entity)player)).m_83220_(startVec, endVec, pos)) != null) {
            return raytraceTraceShape;
        }
        return baseTraceResult;
    }
}

