/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.fluids.GTFluid;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorage;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.core.MixinHelpers;
import com.gregtechceu.gtceu.data.pack.GTDynamicResourcePack;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;

public class GTModels {
    public static void createModelBlockState(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov, ResourceLocation modelLocation) {
        prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().getExistingFile(modelLocation));
    }

    public static void createCrossBlockState(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov) {
        prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cross(ForgeRegistries.BLOCKS.getKey((Object)((Block)ctx.getEntry())).m_135815_(), prov.blockTexture((Block)ctx.getEntry())));
    }

    public static void cellModel(DataGenContext<Item, ? extends Item> ctx, RegistrateItemModelProvider prov) {
        ((ItemModelBuilder)((ItemModelBuilder)prov.getBuilder("item/" + prov.name(() -> ctx.getEntry()) + "_empty")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", prov.modLoc("item/%s/base".formatted(prov.name(ctx))));
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)prov.getBuilder("item/" + prov.name(() -> ctx.getEntry()) + "_filled")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", prov.modLoc("item/%s/base".formatted(prov.name(ctx))))).texture("layer1", prov.modLoc("item/%s/overlay".formatted(prov.name(ctx))));
        prov.generated(() -> ctx.getEntry(), new ResourceLocation[]{prov.modLoc("item/%s/base".formatted(prov.name(ctx)))}).override().predicate(GTCEu.id("fluid_cell"), 0.0f).model((ModelFile)new ModelFile.UncheckedModelFile(prov.modLoc("item/%s_empty".formatted(prov.name(ctx))))).end().override().predicate(GTCEu.id("fluid_cell"), 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(prov.modLoc("item/%s_filled".formatted(prov.name(ctx))))).end();
    }

    public static <T extends Item> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> overrideModel(ResourceLocation predicate, int modelNumber) {
        if (modelNumber <= 0) {
            return NonNullBiConsumer.noop();
        }
        return (ctx, prov) -> {
            ItemModelBuilder rootModel = prov.generated(() -> ((DataGenContext)ctx).getEntry(), new ResourceLocation[]{prov.modLoc("item/%s/1".formatted(prov.name((NonNullSupplier)ctx)))});
            for (int i = 0; i < modelNumber; ++i) {
                ItemModelBuilder subModelBuilder = (ItemModelBuilder)((ItemModelBuilder)prov.getBuilder("item/" + prov.name(() -> ((DataGenContext)ctx).getEntry()) + "/" + i)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
                subModelBuilder.texture("layer0", prov.modLoc("item/%s/%d".formatted(prov.name((NonNullSupplier)ctx), i + 1)));
                rootModel = rootModel.override().predicate(predicate, (float)i / 100.0f).model((ModelFile)new ModelFile.UncheckedModelFile(prov.modLoc("item/%s/%d".formatted(prov.name((NonNullSupplier)ctx), i)))).end();
            }
        };
    }

    public static void createTextureModel(DataGenContext<Item, ? extends Item> ctx, RegistrateItemModelProvider prov, ResourceLocation texture) {
        prov.generated(ctx, new ResourceLocation[]{texture});
    }

    public static void rubberTreeSaplingModel(DataGenContext<Item, BlockItem> context, RegistrateItemModelProvider provider) {
        provider.generated(context, new ResourceLocation[]{provider.modLoc("block/" + provider.name(context))});
    }

    public static void longDistanceItemPipeModel(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov) {
        prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cubeAll("long_distance_item_pipeline", prov.modLoc("block/pipe/ld_item_pipe/block")));
    }

    public static void longDistanceFluidPipeModel(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov) {
        prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cubeAll("long_distance_fluid_pipeline", prov.modLoc("block/pipe/ld_fluid_pipe/block")));
    }

    public static void registerMaterialFluidModels() {
        for (Material material : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            FluidProperty fluidProperty = material.getProperty(PropertyKey.FLUID);
            if (fluidProperty == null) continue;
            MaterialIconSet iconSet = material.getMaterialIconSet();
            for (FluidStorageKey key : FluidStorageKey.allKeys()) {
                JsonObject original;
                Fluid fluid;
                FluidStorage storage = fluidProperty.getStorage();
                FluidStorage.FluidEntry fluidEntry = storage.getEntry(key);
                if (fluidEntry != null && fluidEntry.getBuilder() != null) {
                    if (fluidEntry.getBuilder().still() == null) {
                        ResourceLocation foundTexture = key.getIconType().getBlockTexturePath(iconSet, false);
                        fluidEntry.getBuilder().still(foundTexture);
                    }
                    if (fluidEntry.getBuilder().flowing() == null) {
                        fluidEntry.getBuilder().flowing(fluidEntry.getBuilder().still());
                    }
                    MixinHelpers.addFluidTexture(material, fluidEntry);
                }
                if (!((fluid = storage.get(key)) instanceof GTFluid)) continue;
                GTFluid gtFluid = (GTFluid)fluid;
                try (BufferedReader reader = Minecraft.m_91087_().m_91098_().m_215597_(GTCEu.id("models/item/bucket/bucket.json"));){
                    original = GsonHelper.m_13861_((Reader)reader, (boolean)true);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                JsonObject newJson = original.deepCopy();
                newJson.addProperty("fluid", BuiltInRegistries.f_257020_.m_7981_((Object)gtFluid).toString());
                if (gtFluid.getFluidType().isLighterThanAir()) {
                    newJson.addProperty("flip_gas", Boolean.valueOf(true));
                }
                if (gtFluid.getFluidType().getLightLevel() > 0) {
                    newJson.addProperty("apply_fluid_luminosity", Boolean.valueOf(true));
                }
                GTDynamicResourcePack.addItemModel(BuiltInRegistries.f_257033_.m_7981_((Object)gtFluid.m_6859_()), (JsonElement)newJson);
            }
        }
    }
}

