/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.client.instance.SplitShaftInstance;
import com.gregtechceu.gtceu.client.renderer.machine.KineticWorkableTieredHullMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.SplitShaftTieredHullMachineRenderer;
import com.gregtechceu.gtceu.common.block.KineticMachineBlock;
import com.gregtechceu.gtceu.common.blockentity.KineticMachineBlockEntity;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.machine.KineticMachineDefinition;
import com.gregtechceu.gtceu.common.machine.kinetic.ElectricGearBoxMachine;
import com.gregtechceu.gtceu.common.machine.kinetic.SimpleKineticElectricWorkableMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.KineticPartMachine;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.simibubi.create.content.kinetics.BlockStressValues;
import com.simibubi.create.foundation.utility.Couple;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.Nullable;

public class GTCreateMachines {
    public static final KineticMachineDefinition[] ELECTRIC_GEAR_BOX_2A = GTCreateMachines.registerElectricGearBox(2, GTMachines.LOW_TIERS);
    public static final KineticMachineDefinition[] ELECTRIC_GEAR_BOX_8A = GTCreateMachines.registerElectricGearBox(8, GTMachines.LOW_TIERS);
    public static final KineticMachineDefinition[] ELECTRIC_GEAR_BOX_16A = GTCreateMachines.registerElectricGearBox(16, GTMachines.LOW_TIERS);
    public static final KineticMachineDefinition[] ELECTRIC_GEAR_BOX_32A = GTCreateMachines.registerElectricGearBox(32, GTMachines.LOW_TIERS);
    public static final KineticMachineDefinition[] KINETIC_MIXER = GTCreateMachines.registerSimpleKineticElectricMachine("kinetic_mixer", GTRecipeTypes.CREATE_MIXER_RECIPES, GTMachines.LOW_TIERS);
    public static final KineticMachineDefinition[] KINETIC_INPUT_BOX = GTCreateMachines.registerTieredMachines("kinetic_input_box", (tier, id) -> new KineticMachineDefinition((ResourceLocation)id, false, GTValues.V[tier]).setFrontRotation(true), (holder, tier) -> new KineticPartMachine((IMachineBlockEntity)holder, (int)tier, IO.IN, new Object[0]), (tier, builder) -> (KineticMachineDefinition)builder.langValue("%s %s %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName("kinetic_input_box"), GTValues.VLVT[tier])).rotationState(RotationState.ALL).blockProp((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60988_)).blockProp((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60955_)).abilities(PartAbility.INPUT_KINETIC).renderer(() -> new SplitShaftTieredHullMachineRenderer((int)tier, GTCEu.id("block/machine/part/kinetic_input_box"))).register(), (NonNullSupplier<BiFunction<MaterialManager, KineticMachineBlockEntity, BlockEntityInstance<? super KineticMachineBlockEntity>>>)((NonNullSupplier)() -> SplitShaftInstance::new), false, GTMachines.ELECTRIC_TIERS);
    public static final KineticMachineDefinition[] KINETIC_OUTPUT_BOX = GTCreateMachines.registerTieredMachines("kinetic_output_box", (tier, id) -> new KineticMachineDefinition((ResourceLocation)id, true, GTValues.V[tier]).setFrontRotation(true), (holder, tier) -> new KineticPartMachine((IMachineBlockEntity)holder, (int)tier, IO.OUT, new Object[0]), (tier, builder) -> (KineticMachineDefinition)builder.langValue("%s %s %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName("kinetic_output_box"), GTValues.VLVT[tier])).rotationState(RotationState.ALL).blockProp((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60988_)).blockProp((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60955_)).abilities(PartAbility.OUTPUT_KINETIC).renderer(() -> new SplitShaftTieredHullMachineRenderer((int)tier, GTCEu.id("block/machine/part/kinetic_output_box"))).register(), (NonNullSupplier<BiFunction<MaterialManager, KineticMachineBlockEntity, BlockEntityInstance<? super KineticMachineBlockEntity>>>)((NonNullSupplier)() -> SplitShaftInstance::new), false, GTMachines.ELECTRIC_TIERS);

    public static KineticMachineDefinition[] registerElectricGearBox(int maxAmps, int ... tiers) {
        return GTCreateMachines.registerTieredMachines("electric_gear_box_%sa".formatted(maxAmps), (tier, id) -> new KineticMachineDefinition((ResourceLocation)id, true, GTValues.V[tier]).setFrontRotation(true), (holder, tier) -> new ElectricGearBoxMachine((IMachineBlockEntity)holder, (int)tier, maxAmps), (tier, builder) -> (KineticMachineDefinition)builder.langValue("%s %s %s".formatted(GTValues.VLVH[tier], "Electric Gearbox %dA".formatted(maxAmps), GTValues.VLVT[tier])).rotationState(RotationState.ALL).blockProp((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60988_)).blockProp((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60955_)).renderer(() -> new SplitShaftTieredHullMachineRenderer((int)tier, GTCEu.id("block/machine/electric_gear_box_%sa".formatted(maxAmps)))).tooltips(GTMachines.explosion()).register(), (NonNullSupplier<BiFunction<MaterialManager, KineticMachineBlockEntity, BlockEntityInstance<? super KineticMachineBlockEntity>>>)((NonNullSupplier)() -> SplitShaftInstance::new), false, tiers);
    }

    public static KineticMachineDefinition[] registerSimpleKineticElectricMachine(String name, GTRecipeType recipeType, int ... tiers) {
        return GTCreateMachines.registerTieredMachines(name, (tier, id) -> new KineticMachineDefinition((ResourceLocation)id, false, GTValues.V[tier]), (holder, tier) -> new SimpleKineticElectricWorkableMachine((IMachineBlockEntity)holder, (int)tier, GTMachines.defaultTankSizeFunction, new Object[0]), (tier, builder) -> (KineticMachineDefinition)builder.langValue("%s %s %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName(name), GTValues.VLVT[tier])).rotationState(RotationState.NON_Y_AXIS).editableUI(SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id(name), recipeType)).blockProp((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60988_)).blockProp((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60955_)).recipeType(recipeType).recipeModifier(GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK)).renderer(() -> new KineticWorkableTieredHullMachineRenderer((int)tier, GTCEu.id("block/machine/kinetic_electric_machine"), GTCEu.id("block/machines/" + name))).tooltips(GTMachines.explosion()).tooltips(GTMachines.workableTiered(tier, GTValues.V[tier], GTValues.V[tier] * 64L, recipeType, (Long)GTMachines.defaultTankSizeFunction.apply(tier), true)).register(), (NonNullSupplier<BiFunction<MaterialManager, KineticMachineBlockEntity, BlockEntityInstance<? super KineticMachineBlockEntity>>>)((NonNullSupplier)() -> SplitShaftInstance::new), false, tiers);
    }

    public static MachineBuilder<KineticMachineDefinition> registerMachines(String name, Function<ResourceLocation, KineticMachineDefinition> definitionFactory, Function<IMachineBlockEntity, MetaMachine> factory, @Nullable NonNullSupplier<BiFunction<MaterialManager, KineticMachineBlockEntity, BlockEntityInstance<? super KineticMachineBlockEntity>>> instanceFactory, boolean renderNormally) {
        return GTRegistration.REGISTRATE.machine(name, definitionFactory, factory, KineticMachineBlock::new, MetaMachineItem::new, KineticMachineBlockEntity::create).hasTESR(instanceFactory != null).onBlockEntityRegister((NonNullConsumer<BlockEntityType<BlockEntity>>)((NonNullConsumer)type -> KineticMachineBlockEntity.onBlockEntityRegister(type, instanceFactory, renderNormally)));
    }

    public static KineticMachineDefinition[] registerTieredMachines(String name, BiFunction<Integer, ResourceLocation, KineticMachineDefinition> definitionFactory, BiFunction<IMachineBlockEntity, Integer, MetaMachine> factory, BiFunction<Integer, MachineBuilder<KineticMachineDefinition>, KineticMachineDefinition> builder, @Nullable NonNullSupplier<BiFunction<MaterialManager, KineticMachineBlockEntity, BlockEntityInstance<? super KineticMachineBlockEntity>>> instanceFactory, boolean renderNormally, int ... tiers) {
        KineticMachineDefinition[] definitions = new KineticMachineDefinition[GTValues.TIER_COUNT];
        for (int tier : tiers) {
            MachineBuilder<KineticMachineDefinition> register = GTRegistration.REGISTRATE.machine(GTValues.VN[tier].toLowerCase(Locale.ROOT) + "_" + name, id -> (KineticMachineDefinition)definitionFactory.apply(tier, (ResourceLocation)id), holder -> (MetaMachine)factory.apply((IMachineBlockEntity)holder, tier), KineticMachineBlock::new, MetaMachineItem::new, KineticMachineBlockEntity::create).tier(tier).hasTESR(instanceFactory != null).onBlockEntityRegister((NonNullConsumer<BlockEntityType<BlockEntity>>)((NonNullConsumer)type -> KineticMachineBlockEntity.onBlockEntityRegister(type, instanceFactory, renderNormally)));
            definitions[tier] = builder.apply(tier, register);
        }
        return definitions;
    }

    public static void init() {
        BlockStressValues.registerProvider((String)"gtceu", (BlockStressValues.IStressValueProvider)new BlockStressValues.IStressValueProvider(){

            public double getImpact(Block block) {
                KineticMachineDefinition definition;
                IMachineBlock machineBlock;
                MachineDefinition machineDefinition;
                if (block instanceof IMachineBlock && (machineDefinition = (machineBlock = (IMachineBlock)block).getDefinition()) instanceof KineticMachineDefinition && !(definition = (KineticMachineDefinition)machineDefinition).isSource()) {
                    return definition.getTorque();
                }
                return 0.0;
            }

            public double getCapacity(Block block) {
                KineticMachineDefinition definition;
                IMachineBlock machineBlock;
                MachineDefinition machineDefinition;
                if (block instanceof IMachineBlock && (machineDefinition = (machineBlock = (IMachineBlock)block).getDefinition()) instanceof KineticMachineDefinition && (definition = (KineticMachineDefinition)machineDefinition).isSource()) {
                    return definition.getTorque();
                }
                return 0.0;
            }

            public boolean hasImpact(Block block) {
                IMachineBlock machineBlock;
                MachineDefinition machineDefinition;
                if (block instanceof IMachineBlock && (machineDefinition = (machineBlock = (IMachineBlock)block).getDefinition()) instanceof KineticMachineDefinition) {
                    KineticMachineDefinition definition = (KineticMachineDefinition)machineDefinition;
                    return !definition.isSource();
                }
                return false;
            }

            public boolean hasCapacity(Block block) {
                IMachineBlock machineBlock;
                MachineDefinition machineDefinition;
                if (block instanceof IMachineBlock && (machineDefinition = (machineBlock = (IMachineBlock)block).getDefinition()) instanceof KineticMachineDefinition) {
                    KineticMachineDefinition definition = (KineticMachineDefinition)machineDefinition;
                    return definition.isSource();
                }
                return false;
            }

            @Nullable
            public Couple<Integer> getGeneratedRPM(Block block) {
                return null;
            }
        });
    }
}

