/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IRotorHolderMachine;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class RotorHolderMachineRenderer
extends TieredHullMachineRenderer {
    public static final ResourceLocation ROTOR_HOLDER_OVERLAY = GTCEu.id("block/overlay/machine/overlay_rotor_holder");
    public static final ResourceLocation BASE_RING = GTCEu.id("block/multiblock/large_turbine/base_ring");
    public static final ResourceLocation BASE_BG = GTCEu.id("block/multiblock/large_turbine/base_bg");
    public static final ResourceLocation IDLE = GTCEu.id("block/multiblock/large_turbine/rotor_idle");
    public static final ResourceLocation SPINNING = GTCEu.id("block/multiblock/large_turbine/rotor_spinning");

    public RotorHolderMachineRenderer(int tier) {
        super(tier, GTCEu.id("block/machine/hull_machine"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, @Nullable Direction modelFacing, ModelState modelState) {
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        if (side == frontFacing && modelFacing != null) {
            quads.add(FaceQuad.bakeFace((Direction)modelFacing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)ROTOR_HOLDER_OVERLAY), (ModelState)modelState));
            if (machine instanceof IRotorHolderMachine) {
                IRotorHolderMachine rotorHolderMachine = (IRotorHolderMachine)((Object)machine);
                AABB aabb = new AABB(-1.0, -1.0, -0.01, 2.0, 2.0, 1.01);
                if (!rotorHolderMachine.getControllers().isEmpty()) {
                    quads.add(FaceQuad.bakeFace((AABB)aabb, (Direction)modelFacing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)BASE_RING), (ModelState)modelState, (int)-101, (int)15, (boolean)true, (boolean)false));
                    quads.add(FaceQuad.bakeFace((AABB)aabb, (Direction)modelFacing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)BASE_BG), (ModelState)modelState, (int)-101, (int)15, (boolean)true, (boolean)false));
                    if (rotorHolderMachine.hasRotor()) {
                        if (rotorHolderMachine.isRotorSpinning()) {
                            quads.add(FaceQuad.bakeFace((AABB)aabb, (Direction)modelFacing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)SPINNING), (ModelState)modelState, (int)2, (int)0, (boolean)true, (boolean)true));
                        } else {
                            quads.add(FaceQuad.bakeFace((AABB)aabb, (Direction)modelFacing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)IDLE), (ModelState)modelState, (int)2, (int)0, (boolean)true, (boolean)true));
                        }
                    }
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            register.accept(ROTOR_HOLDER_OVERLAY);
            register.accept(BASE_RING);
            register.accept(BASE_BG);
            register.accept(IDLE);
            register.accept(SPINNING);
        }
    }
}

