/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.cover;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.client.renderer.cover.ICoverRenderer;
import com.gregtechceu.gtceu.common.cover.RobotArmCover;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RobotArmCoverRenderer
implements ICoverRenderer {
    public static final RobotArmCoverRenderer INSTANCE = new RobotArmCoverRenderer();
    public static final ResourceLocation ARM_OVERLAY = GTCEu.id("block/cover/overlay_arm");
    public static final ResourceLocation ARM_OVERLAY_OUT = GTCEu.id("block/cover/overlay_arm_emissive");
    public static final ResourceLocation AR_OVERLAY_IN = GTCEu.id("block/cover/overlay_arm_inverted_emissive");

    protected RobotArmCoverRenderer() {
        if (LDLib.isClient()) {
            this.registerEvent();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderCover(List<BakedQuad> quads, @Nullable Direction side, RandomSource rand, @NotNull CoverBehavior coverBehavior, @Nullable Direction modelFacing, BlockPos pos, BlockAndTintGetter level, ModelState modelState) {
        if (side == coverBehavior.attachedSide && coverBehavior instanceof RobotArmCover) {
            RobotArmCover robotArm = (RobotArmCover)coverBehavior;
            if (modelFacing != null) {
                quads.add(FaceQuad.bakeFace((Direction)modelFacing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)ARM_OVERLAY), (ModelState)modelState));
                quads.add(FaceQuad.bakeFace((Direction)modelFacing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)(robotArm.getIo() == IO.OUT ? ARM_OVERLAY_OUT : AR_OVERLAY_IN)), (ModelState)modelState, (int)-101, (int)15));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            register.accept(ARM_OVERLAY);
            register.accept(AR_OVERLAY_IN);
            register.accept(ARM_OVERLAY_OUT);
        }
    }
}

