/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer;

import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.PipeBlockItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IToolGridHighLight;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.pipenet.IPipeType;
import com.gregtechceu.gtceu.common.item.CoverPlaceBehavior;
import com.gregtechceu.gtceu.common.item.tool.rotation.CustomBlockRotations;
import com.gregtechceu.gtceu.common.item.tool.rotation.ICustomRotationBehavior;
import com.gregtechceu.gtceu.core.mixins.GuiGraphicsAccessor;
import com.lowdragmc.lowdraglib.client.utils.RenderUtils;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class BlockHighLightRenderer {
    private static float rColour;
    private static float gColour;
    private static float bColour;

    public static void renderBlockHighLight(PoseStack poseStack, Camera camera, BlockHitResult target, MultiBufferSource multiBufferSource, float partialTick) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        LocalPlayer player = mc.f_91074_;
        if (level != null && player != null) {
            Object pipeType;
            Item texture2;
            ICoverable coverable;
            VertexConsumer buffer;
            Vec3 pos;
            ICustomRotationBehavior behavior;
            ItemStack held = player.m_21205_();
            BlockPos blockPos = target.m_82425_();
            Set<GTToolType> toolType = ToolHelper.getToolTypes(held);
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (!toolType.isEmpty() && blockEntity instanceof IToolGridHighLight) {
                IToolGridHighLight gridHighLight = (IToolGridHighLight)blockEntity;
                Vec3 pos2 = camera.m_90583_();
                poseStack.m_85836_();
                poseStack.m_85837_(-pos2.f_82479_, -pos2.f_82480_, -pos2.f_82481_);
                if (gridHighLight.shouldRenderGrid((Player)player, held, toolType)) {
                    VertexConsumer buffer2 = multiBufferSource.m_6299_(RenderType.m_110504_());
                    RenderSystem.lineWidth((float)3.0f);
                    BlockHighLightRenderer.drawGridOverlays(poseStack, buffer2, target, side -> gridHighLight.sideTips((Player)player, toolType, (Direction)side));
                } else {
                    Direction facing = target.m_82434_();
                    ResourceTexture texture2 = gridHighLight.sideTips((Player)player, toolType, facing);
                    if (texture2 != null) {
                        RenderSystem.disableDepthTest();
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                        poseStack.m_85837_((double)facing.m_122429_() * 0.01, (double)facing.m_122430_() * 0.01, (double)facing.m_122431_() * 0.01);
                        RenderUtils.moveToFace((PoseStack)poseStack, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (Direction)facing);
                        if (facing.m_122434_() == Direction.Axis.Y) {
                            RenderUtils.rotateToFace((PoseStack)poseStack, (Direction)facing, (Direction)Direction.SOUTH);
                        } else {
                            RenderUtils.rotateToFace((PoseStack)poseStack, (Direction)facing, null);
                        }
                        poseStack.m_85841_(0.0625f, 0.0625f, 0.0f);
                        poseStack.m_252880_(-8.0f, -8.0f, 0.0f);
                        texture2.copy().draw(GuiGraphicsAccessor.create(Minecraft.m_91087_(), poseStack, MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_())), 0, 0, 4.0f, 4.0f, 8, 8);
                        RenderSystem.disableBlend();
                        RenderSystem.enableDepthTest();
                    }
                }
                poseStack.m_85849_();
                return;
            }
            if (toolType.contains(GTToolType.WRENCH) && (behavior = CustomBlockRotations.getCustomRotation(level.m_8055_(blockPos).m_60734_())) != null && behavior.showGrid()) {
                pos = camera.m_90583_();
                poseStack.m_85836_();
                poseStack.m_85837_(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_);
                buffer = multiBufferSource.m_6299_(RenderType.m_110504_());
                RenderSystem.lineWidth((float)3.0f);
                BlockHighLightRenderer.drawGridOverlays(poseStack, buffer, target, side -> GuiTextures.TOOL_FRONT_FACING_ROTATION);
                poseStack.m_85849_();
            }
            if ((coverable = GTCapabilityHelper.getCoverable((Level)level, blockPos, target.m_82434_())) != null) {
                if (CoverPlaceBehavior.isCoverBehaviorItem(held, coverable::hasAnyCover, coverDef -> ICoverable.canPlaceCover(coverDef, coverable))) {
                    pos = camera.m_90583_();
                    poseStack.m_85836_();
                    poseStack.m_85837_(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_);
                    buffer = multiBufferSource.m_6299_(RenderType.m_110504_());
                    RenderSystem.lineWidth((float)3.0f);
                    BlockHighLightRenderer.drawGridOverlays(poseStack, buffer, target, side -> coverable.hasCover((Direction)side) ? null : GuiTextures.TOOL_ATTACH_COVER);
                    poseStack.m_85849_();
                }
            }
            if ((texture2 = held.m_41720_()) instanceof PipeBlockItem) {
                PipeBlockItem pipeBlockItem = (PipeBlockItem)texture2;
                v0 = pipeBlockItem.getBlock().pipeType;
            } else {
                v0 = pipeType = null;
            }
            if (pipeType instanceof IPipeType) {
                PipeBlockEntity pipeBlockEntity;
                IPipeType type = pipeType;
                if (blockEntity instanceof PipeBlockEntity && ((IPipeType)((Object)(pipeBlockEntity = (PipeBlockEntity)blockEntity).getPipeType())).type().equals((Object)type.type())) {
                    Vec3 pos3 = camera.m_90583_();
                    poseStack.m_85836_();
                    poseStack.m_85837_(-pos3.f_82479_, -pos3.f_82480_, -pos3.f_82481_);
                    VertexConsumer buffer3 = multiBufferSource.m_6299_(RenderType.m_110504_());
                    RenderSystem.lineWidth((float)3.0f);
                    BlockHighLightRenderer.drawGridOverlays(poseStack, buffer3, target, side -> level.m_46859_(blockPos.m_121945_(side)) ? pipeBlockEntity.getPipeTexture(true) : null);
                    poseStack.m_85849_();
                }
            }
        }
    }

    private static void drawGridOverlays(PoseStack poseStack, VertexConsumer buffer, BlockHitResult blockHitResult, Function<Direction, ResourceTexture> test) {
        boolean hoverRight;
        boolean hoverTop;
        boolean hoverLeft;
        ResourceTexture bottomBlocked;
        ResourceTexture rightBlocked;
        ResourceTexture topBlocked;
        ResourceTexture leftBlocked;
        rColour = gColour = 0.2f + (float)Math.sin((float)System.currentTimeMillis() % 2513.2742f / 800.0f) / 2.0f;
        bColour = 1.0f;
        BlockPos blockPos = blockHitResult.m_82425_();
        Direction facing = blockHitResult.m_82434_();
        AABB box = new AABB(blockPos);
        Direction attachSide = ICoverable.traceCoverSide(blockHitResult);
        Vector3f topRight = new Vector3f((float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_);
        Vector3f bottomRight = new Vector3f((float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_);
        Vector3f bottomLeft = new Vector3f((float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_);
        Vector3f topLeft = new Vector3f((float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_);
        Vector3f shift = new Vector3f(0.25f, 0.0f, 0.0f);
        Vector3f shiftVert = new Vector3f(0.0f, 0.25f, 0.0f);
        Vector3f cubeCenter = box.m_82399_().m_252839_();
        topRight.sub((Vector3fc)cubeCenter);
        bottomRight.sub((Vector3fc)cubeCenter);
        bottomLeft.sub((Vector3fc)cubeCenter);
        topLeft.sub((Vector3fc)cubeCenter);
        ResourceTexture frontBlocked = test.apply(facing);
        ResourceTexture backBlocked = test.apply(facing.m_122424_());
        boolean hoverFront = attachSide == facing;
        boolean hoverBack = attachSide == facing.m_122424_();
        Vector3f down = new Vector3f(0.0f, -1.0f, 0.0f);
        boolean hoverBottom = switch (facing) {
            case Direction.WEST -> {
                topRight.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)down));
                bottomRight.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)down));
                bottomLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)down));
                topLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)down));
                shift.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)down));
                shiftVert.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)down));
                leftBlocked = test.apply(Direction.NORTH);
                topBlocked = test.apply(Direction.UP);
                rightBlocked = test.apply(Direction.SOUTH);
                bottomBlocked = test.apply(Direction.DOWN);
                hoverLeft = attachSide == Direction.NORTH;
                hoverTop = attachSide == Direction.UP;
                hoverRight = attachSide == Direction.SOUTH;
                yield attachSide == Direction.DOWN;
            }
            case Direction.EAST -> {
                topRight.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)down));
                bottomRight.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)down));
                bottomLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)down));
                topLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)down));
                shift.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)down));
                shiftVert.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)down));
                leftBlocked = test.apply(Direction.SOUTH);
                topBlocked = test.apply(Direction.UP);
                rightBlocked = test.apply(Direction.NORTH);
                bottomBlocked = test.apply(Direction.DOWN);
                hoverLeft = attachSide == Direction.SOUTH;
                hoverTop = attachSide == Direction.UP;
                hoverRight = attachSide == Direction.NORTH;
                yield attachSide == Direction.DOWN;
            }
            case Direction.NORTH -> {
                topRight.rotate((Quaternionfc)new Quaternionf().rotateAxis((float)Math.PI, (Vector3fc)down));
                bottomRight.rotate((Quaternionfc)new Quaternionf().rotateAxis((float)Math.PI, (Vector3fc)down));
                bottomLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis((float)Math.PI, (Vector3fc)down));
                topLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis((float)Math.PI, (Vector3fc)down));
                shift.rotate((Quaternionfc)new Quaternionf().rotateAxis((float)Math.PI, (Vector3fc)down));
                shiftVert.rotate((Quaternionfc)new Quaternionf().rotateAxis((float)Math.PI, (Vector3fc)down));
                leftBlocked = test.apply(Direction.EAST);
                topBlocked = test.apply(Direction.UP);
                rightBlocked = test.apply(Direction.WEST);
                bottomBlocked = test.apply(Direction.DOWN);
                hoverLeft = attachSide == Direction.EAST;
                hoverTop = attachSide == Direction.UP;
                hoverRight = attachSide == Direction.WEST;
                yield attachSide == Direction.DOWN;
            }
            case Direction.UP -> {
                Vector3f side = new Vector3f(1.0f, 0.0f, 0.0f);
                topRight.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)side));
                bottomRight.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)side));
                bottomLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)side));
                topLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)side));
                shift.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)side));
                shiftVert.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)side));
                leftBlocked = test.apply(Direction.EAST);
                topBlocked = test.apply(Direction.SOUTH);
                rightBlocked = test.apply(Direction.WEST);
                bottomBlocked = test.apply(Direction.NORTH);
                hoverLeft = attachSide == Direction.EAST;
                hoverTop = attachSide == Direction.SOUTH;
                hoverRight = attachSide == Direction.WEST;
                yield attachSide == Direction.NORTH;
            }
            case Direction.DOWN -> {
                Vector3f side = new Vector3f(1.0f, 0.0f, 0.0f);
                topRight.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)side));
                bottomRight.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)side));
                bottomLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)side));
                topLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)side));
                shift.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)side));
                shiftVert.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)side));
                leftBlocked = test.apply(Direction.WEST);
                topBlocked = test.apply(Direction.SOUTH);
                rightBlocked = test.apply(Direction.EAST);
                bottomBlocked = test.apply(Direction.NORTH);
                hoverLeft = attachSide == Direction.WEST;
                hoverTop = attachSide == Direction.SOUTH;
                hoverRight = attachSide == Direction.EAST;
                yield attachSide == Direction.NORTH;
            }
            default -> {
                leftBlocked = test.apply(Direction.WEST);
                topBlocked = test.apply(Direction.UP);
                rightBlocked = test.apply(Direction.EAST);
                bottomBlocked = test.apply(Direction.DOWN);
                hoverLeft = attachSide == Direction.WEST;
                hoverTop = attachSide == Direction.UP;
                hoverRight = attachSide == Direction.EAST;
                yield attachSide == Direction.DOWN;
            }
        };
        topRight.add((Vector3fc)cubeCenter);
        bottomRight.add((Vector3fc)cubeCenter);
        bottomLeft.add((Vector3fc)cubeCenter);
        topLeft.add((Vector3fc)cubeCenter);
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        BlockHighLightRenderer.drawLine(mat, buffer, new Vector3f((Vector3fc)topRight).add((Vector3fc)new Vector3f((Vector3fc)shift).mul(-1.0f)), new Vector3f((Vector3fc)bottomRight).add((Vector3fc)new Vector3f((Vector3fc)shift).mul(-1.0f)));
        BlockHighLightRenderer.drawLine(mat, buffer, new Vector3f((Vector3fc)bottomLeft).add((Vector3fc)shift), new Vector3f((Vector3fc)topLeft).add((Vector3fc)shift));
        BlockHighLightRenderer.drawLine(mat, buffer, new Vector3f((Vector3fc)topLeft).add((Vector3fc)new Vector3f((Vector3fc)shiftVert).mul(-1.0f)), new Vector3f((Vector3fc)topRight).add((Vector3fc)new Vector3f((Vector3fc)shiftVert).mul(-1.0f)));
        BlockHighLightRenderer.drawLine(mat, buffer, new Vector3f((Vector3fc)bottomLeft).add((Vector3fc)shiftVert), new Vector3f((Vector3fc)bottomRight).add((Vector3fc)shiftVert));
        poseStack.m_85836_();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.m_85837_((double)facing.m_122429_() * 0.01, (double)facing.m_122430_() * 0.01, (double)facing.m_122431_() * 0.01);
        RenderUtils.moveToFace((PoseStack)poseStack, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (Direction)facing);
        if (facing.m_122434_() == Direction.Axis.Y) {
            RenderUtils.rotateToFace((PoseStack)poseStack, (Direction)facing, (Direction)Direction.SOUTH);
        } else {
            RenderUtils.rotateToFace((PoseStack)poseStack, (Direction)facing, null);
        }
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0f);
        poseStack.m_252880_(-8.0f, -8.0f, 0.0f);
        GuiGraphics graphics = GuiGraphicsAccessor.create(Minecraft.m_91087_(), poseStack, MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()));
        if (leftBlocked != null) {
            leftBlocked.copy().scale(0.9f).setColor(hoverLeft ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 0.0f, 6.0f, 4, 4);
        }
        if (topBlocked != null) {
            topBlocked.copy().scale(0.9f).setColor(hoverTop ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 6.0f, 0.0f, 4, 4);
        }
        if (rightBlocked != null) {
            rightBlocked.copy().scale(0.9f).setColor(hoverRight ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 12.0f, 6.0f, 4, 4);
        }
        if (bottomBlocked != null) {
            bottomBlocked.copy().scale(0.9f).setColor(hoverBottom ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 6.0f, 12.0f, 4, 4);
        }
        if (frontBlocked != null) {
            frontBlocked.copy().scale(0.9f).setColor(hoverFront ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 6.0f, 6.0f, 4, 4);
        }
        if (backBlocked != null) {
            backBlocked.copy().scale(0.9f).setColor(hoverBack ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 0.0f, 0.0f, 4, 4);
            backBlocked.copy().scale(0.9f).setColor(hoverBack ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 12.0f, 0.0f, 4, 4);
            backBlocked.copy().scale(0.9f).setColor(hoverBack ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 0.0f, 12.0f, 4, 4);
            backBlocked.copy().scale(0.9f).setColor(hoverBack ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 12.0f, 12.0f, 4, 4);
        }
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        poseStack.m_85849_();
    }

    private static void drawLine(Matrix4f mat, VertexConsumer buffer, Vector3f from, Vector3f to) {
        Vector3f normal = new Vector3f((Vector3fc)from).sub((Vector3fc)to);
        buffer.m_252986_(mat, from.x, from.y, from.z).m_85950_(rColour, gColour, bColour, 1.0f).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        buffer.m_252986_(mat, to.x, to.y, to.z).m_85950_(rColour, gColour, bColour, 1.0f).m_5601_(normal.x, normal.y, normal.z).m_5752_();
    }
}

