/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ui;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.SteamTexture;
import com.gregtechceu.gtceu.api.gui.WidgetUtils;
import com.gregtechceu.gtceu.api.gui.editor.IEditableUI;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.integration.emi.recipe.GTRecipeTypeEmiCategory;
import com.gregtechceu.gtceu.integration.jei.recipe.GTRecipeTypeCategory;
import com.gregtechceu.gtceu.integration.rei.recipe.GTRecipeTypeDisplayCategory;
import com.gregtechceu.gtceu.utils.OverlayingFluidStorage;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.JEIPlugin;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.DoubleSupplier;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTRecipeTypeUI {
    private Byte2ObjectMap<IGuiTexture> slotOverlays = new Byte2ObjectArrayMap();
    private final GTRecipeType recipeType;
    private ProgressTexture progressBarTexture = new ProgressTexture((IGuiTexture)GuiTextures.PROGRESS_BAR_ARROW.getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)GuiTextures.PROGRESS_BAR_ARROW.getSubTexture(0.0, 0.5, 1.0, 0.5));
    private SteamTexture steamProgressBarTexture = null;
    private ProgressTexture.FillDirection steamMoveType = ProgressTexture.FillDirection.LEFT_TO_RIGHT;
    @Nullable
    protected BiConsumer<GTRecipe, WidgetGroup> uiBuilder;
    protected int maxTooltips = 3;
    private boolean JEIVisible = true;
    private CompoundTag customUICache;

    public GTRecipeTypeUI(@NotNull GTRecipeType recipeType) {
        this.recipeType = recipeType;
    }

    public CompoundTag getCustomUI() {
        if (this.customUICache == null) {
            ResourceManager resourceManager = null;
            if (LDLib.isClient()) {
                resourceManager = Minecraft.m_91087_().m_91098_();
            } else if (Platform.getMinecraftServer() != null) {
                resourceManager = Platform.getMinecraftServer().m_177941_();
            }
            if (resourceManager == null) {
                this.customUICache = new CompoundTag();
            } else {
                try {
                    Resource resource = resourceManager.m_215593_(new ResourceLocation(this.recipeType.registryName.m_135827_(), "ui/recipe_type/%s.rtui".formatted(this.recipeType.registryName.m_135815_())));
                    try (InputStream inputStream = resource.m_215507_();
                         DataInputStream dataInputStream = new DataInputStream(inputStream);){
                        this.customUICache = NbtIo.m_128934_((DataInput)dataInputStream, (NbtAccounter)NbtAccounter.f_128917_);
                    }
                }
                catch (Exception e) {
                    this.customUICache = new CompoundTag();
                }
                if (this.customUICache == null) {
                    this.customUICache = new CompoundTag();
                }
            }
        }
        return this.customUICache;
    }

    public boolean hasCustomUI() {
        return !this.getCustomUI().m_128456_();
    }

    public void reloadCustomUI() {
        this.customUICache = null;
    }

    public Size getJEISize() {
        Size size = this.createEditableUITemplate(false, false).createDefault().getSize();
        return new Size(size.width, this.getPropertyHeightShift() + 5 + size.height);
    }

    public WidgetGroup createUITemplate(DoubleSupplier progressSupplier, IItemTransfer importItems, IItemTransfer exportItems, IFluidTransfer importFluids, IFluidTransfer exportFluids, boolean isSteam, boolean isHighPressure) {
        IEditableUI<WidgetGroup, RecipeHolder> template = this.createEditableUITemplate(isSteam, isHighPressure);
        WidgetGroup group = template.createDefault();
        template.setupUI(group, new RecipeHolder(progressSupplier, importItems, exportItems, importFluids, exportFluids, isSteam, isHighPressure));
        return group;
    }

    public WidgetGroup createUITemplate(DoubleSupplier progressSupplier, IItemTransfer importItems, IItemTransfer exportItems, IFluidTransfer importFluids, IFluidTransfer exportFluids) {
        return this.createUITemplate(progressSupplier, importItems, exportItems, importFluids, exportFluids, false, false);
    }

    public IEditableUI<WidgetGroup, RecipeHolder> createEditableUITemplate(boolean isSteam, boolean isHighPressure) {
        return new IEditableUI.Normal<WidgetGroup, RecipeHolder>(() -> {
            boolean isCustomUI;
            boolean bl = isCustomUI = !isSteam && this.hasCustomUI();
            if (isCustomUI) {
                CompoundTag nbt = this.getCustomUI();
                WidgetGroup group = new WidgetGroup();
                IConfigurableWidget.deserializeNBT((IConfigurableWidget)group, (CompoundTag)nbt.m_128469_("root"), (Resources)Resources.fromNBT((CompoundTag)nbt.m_128469_("resources")), (boolean)false);
                group.setSelfPosition(new Position(0, 0));
                return group;
            }
            WidgetGroup inputs = this.addInventorySlotGroup(false, isSteam, isHighPressure);
            WidgetGroup outputs = this.addInventorySlotGroup(true, isSteam, isHighPressure);
            int maxWidth = Math.max(inputs.getSize().width, outputs.getSize().width);
            WidgetGroup group = new WidgetGroup(0, 0, 2 * maxWidth + 40, Math.max(inputs.getSize().height, outputs.getSize().height));
            Size size = group.getSize();
            inputs.addSelfPosition((maxWidth - inputs.getSize().width) / 2, (size.height - inputs.getSize().height) / 2);
            outputs.addSelfPosition(maxWidth + 40 + (maxWidth - outputs.getSize().width) / 2, (size.height - outputs.getSize().height) / 2);
            group.addWidget((Widget)inputs);
            group.addWidget((Widget)outputs);
            ProgressWidget progressWidget = new ProgressWidget(ProgressWidget.JEIProgress, maxWidth + 10, size.height / 2 - 10, 20, 20, this.progressBarTexture);
            progressWidget.setId("progress");
            group.addWidget((Widget)progressWidget);
            progressWidget.setProgressTexture((IGuiTexture)(isSteam && this.steamProgressBarTexture != null ? new ProgressTexture((IGuiTexture)this.steamProgressBarTexture.get(isHighPressure).getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)this.steamProgressBarTexture.get(isHighPressure).getSubTexture(0.0, 0.5, 1.0, 0.5)).setFillDirection(this.steamMoveType) : this.progressBarTexture));
            return group;
        }, (template, recipeHolder) -> {
            boolean isJEI = recipeHolder.progressSupplier == ProgressWidget.JEIProgress;
            ArrayList progress = new ArrayList();
            WidgetUtils.widgetByIdForEach(template, "^progress$", ProgressWidget.class, progressWidget -> {
                progressWidget.setProgressSupplier(recipeHolder.progressSupplier);
                progress.add(progressWidget);
            });
            if (!isJEI && (LDLib.isReiLoaded() || LDLib.isJeiLoaded() || LDLib.isEmiLoaded())) {
                for (Widget widget : progress) {
                    template.addWidget(new ButtonWidget(widget.getPosition().x, widget.getPosition().y, widget.getSize().width, widget.getSize().height, IGuiTexture.EMPTY, cd -> {
                        if (cd.isRemote) {
                            if (LDLib.isReiLoaded()) {
                                ViewSearchBuilder.builder().addCategory(GTRecipeTypeDisplayCategory.CATEGORIES.apply(this.recipeType)).open();
                            } else if (LDLib.isJeiLoaded()) {
                                JEIPlugin.jeiRuntime.getRecipesGui().showTypes(List.of(GTRecipeTypeCategory.TYPES.apply(this.recipeType)));
                            } else if (LDLib.isEmiLoaded()) {
                                EmiApi.displayRecipeCategory((EmiRecipeCategory)((EmiRecipeCategory)GTRecipeTypeEmiCategory.CATEGORIES.apply(this.recipeType)));
                            }
                        }
                    }).setHoverTooltips(new String[]{"gtceu.recipe_type.show_recipes"}));
                }
            }
            WidgetUtils.widgetByIdForEach(template, "^%s_[0-9]+$".formatted(ItemRecipeCapability.CAP.slotName(IO.IN)), SlotWidget.class, slot -> {
                int index = WidgetUtils.widgetIdIndex((Widget)slot);
                if (index >= 0 && index < recipeHolder.importItems.getSlots()) {
                    slot.setHandlerSlot(recipeHolder.importItems, index);
                    slot.setIngredientIO(IngredientIO.INPUT);
                    slot.setCanTakeItems(!isJEI);
                    slot.setCanPutItems(!isJEI);
                }
            });
            WidgetUtils.widgetByIdForEach(template, "^%s_[0-9]+$".formatted(ItemRecipeCapability.CAP.slotName(IO.OUT)), SlotWidget.class, slot -> {
                int index = WidgetUtils.widgetIdIndex((Widget)slot);
                if (index >= 0 && index < recipeHolder.exportItems.getSlots()) {
                    slot.setHandlerSlot(recipeHolder.exportItems, index);
                    slot.setIngredientIO(IngredientIO.OUTPUT);
                    slot.setCanTakeItems(!isJEI);
                    slot.setCanPutItems(false);
                }
            });
            WidgetUtils.widgetByIdForEach(template, "^%s_[0-9]+$".formatted(FluidRecipeCapability.CAP.slotName(IO.IN)), TankWidget.class, tank -> {
                int index = WidgetUtils.widgetIdIndex((Widget)tank);
                if (index >= 0 && index < recipeHolder.importFluids.getTanks()) {
                    tank.setFluidTank((IFluidStorage)new OverlayingFluidStorage(recipeHolder.importFluids, index));
                    tank.setIngredientIO(IngredientIO.INPUT);
                    tank.setAllowClickFilled(!isJEI);
                    tank.setAllowClickDrained(!isJEI);
                }
            });
            WidgetUtils.widgetByIdForEach(template, "^%s_[0-9]+$".formatted(FluidRecipeCapability.CAP.slotName(IO.OUT)), TankWidget.class, tank -> {
                int index = WidgetUtils.widgetIdIndex((Widget)tank);
                if (index >= 0 && index < recipeHolder.exportFluids.getTanks()) {
                    tank.setFluidTank((IFluidStorage)new OverlayingFluidStorage(recipeHolder.exportFluids, index));
                    tank.setIngredientIO(IngredientIO.OUTPUT);
                    tank.setAllowClickFilled(!isJEI);
                    tank.setAllowClickDrained(false);
                }
            });
        });
    }

    protected WidgetGroup addInventorySlotGroup(boolean isOutputs, boolean isSteam, boolean isHighPressure) {
        int itemCount = isOutputs ? this.recipeType.getMaxOutputs(ItemRecipeCapability.CAP) : this.recipeType.getMaxInputs(ItemRecipeCapability.CAP);
        int fluidCount = isOutputs ? this.recipeType.getMaxOutputs(FluidRecipeCapability.CAP) : this.recipeType.getMaxInputs(FluidRecipeCapability.CAP);
        int itemR = (itemCount + 2) / 3;
        int fluidR = (fluidCount + 2) / 3;
        int itemC = Math.min(itemCount, 3);
        int fluidC = Math.min(fluidCount, 3);
        WidgetGroup group = new WidgetGroup(0, 0, Math.max(itemC, fluidC) * 18 + 8, (itemR + fluidR) * 18 + 8);
        int index = 0;
        for (int slotIndex = 0; slotIndex < itemCount; ++slotIndex) {
            SlotWidget slot = new SlotWidget();
            slot.initTemplate();
            slot.setSelfPosition(new Position(index % 3 * 18 + 4, index / 3 * 18 + 4));
            slot.setBackground(new IGuiTexture[]{this.getOverlaysForSlot(isOutputs, false, slotIndex == itemCount - 1, isSteam, isHighPressure)});
            slot.setId(ItemRecipeCapability.CAP.slotName(isOutputs ? IO.OUT : IO.IN, slotIndex));
            group.addWidget((Widget)slot);
            ++index;
        }
        index += (3 - index % 3) % 3;
        for (int i = 0; i < fluidCount; ++i) {
            TankWidget tank = new TankWidget();
            tank.initTemplate();
            tank.setFillDirection(ProgressTexture.FillDirection.ALWAYS_FULL);
            tank.setSelfPosition(new Position(index % 3 * 18 + 4, index / 3 * 18 + 4));
            tank.setBackground(this.getOverlaysForSlot(isOutputs, true, i == fluidCount - 1, isSteam, isHighPressure));
            tank.setId(FluidRecipeCapability.CAP.slotName(isOutputs ? IO.OUT : IO.IN, i));
            group.addWidget((Widget)tank);
            ++index;
        }
        return group;
    }

    protected void addSlot(WidgetGroup group, int x, int y, int slotIndex, int count, boolean isFluid, boolean isOutputs, boolean isSteam, boolean isHighPressure) {
        if (!isFluid) {
            SlotWidget slot = new SlotWidget();
            slot.initTemplate();
            slot.setSelfPosition(new Position(x, y));
            slot.setBackground(new IGuiTexture[]{this.getOverlaysForSlot(isOutputs, false, slotIndex == count - 1, isSteam, isHighPressure)});
            slot.setId(ItemRecipeCapability.CAP.slotName(isOutputs ? IO.OUT : IO.IN, slotIndex));
            group.addWidget((Widget)slot);
        } else {
            TankWidget tank = new TankWidget();
            tank.initTemplate();
            tank.setFillDirection(ProgressTexture.FillDirection.ALWAYS_FULL);
            tank.setSelfPosition(new Position(x, y));
            tank.setBackground(this.getOverlaysForSlot(isOutputs, true, slotIndex == count - 1, isSteam, isHighPressure));
            tank.setId(FluidRecipeCapability.CAP.slotName(isOutputs ? IO.OUT : IO.IN, slotIndex));
            group.addWidget((Widget)tank);
        }
    }

    protected static int[] determineSlotsGrid(int itemCount) {
        int itemSlotsToLeft;
        int itemSlotsToDown;
        double sqrt = Math.sqrt(itemCount);
        if (sqrt % 1.0 == 0.0) {
            itemSlotsToLeft = itemSlotsToDown = (int)sqrt;
        } else if (itemCount == 3) {
            itemSlotsToLeft = 3;
            itemSlotsToDown = 1;
        } else {
            itemSlotsToLeft = (int)Math.ceil(sqrt);
            if (itemCount > itemSlotsToLeft * (itemSlotsToDown = itemSlotsToLeft - 1)) {
                itemSlotsToDown = itemSlotsToLeft;
            }
        }
        return new int[]{itemSlotsToLeft, itemSlotsToDown};
    }

    protected IGuiTexture getOverlaysForSlot(boolean isOutput, boolean isFluid, boolean isLast, boolean isSteam, boolean isHighPressure) {
        ResourceBorderTexture base = isFluid ? GuiTextures.FLUID_SLOT : (isSteam ? GuiTextures.SLOT_STEAM.get(isHighPressure) : GuiTextures.SLOT);
        byte overlayKey = (byte)((isOutput ? 2 : 0) + (isFluid ? 1 : 0) + (isLast ? 4 : 0));
        if (this.slotOverlays.containsKey(overlayKey)) {
            return new GuiTextureGroup(new IGuiTexture[]{base, (IGuiTexture)this.slotOverlays.get(overlayKey)});
        }
        return base;
    }

    public int getPropertyHeightShift() {
        int maxPropertyCount = this.recipeType.getMaxTooltips() + this.recipeType.getDataInfos().size();
        return maxPropertyCount * 10;
    }

    public void appendJEIUI(GTRecipe recipe, WidgetGroup widgetGroup) {
        if (this.uiBuilder != null) {
            this.uiBuilder.accept(recipe, widgetGroup);
        }
    }

    public GTRecipeTypeUI setSlotOverlay(boolean isOutput, boolean isFluid, IGuiTexture slotOverlay) {
        return this.setSlotOverlay(isOutput, isFluid, false, slotOverlay).setSlotOverlay(isOutput, isFluid, true, slotOverlay);
    }

    public GTRecipeTypeUI setSlotOverlay(boolean isOutput, boolean isFluid, boolean isLast, IGuiTexture slotOverlay) {
        this.slotOverlays.put((byte)((isOutput ? 2 : 0) + (isFluid ? 1 : 0) + (isLast ? 4 : 0)), (Object)slotOverlay);
        return this;
    }

    public GTRecipeTypeUI setProgressBar(ResourceTexture progressBar, ProgressTexture.FillDirection moveType) {
        this.progressBarTexture = new ProgressTexture((IGuiTexture)progressBar.getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)progressBar.getSubTexture(0.0, 0.5, 1.0, 0.5)).setFillDirection(moveType);
        return this;
    }

    public Byte2ObjectMap<IGuiTexture> getSlotOverlays() {
        return this.slotOverlays;
    }

    public void setSlotOverlays(Byte2ObjectMap<IGuiTexture> slotOverlays) {
        this.slotOverlays = slotOverlays;
    }

    public ProgressTexture getProgressBarTexture() {
        return this.progressBarTexture;
    }

    public void setProgressBarTexture(ProgressTexture progressBarTexture) {
        this.progressBarTexture = progressBarTexture;
    }

    public void setSteamProgressBarTexture(SteamTexture steamProgressBarTexture) {
        this.steamProgressBarTexture = steamProgressBarTexture;
    }

    public void setSteamMoveType(ProgressTexture.FillDirection steamMoveType) {
        this.steamMoveType = steamMoveType;
    }

    public void setUiBuilder(@Nullable BiConsumer<GTRecipe, WidgetGroup> uiBuilder) {
        this.uiBuilder = uiBuilder;
    }

    public void setMaxTooltips(int maxTooltips) {
        this.maxTooltips = maxTooltips;
    }

    public int getMaxTooltips() {
        return this.maxTooltips;
    }

    public boolean isJEIVisible() {
        return this.JEIVisible;
    }

    public void setJEIVisible(boolean JEIVisible) {
        this.JEIVisible = JEIVisible;
    }

    public record RecipeHolder(DoubleSupplier progressSupplier, IItemTransfer importItems, IItemTransfer exportItems, IFluidTransfer importFluids, IFluidTransfer exportFluids, boolean isSteam, boolean isHighPressure) {
    }
}

