/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.lookup;

import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.AbstractMapIngredient;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class MapFluidIngredient
extends AbstractMapIngredient {
    public final Fluid fluid;
    public final CompoundTag tag;

    public MapFluidIngredient(FluidStack fluidStack) {
        this.fluid = fluidStack.getFluid();
        this.tag = fluidStack.getTag();
    }

    @NotNull
    public static List<AbstractMapIngredient> from(@NotNull FluidIngredient r) {
        ObjectArrayList list = new ObjectArrayList();
        for (FluidStack s : r.getStacks()) {
            list.add((Object)new MapFluidIngredient(s));
        }
        return list;
    }

    @Override
    protected int hash() {
        int hash = 31 + BuiltInRegistries.f_257020_.m_7981_((Object)this.fluid).hashCode();
        if (this.tag != null) {
            return 31 * hash + this.tag.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            MapFluidIngredient other = (MapFluidIngredient)o;
            if (this.fluid.m_6212_(other.fluid)) {
                return Objects.equals(this.tag, other.tag);
            }
        }
        return false;
    }

    public String toString() {
        return "MapFluidIngredient{{fluid=" + BuiltInRegistries.f_257020_.m_7981_((Object)this.fluid) + "} {tag=" + this.tag + "}";
    }
}

