/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.content;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.lowdragmc.lowdraglib.LDLib;
import net.minecraft.network.FriendlyByteBuf;

public interface IContentSerializer<T> {
    default public void toNetwork(FriendlyByteBuf buf, T content) {
        buf.m_130070_(LDLib.GSON.toJson(this.toJson(content)));
    }

    default public T fromNetwork(FriendlyByteBuf buf) {
        return this.fromJson((JsonElement)LDLib.GSON.fromJson(buf.m_130277_(), JsonElement.class));
    }

    public T fromJson(JsonElement var1);

    public JsonElement toJson(T var1);

    public T of(Object var1);

    public T defaultValue();

    default public void toNetworkContent(FriendlyByteBuf buf, Content content) {
        Object inner = content.getContent();
        this.toNetwork(buf, inner);
        buf.writeFloat(content.chance);
        buf.writeFloat(content.tierChanceBoost);
        buf.writeBoolean(content.slotName != null);
        if (content.slotName != null) {
            buf.m_130070_(content.slotName);
        }
        buf.writeBoolean(content.uiName != null);
        if (content.uiName != null) {
            buf.m_130070_(content.uiName);
        }
    }

    default public Content fromNetworkContent(FriendlyByteBuf buf) {
        T inner = this.fromNetwork(buf);
        float chance = buf.readFloat();
        float tierChanceBoost = buf.readFloat();
        String slotName = null;
        if (buf.readBoolean()) {
            slotName = buf.m_130277_();
        }
        String uiName = null;
        if (buf.readBoolean()) {
            uiName = buf.m_130277_();
        }
        return new Content(inner, chance, tierChanceBoost, slotName, uiName);
    }

    default public JsonElement toJsonContent(Content content) {
        JsonObject json = new JsonObject();
        json.add("content", this.toJson(content.getContent()));
        json.addProperty("chance", (Number)Float.valueOf(content.chance));
        json.addProperty("tierChanceBoost", (Number)Float.valueOf(content.tierChanceBoost));
        if (content.slotName != null) {
            json.addProperty("slotName", content.slotName);
        }
        if (content.uiName != null) {
            json.addProperty("uiName", content.uiName);
        }
        return json;
    }

    default public Content fromJsonContent(JsonElement json) {
        JsonObject jsonObject = json.getAsJsonObject();
        T inner = this.fromJson(jsonObject.get("content"));
        float chance = jsonObject.has("chance") ? jsonObject.get("chance").getAsFloat() : 1.0f;
        float tierChanceBoost = jsonObject.has("tierChanceBoost") ? jsonObject.get("tierChanceBoost").getAsFloat() : 0.0f;
        String slotName = jsonObject.has("slotName") ? jsonObject.get("slotName").getAsString() : null;
        String uiName = jsonObject.has("uiName") ? jsonObject.get("uiName").getAsString() : null;
        return new Content(inner, chance, tierChanceBoost, slotName, uiName);
    }
}

