/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.api.block.BlockProperties;
import com.gregtechceu.gtceu.api.block.IAppearance;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.IPaintable;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IToolable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IToolGridHighLight;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineCoverContainer;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.IMufflableMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRedstoneSignalMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.misc.IOFluidTransferList;
import com.gregtechceu.gtceu.api.misc.IOItemTransferList;
import com.gregtechceu.gtceu.common.cover.FluidFilterCover;
import com.gregtechceu.gtceu.common.cover.ItemFilterCover;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.IEnhancedManaged;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.DummyWorld;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MetaMachine
implements IEnhancedManaged,
IToolable,
ITickSubscription,
IAppearance,
IToolGridHighLight,
IFancyTooltip,
IPaintable,
IRedstoneSignalMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MetaMachine.class);
    private final FieldManagedStorage syncStorage = new FieldManagedStorage((IManaged)this);
    public final IMachineBlockEntity holder;
    @DescSynced
    @Persisted(key="cover")
    protected final MachineCoverContainer coverContainer;
    @Persisted
    @DescSynced
    @RequireRerender
    private int paintingColor = -1;
    protected final List<MachineTrait> traits;
    private final List<TickableSubscription> serverTicks;
    private final List<TickableSubscription> waitingToAdd;
    public boolean isFirstDummyWorldTick = true;

    public MetaMachine(IMachineBlockEntity holder) {
        this.holder = holder;
        this.coverContainer = new MachineCoverContainer(this);
        this.traits = new ArrayList<MachineTrait>();
        this.serverTicks = new ArrayList<TickableSubscription>();
        this.waitingToAdd = new ArrayList<TickableSubscription>();
        if (holder.getRootStorage() != null) {
            this.holder.getRootStorage().attach((IManagedStorage)this.getSyncStorage());
        }
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        Level level = this.getLevel();
        if (level != null && !level.f_46443_ && level.m_7654_() != null) {
            level.m_7654_().execute(this::markDirty);
        }
    }

    public Level getLevel() {
        return this.holder.level();
    }

    public BlockPos getPos() {
        return this.holder.pos();
    }

    public BlockState getBlockState() {
        return this.holder.getSelf().m_58900_();
    }

    public boolean isRemote() {
        return this.getLevel() == null ? LDLib.isRemote() : this.getLevel().f_46443_;
    }

    public void notifyBlockUpdate() {
        this.holder.notifyBlockUpdate();
    }

    public void scheduleRenderUpdate() {
        this.holder.scheduleRenderUpdate();
    }

    public void scheduleNeighborShapeUpdate() {
        Level level = this.getLevel();
        BlockPos pos = this.getPos();
        if (level == null || pos == null) {
            return;
        }
        level.m_8055_(pos).m_60701_((LevelAccessor)level, pos, 3);
    }

    public long getOffsetTimer() {
        return this.holder.getOffsetTimer();
    }

    public void markDirty() {
        this.holder.getSelf().m_6596_();
    }

    public boolean isInValid() {
        return this.holder.getSelf().m_58901_();
    }

    public void onUnload() {
        this.traits.forEach(MachineTrait::onMachineUnLoad);
        this.coverContainer.onUnload();
        for (TickableSubscription serverTick : this.serverTicks) {
            serverTick.unsubscribe();
        }
        this.serverTicks.clear();
    }

    public void onLoad() {
        this.traits.forEach(MachineTrait::onMachineLoad);
        this.coverContainer.onLoad();
    }

    public void saveCustomPersistedData(CompoundTag tag, boolean forDrop) {
    }

    public void loadCustomPersistedData(CompoundTag tag) {
    }

    @Override
    @Nullable
    public TickableSubscription subscribeServerTick(Runnable runnable) {
        if (!this.isRemote()) {
            Level level;
            TickableSubscription subscription = new TickableSubscription(runnable);
            this.waitingToAdd.add(subscription);
            BlockState blockState = this.getBlockState();
            if (!((Boolean)blockState.m_61143_((Property)BlockProperties.SERVER_TICK)).booleanValue() && (level = this.getLevel()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                blockState = (BlockState)blockState.m_61124_((Property)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(true));
                this.holder.getSelf().m_155250_(blockState);
                serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, () -> {
                    if (!this.isInValid()) {
                        serverLevel.m_46597_(this.getPos(), (BlockState)this.getBlockState().m_61124_((Property)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(true)));
                    }
                }));
            }
            return subscription;
        }
        if (this.getLevel() instanceof DummyWorld) {
            TickableSubscription subscription = new TickableSubscription(runnable);
            this.waitingToAdd.add(subscription);
            return subscription;
        }
        return null;
    }

    @Override
    public void unsubscribe(@Nullable TickableSubscription current) {
        if (current != null) {
            current.unsubscribe();
        }
    }

    public final void serverTick() {
        this.executeTick();
        if (this.serverTicks.isEmpty() && this.waitingToAdd.isEmpty() && !this.isInValid()) {
            this.getLevel().m_46597_(this.getPos(), (BlockState)this.getBlockState().m_61124_((Property)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(false)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        if (this.getLevel() instanceof DummyWorld) {
            if (this.isFirstDummyWorldTick) {
                this.isFirstDummyWorldTick = false;
                this.onLoad();
            }
            this.executeTick();
        }
    }

    private void executeTick() {
        if (!this.waitingToAdd.isEmpty()) {
            this.serverTicks.addAll(this.waitingToAdd);
            this.waitingToAdd.clear();
        }
        Iterator<TickableSubscription> iter = this.serverTicks.iterator();
        while (iter.hasNext()) {
            TickableSubscription tickable = iter.next();
            if (tickable.isStillSubscribed()) {
                tickable.run();
            }
            if (this.isInValid()) break;
            if (tickable.isStillSubscribed()) continue;
            iter.remove();
        }
    }

    @Override
    public final Pair<GTToolType, InteractionResult> onToolClick(Set<@NotNull GTToolType> toolType, ItemStack itemStack, UseOnContext context) {
        CoverBehavior coverBehavior;
        Player playerIn = context.m_43723_();
        if (playerIn == null) {
            return Pair.of(null, (Object)InteractionResult.PASS);
        }
        InteractionHand hand = context.m_43724_();
        BlockHitResult hitResult = new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), false);
        Direction gridSide = ICoverable.determineGridSideHit(hitResult);
        CoverBehavior coverBehavior2 = coverBehavior = gridSide == null ? null : this.coverContainer.getCoverAtSide(gridSide);
        if (gridSide == null) {
            gridSide = hitResult.m_82434_();
        }
        if (toolType.contains(GTToolType.SCREWDRIVER)) {
            if (coverBehavior != null) {
                return Pair.of((Object)GTToolType.SCREWDRIVER, (Object)coverBehavior.onScrewdriverClick(playerIn, hand, hitResult));
            }
            return Pair.of((Object)GTToolType.SCREWDRIVER, (Object)this.onScrewdriverClick(playerIn, hand, gridSide, hitResult));
        }
        if (toolType.contains(GTToolType.SOFT_MALLET)) {
            if (coverBehavior != null) {
                return Pair.of((Object)GTToolType.SOFT_MALLET, (Object)coverBehavior.onSoftMalletClick(playerIn, hand, hitResult));
            }
            return Pair.of((Object)GTToolType.SOFT_MALLET, (Object)this.onSoftMalletClick(playerIn, hand, gridSide, hitResult));
        }
        if (toolType.contains(GTToolType.WRENCH)) {
            return Pair.of((Object)GTToolType.WRENCH, (Object)this.onWrenchClick(playerIn, hand, gridSide, hitResult));
        }
        if (toolType.contains(GTToolType.CROWBAR)) {
            if (coverBehavior != null) {
                if (!this.isRemote()) {
                    this.getCoverContainer().removeCover(gridSide, playerIn);
                }
                return Pair.of((Object)GTToolType.CROWBAR, (Object)InteractionResult.CONSUME);
            }
            return Pair.of((Object)GTToolType.CROWBAR, (Object)this.onCrowbarClick(playerIn, hand, gridSide, hitResult));
        }
        if (toolType.contains(GTToolType.HARD_HAMMER)) {
            return Pair.of((Object)GTToolType.HARD_HAMMER, (Object)this.onHardHammerClick(playerIn, hand, gridSide, hitResult));
        }
        return Pair.of(null, (Object)InteractionResult.PASS);
    }

    protected InteractionResult onHardHammerClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        MetaMachine metaMachine = this;
        if (metaMachine instanceof IMufflableMachine) {
            IMufflableMachine mufflableMachine = (IMufflableMachine)((Object)metaMachine);
            if (!this.isRemote()) {
                mufflableMachine.setMuffled(!mufflableMachine.isMuffled());
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult onCrowbarClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    protected InteractionResult onWrenchClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (playerIn.m_6047_()) {
            if (gridSide == this.getFrontFacing() || !this.isFacingValid(gridSide)) {
                return InteractionResult.FAIL;
            }
            if (!this.isRemote()) {
                this.setFrontFacing(gridSide);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult onSoftMalletClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        IControllable controllable = GTCapabilityHelper.getControllable(this.getLevel(), this.getPos(), gridSide);
        if (controllable != null) {
            if (!this.isRemote()) {
                controllable.setWorkingEnabled(!controllable.isWorkingEnabled());
                playerIn.m_213846_((Component)Component.m_237115_((String)(controllable.isWorkingEnabled() ? "behaviour.soft_hammer.enabled" : "behaviour.soft_hammer.disabled")));
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    @Nullable
    public static MetaMachine getMachine(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMachineBlockEntity) {
            IMachineBlockEntity machineBlockEntity = (IMachineBlockEntity)blockEntity;
            return machineBlockEntity.getMetaMachine();
        }
        return null;
    }

    public void attachTraits(MachineTrait trait) {
        this.traits.add(trait);
    }

    public static void clearInventory(List<ItemStack> itemBuffer, IItemTransfer inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stackInSlot = inventory.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            inventory.setStackInSlot(i, ItemStack.f_41583_);
            inventory.onContentsChanged();
            itemBuffer.add(stackInSlot);
        }
    }

    @Override
    public boolean shouldRenderGrid(Player player, ItemStack held, Set<GTToolType> toolTypes) {
        if (toolTypes.contains(GTToolType.WRENCH) || toolTypes.contains(GTToolType.SCREWDRIVER)) {
            return true;
        }
        if (toolTypes.contains(GTToolType.HARD_HAMMER) && this instanceof IMufflableMachine) {
            return true;
        }
        for (CoverBehavior cover : this.coverContainer.getCovers()) {
            if (!cover.shouldRenderGrid(player, held, toolTypes)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ResourceTexture sideTips(Player player, Set<GTToolType> toolTypes, Direction side) {
        CoverBehavior cover;
        MetaMachine metaMachine;
        if (toolTypes.contains(GTToolType.WRENCH)) {
            if (player.m_6047_() && this.isFacingValid(side)) {
                return GuiTextures.TOOL_FRONT_FACING_ROTATION;
            }
        } else if (toolTypes.contains(GTToolType.SOFT_MALLET)) {
            MetaMachine metaMachine2 = this;
            if (metaMachine2 instanceof IControllable) {
                IControllable controllable = (IControllable)((Object)metaMachine2);
                return controllable.isWorkingEnabled() ? GuiTextures.TOOL_PAUSE : GuiTextures.TOOL_START;
            }
        } else if (toolTypes.contains(GTToolType.HARD_HAMMER) && (metaMachine = this) instanceof IMufflableMachine) {
            IMufflableMachine mufflableMachine = (IMufflableMachine)((Object)metaMachine);
            return mufflableMachine.isMuffled() ? GuiTextures.TOOL_SOUND : GuiTextures.TOOL_MUTE;
        }
        if ((cover = this.coverContainer.getCoverAtSide(side)) != null) {
            return cover.sideTips(player, toolTypes, side);
        }
        return null;
    }

    public MachineDefinition getDefinition() {
        return this.holder.getDefinition();
    }

    public void addCollisionBoundingBox(List<VoxelShape> collisionList) {
        collisionList.add(Shapes.m_83144_());
    }

    public boolean canSetIoOnSide(@Nullable Direction direction) {
        return !this.hasFrontFacing() || this.getFrontFacing() != direction;
    }

    public Direction getFrontFacing() {
        BlockState blockState = this.getBlockState();
        Block block = blockState.m_60734_();
        if (block instanceof MetaMachineBlock) {
            MetaMachineBlock machineBlock = (MetaMachineBlock)block;
            return machineBlock.getFrontFacing(blockState);
        }
        return Direction.NORTH;
    }

    public final boolean hasFrontFacing() {
        BlockState blockState = this.getBlockState();
        Block block = blockState.m_60734_();
        if (block instanceof MetaMachineBlock) {
            MetaMachineBlock machineBlock = (MetaMachineBlock)block;
            return machineBlock.getRotationState() != RotationState.NONE;
        }
        return false;
    }

    public boolean isFacingValid(Direction facing) {
        if (this.hasFrontFacing() && facing == this.getFrontFacing()) {
            return false;
        }
        BlockState blockState = this.getBlockState();
        Block block = blockState.m_60734_();
        if (block instanceof MetaMachineBlock) {
            MetaMachineBlock metaMachineBlock = (MetaMachineBlock)block;
            return metaMachineBlock.rotationState.test(facing);
        }
        return false;
    }

    public void setFrontFacing(Direction facing) {
        BlockState blockState = this.getBlockState();
        Block block = blockState.m_60734_();
        if (block instanceof MetaMachineBlock) {
            MetaMachineBlock metaMachineBlock = (MetaMachineBlock)block;
            if (this.isFacingValid(facing)) {
                this.getLevel().m_46597_(this.getPos(), (BlockState)blockState.m_61124_((Property)metaMachineBlock.rotationState.property, (Comparable)facing));
            }
        }
    }

    public void onRotated(Direction oldFacing, Direction newFacing) {
    }

    public int tintColor(int index) {
        if (index == 1 || index == -111) {
            return this.getRealColor();
        }
        return -1;
    }

    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        this.coverContainer.onNeighborChanged(block, fromPos, isMoving);
    }

    public void animateTick(RandomSource random) {
    }

    @Override
    @Nonnull
    public BlockState getBlockAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState sourceState, BlockPos sourcePos) {
        IMultiPart part;
        BlockState appearance = this.getCoverContainer().getBlockAppearance(state, level, pos, side, sourceState, sourcePos);
        if (appearance != null) {
            return appearance;
        }
        MetaMachine metaMachine = this;
        if (metaMachine instanceof IMultiPart && (part = (IMultiPart)((Object)metaMachine)).isFormed() && (appearance = part.getFormedAppearance(sourceState, sourcePos, side)) != null) {
            return appearance;
        }
        return this.getDefinition().getAppearance().get();
    }

    @Override
    public int getOutputSignal(@Nullable Direction side) {
        if (side == null) {
            return 0;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side.m_122424_());
        if (cover == null) {
            return 0;
        }
        return cover.getRedstoneSignalOutput();
    }

    @Override
    public boolean canConnectRedstone(Direction side) {
        if (side == null) {
            return false;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        if (cover == null) {
            return false;
        }
        return cover.canConnectRedstone();
    }

    protected Predicate<ItemStack> getItemCapFilter(@Nullable Direction side) {
        CoverBehavior cover;
        if (side != null && (cover = this.getCoverContainer().getCoverAtSide(side)) instanceof ItemFilterCover) {
            ItemFilterCover filterCover = (ItemFilterCover)cover;
            return filterCover.getItemFilter();
        }
        return item -> true;
    }

    protected Predicate<FluidStack> getFluidCapFilter(@Nullable Direction side) {
        CoverBehavior cover;
        if (side != null && (cover = this.getCoverContainer().getCoverAtSide(side)) instanceof FluidFilterCover) {
            FluidFilterCover filterCover = (FluidFilterCover)cover;
            return filterCover.getFluidFilter();
        }
        return fluid -> true;
    }

    @Nullable
    public IItemTransfer getItemTransferCap(@Nullable Direction side, boolean useCoverCapability) {
        IAutoOutputItem autoOutput;
        MetaMachine metaMachine;
        List<IItemTransfer> list = this.getTraits().stream().filter(IItemTransfer.class::isInstance).filter(t -> t.hasCapability(side)).map(IItemTransfer.class::cast).toList();
        if (list.isEmpty()) {
            return null;
        }
        IO io = IO.BOTH;
        if (side != null && (metaMachine = this) instanceof IAutoOutputItem && (autoOutput = (IAutoOutputItem)((Object)metaMachine)).getOutputFacingItems() == side && !autoOutput.isAllowInputFromOutputSideItems()) {
            io = IO.OUT;
        }
        IOItemTransferList transferList = new IOItemTransferList(list, io, this.getItemCapFilter(side));
        if (!useCoverCapability || side == null) {
            return transferList;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        return cover != null ? cover.getItemTransferCap((IItemTransfer)transferList) : transferList;
    }

    @Nullable
    public IFluidTransfer getFluidTransferCap(@Nullable Direction side, boolean useCoverCapability) {
        IAutoOutputFluid autoOutput;
        MetaMachine metaMachine;
        List<IFluidTransfer> list = this.getTraits().stream().filter(IFluidTransfer.class::isInstance).filter(t -> t.hasCapability(side)).map(IFluidTransfer.class::cast).toList();
        if (list.isEmpty()) {
            return null;
        }
        IO io = IO.BOTH;
        if (side != null && (metaMachine = this) instanceof IAutoOutputFluid && (autoOutput = (IAutoOutputFluid)((Object)metaMachine)).getOutputFacingFluids() == side && !autoOutput.isAllowInputFromOutputSideFluids()) {
            io = IO.OUT;
        }
        IOFluidTransferList transferList = new IOFluidTransferList(list, io, this.getFluidCapFilter(side));
        if (!useCoverCapability || side == null) {
            return transferList;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        return cover != null ? cover.getFluidTransferCap((IFluidTransfer)transferList) : transferList;
    }

    @Override
    public IGuiTexture getFancyTooltipIcon() {
        return GuiTextures.INFO_ICON;
    }

    @Override
    public final List<Component> getFancyTooltip() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        this.onAddFancyInformationTooltip(tooltips);
        return tooltips;
    }

    @Override
    public boolean showFancyTooltip() {
        return !this.getFancyTooltip().isEmpty();
    }

    public void onAddFancyInformationTooltip(List<Component> tooltips) {
        this.getDefinition().getTooltipBuilder().accept(this.getDefinition().asStack(), tooltips);
        String mainKey = String.format("%s.machine.%s.tooltip", this.getDefinition().getId().m_135827_(), this.getDefinition().getId().m_135815_());
        if (LocalizationUtils.exist((String)mainKey)) {
            tooltips.add(0, (Component)Component.m_237115_((String)mainKey));
        }
    }

    @Override
    public int getDefaultPaintingColor() {
        return this.getDefinition().getDefaultPaintingColor();
    }

    public FieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }

    public IMachineBlockEntity getHolder() {
        return this.holder;
    }

    public MachineCoverContainer getCoverContainer() {
        return this.coverContainer;
    }

    @Override
    public int getPaintingColor() {
        return this.paintingColor;
    }

    @Override
    public void setPaintingColor(int paintingColor) {
        this.paintingColor = paintingColor;
    }

    public List<MachineTrait> getTraits() {
        return this.traits;
    }
}

