/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.component;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.capability.ElectricItem;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.component.IItemLifeCycle;
import com.gregtechceu.gtceu.api.item.component.ISubItemHandler;
import com.gregtechceu.gtceu.api.item.component.forge.IComponentCapability;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElectricStats
implements IInteractionItem,
ISubItemHandler,
IAddInformation,
IItemLifeCycle,
IComponentCapability {
    public static final ElectricStats EMPTY = ElectricStats.create(0L, 0L, false, false);
    public final long maxCharge;
    public final int tier;
    public final boolean chargeable;
    public final boolean dischargeable;

    protected ElectricStats(long maxCharge, long tier, boolean chargeable, boolean dischargeable) {
        this.maxCharge = maxCharge;
        this.tier = (int)tier;
        this.chargeable = chargeable;
        this.dischargeable = dischargeable;
    }

    public static ElectricStats create(long maxCharge, long tier, boolean chargeable, boolean dischargeable) {
        return new ElectricStats(maxCharge, tier, chargeable, dischargeable);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(ItemStack itemStack, @NotNull Capability<T> capability) {
        if (capability == GTCapability.CAPABILITY_ELECTRIC_ITEM) {
            return GTCapability.CAPABILITY_ELECTRIC_ITEM.orEmpty(capability, LazyOptional.of(() -> new ElectricItem(itemStack, this.maxCharge, this.tier, this.chargeable, this.dischargeable)));
        }
        return LazyOptional.empty();
    }

    public static float getStoredPredicate(ItemStack itemStack) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(itemStack);
        if (electricItem != null) {
            long per = electricItem.getCharge() * 7L / electricItem.getMaxCharge();
            return (float)per / 100.0f;
        }
        return 0.0f;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(itemStack);
        if (electricItem != null && electricItem.canProvideChargeExternally() && player.m_6144_()) {
            if (!level.f_46443_) {
                boolean isInDischargeMode = ElectricStats.isInDischargeMode(itemStack);
                String locale = "metaitem.electric.discharge_mode." + (isInDischargeMode ? "disabled" : "enabled");
                player.m_213846_((Component)Component.m_237115_((String)locale));
                ElectricStats.setInDischargeMode(itemStack, !isInDischargeMode);
            }
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return IInteractionItem.super.use(item, level, player, usedHand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (electricItem != null && electricItem.canProvideChargeExternally() && ElectricStats.isInDischargeMode(stack) && electricItem.getCharge() > 0L) {
                long chargedAmount;
                ItemStack itemInSlot;
                IElectricItem slotElectricItem;
                Inventory inventoryPlayer = player.m_150109_();
                long transferLimit = electricItem.getTransferLimit();
                for (int i = 0; i < inventoryPlayer.m_6643_() && ((slotElectricItem = GTCapabilityHelper.getElectricItem(itemInSlot = inventoryPlayer.m_8020_(i))) == null || slotElectricItem.canProvideChargeExternally() || (chargedAmount = ElectricStats.chargeElectricItem(transferLimit, electricItem, slotElectricItem)) <= 0L || (transferLimit -= chargedAmount) != 0L); ++i) {
                }
            }
        }
    }

    private static long chargeElectricItem(long maxDischargeAmount, IElectricItem source, IElectricItem target) {
        long maxDischarged = source.discharge(maxDischargeAmount, source.getTier(), false, false, true);
        long maxReceived = target.charge(maxDischarged, source.getTier(), false, true);
        if (maxReceived > 0L) {
            long resultDischarged = source.discharge(maxReceived, source.getTier(), false, true, false);
            target.charge(resultDischarged, source.getTier(), false, false);
            return resultDischarged;
        }
        return 0L;
    }

    private static void setInDischargeMode(ItemStack itemStack, boolean isDischargeMode) {
        CompoundTag tagCompound = itemStack.m_41784_();
        if (isDischargeMode) {
            tagCompound.m_128379_("DischargeMode", true);
        } else {
            tagCompound.m_128473_("DischargeMode");
            if (tagCompound.m_128456_()) {
                itemStack.m_41751_(null);
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (electricItem != null && electricItem.canProvideChargeExternally()) {
            ElectricStats.addTotalChargeTooltip(tooltipComponents, electricItem.getMaxCharge(), electricItem.getTier());
            tooltipComponents.add((Component)Component.m_237115_((String)"metaitem.electric.discharge_mode.tooltip"));
        }
    }

    private static void addTotalChargeTooltip(List<Component> tooltip, long maxCharge, int tier) {
        String unit;
        long chargeTime;
        Instant end;
        Instant start = Instant.now();
        Duration duration = Duration.between(start, end = Instant.now().plusSeconds((long)((double)maxCharge * 1.0 / (double)GTValues.V[tier] / 20.0)));
        if (duration.getSeconds() <= 180L) {
            chargeTime = duration.getSeconds();
            unit = LocalizationUtils.format((String)"item.gtceu.battery.charge_unit.second", (Object[])new Object[0]);
        } else if (duration.toMinutes() <= 180L) {
            chargeTime = duration.toMinutes();
            unit = LocalizationUtils.format((String)"item.gtceu.battery.charge_unit.minute", (Object[])new Object[0]);
        } else {
            chargeTime = duration.toHours();
            unit = LocalizationUtils.format((String)"item.gtceu.battery.charge_unit.hour", (Object[])new Object[0]);
        }
        tooltip.add((Component)Component.m_237110_((String)"item.gtceu.battery.charge_time", (Object[])new Object[]{chargeTime, unit, GTValues.VNF[tier]}));
    }

    private static boolean isInDischargeMode(ItemStack itemStack) {
        CompoundTag tagCompound = itemStack.m_41783_();
        return tagCompound != null && tagCompound.m_128471_("DischargeMode");
    }

    @Override
    public void fillItemCategory(ComponentItem item, CreativeModeTab category, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((ItemLike)item));
        ItemStack stack = new ItemStack((ItemLike)item);
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (electricItem != null) {
            electricItem.charge(electricItem.getMaxCharge(), electricItem.getTier(), true, false);
            items.add((Object)stack);
        }
    }

    public static ElectricStats createElectricItem(long maxCharge, long tier) {
        return ElectricStats.create(maxCharge, tier, true, false);
    }

    public static ElectricStats createRechargeableBattery(long maxCharge, int tier) {
        return ElectricStats.create(maxCharge, tier, true, true);
    }

    public static ElectricStats createBattery(long maxCharge, int tier, boolean rechargeable) {
        return ElectricStats.create(maxCharge, tier, rechargeable, true);
    }
}

