/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.forge.CombinedCapabilityProvider;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.DustProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.capability.ElectricItem;
import com.gregtechceu.gtceu.api.item.component.ElectricStats;
import com.gregtechceu.gtceu.api.item.component.forge.IComponentCapability;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IGTToolDefinition;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.TreeFellingHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.MendingEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public interface IGTTool
extends HeldItemUIFactory.IHeldItemUIHolder,
ItemLike {
    public GTToolType getToolType();

    public Material getMaterial();

    public boolean isElectric();

    public int getElectricTier();

    public IGTToolDefinition getToolStats();

    @Nullable
    public SoundEntry getSound();

    public boolean playSoundOnBlockDestroy();

    default public Item m_5456_() {
        return (Item)this;
    }

    default public ItemStack getRaw() {
        ItemStack stack = new ItemStack((ItemLike)this.m_5456_());
        ToolHelper.getBehaviorsTag(stack);
        return stack;
    }

    default public ItemStack get() {
        ItemStack stack = new ItemStack((ItemLike)this.m_5456_());
        CompoundTag stackCompound = stack.m_41784_();
        stackCompound.m_128379_("DisallowContainerItem", false);
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        IGTToolDefinition toolStats = this.getToolStats();
        stackCompound.m_128405_("HideFlags", 2);
        AoESymmetrical aoeDefinition = this.getToolStats().getAoEDefinition(stack);
        ToolProperty toolProperty = this.getMaterial().getProperty(PropertyKey.TOOL);
        int durability = toolProperty.getDurability() * toolProperty.getDurabilityMultiplier();
        durability = toolStats.getBaseDurability(stack) == 0 ? (int)((float)durability * toolStats.getDurabilityMultiplier(stack)) : (int)((float)durability + (float)toolStats.getBaseDurability(stack) * toolStats.getDurabilityMultiplier(stack));
        toolTag.m_128405_("MaxDamage", durability - 1);
        toolTag.m_128405_("Damage", 0);
        if (toolProperty.isUnbreakable()) {
            stackCompound.m_128379_("Unbreakable", true);
        }
        Object2IntOpenHashMap enchantments = new Object2IntOpenHashMap(toolProperty.getEnchantments());
        enchantments.putAll(toolStats.getDefaultEnchantments(stack));
        enchantments.forEach((enchantment, level) -> {
            if (enchantment.m_6081_(stack)) {
                stack.m_41663_(enchantment, level.intValue());
            }
        });
        CompoundTag behaviourTag = ToolHelper.getBehaviorsTag(stack);
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.addBehaviorNBT(stack, behaviourTag));
        if (aoeDefinition != AoESymmetrical.none()) {
            behaviourTag.m_128405_("MaxAoEColumn", aoeDefinition.column);
            behaviourTag.m_128405_("MaxAoERow", aoeDefinition.row);
            behaviourTag.m_128405_("MaxAoELayer", aoeDefinition.layer);
            behaviourTag.m_128405_("AoEColumn", aoeDefinition.column);
            behaviourTag.m_128405_("AoERow", aoeDefinition.row);
            behaviourTag.m_128405_("AoELayer", aoeDefinition.layer);
        }
        if (toolProperty.isMagnetic()) {
            behaviourTag.m_128379_("RelocateMinedBlocks", true);
        }
        return stack;
    }

    default public ItemStack get(long defaultCharge, long defaultMaxCharge) {
        ElectricItem electricItem;
        ItemStack stack = this.get();
        if (this.isElectric() && (electricItem = (ElectricItem)GTCapabilityHelper.getElectricItem(stack)) != null) {
            electricItem.setMaxChargeOverride(defaultMaxCharge);
            electricItem.setCharge(defaultCharge);
        }
        return stack;
    }

    default public ItemStack get(long defaultMaxCharge) {
        return this.get(defaultMaxCharge, defaultMaxCharge);
    }

    default public Material getToolMaterial(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IGTTool) {
            IGTTool tool = (IGTTool)item;
            return tool.getMaterial();
        }
        return GTMaterials.Iron;
    }

    @Nullable
    default public ToolProperty getToolProperty(ItemStack stack) {
        return this.getToolMaterial(stack).getProperty(PropertyKey.TOOL);
    }

    @Nullable
    default public DustProperty getDustProperty(ItemStack stack) {
        return this.getToolMaterial(stack).getProperty(PropertyKey.DUST);
    }

    default public float getMaterialToolSpeed(ItemStack stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0.0f : toolProperty.getHarvestSpeed();
    }

    default public float getMaterialAttackDamage(ItemStack stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0.0f : toolProperty.getAttackDamage();
    }

    default public float getMaterialAttackSpeed(ItemStack stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0.0f : toolProperty.getAttackSpeed();
    }

    default public int getMaterialDurability(ItemStack stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0 : toolProperty.getDurability() * toolProperty.getDurabilityMultiplier();
    }

    default public int getMaterialEnchantability(ItemStack stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0 : toolProperty.getEnchantability();
    }

    default public int getMaterialHarvestLevel(ItemStack stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0 : toolProperty.getHarvestLevel();
    }

    default public long getMaxCharge(ItemStack stack) {
        CompoundTag tag;
        if (this.isElectric() && (tag = stack.m_41783_()) != null && tag.m_128425_("MaxCharge", 4)) {
            return tag.m_128454_("MaxCharge");
        }
        return -1L;
    }

    default public long getCharge(ItemStack stack) {
        CompoundTag tag;
        if (this.isElectric() && (tag = stack.m_41783_()) != null && tag.m_128425_("Charge", 4)) {
            return tag.m_128454_("Charge");
        }
        return -1L;
    }

    default public float getTotalToolSpeed(ItemStack stack) {
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.m_128425_("ToolSpeed", 5)) {
            return toolTag.m_128457_("ToolSpeed");
        }
        float toolSpeed = this.getToolStats().getEfficiencyMultiplier(stack) * this.getMaterialToolSpeed(stack) + this.getToolStats().getBaseEfficiency(stack);
        toolTag.m_128350_("ToolSpeed", toolSpeed);
        return toolSpeed;
    }

    default public float getTotalAttackDamage(ItemStack stack) {
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.m_128425_("AttackDamage", 5)) {
            return toolTag.m_128457_("AttackDamage");
        }
        float baseDamage = this.getToolStats().getBaseDamage(stack);
        float attackDamage = 0.0f;
        if (baseDamage != Float.MIN_VALUE) {
            attackDamage = this.getMaterialAttackDamage(stack) + baseDamage;
        }
        toolTag.m_128350_("AttackDamage", attackDamage);
        return attackDamage;
    }

    default public float getTotalAttackSpeed(ItemStack stack) {
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.m_128425_("AttackSpeed", 5)) {
            return toolTag.m_128457_("AttackSpeed");
        }
        float attackSpeed = this.getMaterialAttackSpeed(stack) + this.getToolStats().getAttackSpeed(stack);
        toolTag.m_128350_("AttackSpeed", attackSpeed);
        return attackSpeed;
    }

    default public int getTotalMaxDurability(ItemStack stack) {
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.m_128425_("MaxDamage", 3)) {
            return toolTag.m_128451_("MaxDamage");
        }
        IGTToolDefinition toolStats = this.getToolStats();
        int maxDurability = this.getMaterialDurability(stack);
        int builderDurability = (int)((float)toolStats.getBaseDurability(stack) * toolStats.getDurabilityMultiplier(stack));
        maxDurability = builderDurability == 0 ? (int)((float)maxDurability * toolStats.getDurabilityMultiplier(stack)) : maxDurability + builderDurability;
        toolTag.m_128405_("MaxDamage", maxDurability);
        return maxDurability;
    }

    default public int getTotalEnchantability(ItemStack stack) {
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.m_128425_("Enchantability", 3)) {
            return toolTag.m_128451_("Enchantability");
        }
        int enchantability = this.getMaterialEnchantability(stack);
        toolTag.m_128405_("Enchantability", enchantability);
        return enchantability;
    }

    default public int getTotalHarvestLevel(ItemStack stack) {
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.m_128425_("HarvestLevel", 3)) {
            return toolTag.m_128451_("HarvestLevel");
        }
        int harvestLevel = this.getMaterialHarvestLevel(stack) + this.getToolStats().getBaseQuality(stack);
        toolTag.m_128405_("HarvestLevel", harvestLevel);
        return harvestLevel;
    }

    default public float definition$getDestroySpeed(ItemStack stack, BlockState state) {
        float specialValue = ToolHelper.getDestroySpeed(state, this.getToolClasses(stack));
        if (specialValue != -1.0f) {
            return specialValue;
        }
        if (ToolHelper.isToolEffective(state, this.getToolClasses(stack), this.getTotalHarvestLevel(stack))) {
            return this.getTotalToolSpeed(stack);
        }
        return this.getToolStats().isToolEffective(state) ? this.getTotalToolSpeed(stack) : 1.0f;
    }

    default public boolean definition$hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.hitEntity(stack, target, attacker));
        ToolHelper.damageItem(stack, attacker, this.getToolStats().getToolDamagePerAttack(stack));
        return true;
    }

    default public boolean definition$onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        if (player.m_9236_().f_46443_) {
            return false;
        }
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.onBlockStartBreak(stack, pos, player));
        if (!player.m_6144_()) {
            ServerPlayer playerMP = (ServerPlayer)player;
            int result = -1;
            if (ToolHelper.isTool(stack, GTToolType.SHEARS)) {
                result = ToolHelper.shearBlockRoutine(playerMP, stack, pos);
            }
            if (result != 0) {
                BlockState state = player.m_9236_().m_8055_(pos);
                boolean effective = false;
                for (GTToolType type : this.getToolClasses(stack)) {
                    if (!type.harvestTags.stream().anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0))) continue;
                    effective = true;
                    break;
                }
                if (effective |= ToolHelper.isToolEffective(state, this.getToolClasses(stack), this.getTotalHarvestLevel(stack))) {
                    if (ToolHelper.areaOfEffectBlockBreakRoutine(stack, playerMP)) {
                        if (this.playSoundOnBlockDestroy()) {
                            this.playSound(player);
                        }
                    } else if (result == -1) {
                        if (ToolHelper.getBehaviorsTag(stack).m_128471_("TreeFelling") && state.m_204336_(BlockTags.f_13106_)) {
                            new TreeFellingHelper().fellTree(stack, player.m_9236_(), state, pos, (LivingEntity)player);
                        }
                        if (this.playSoundOnBlockDestroy()) {
                            this.playSound(player);
                        }
                    } else {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    default public boolean definition$mineBlock(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.f_46443_) {
            this.getToolStats().getBehaviors().forEach(behavior -> behavior.onBlockDestroyed(stack, worldIn, state, pos, entityLiving));
            if ((double)state.m_60800_((BlockGetter)worldIn, pos) != 0.0) {
                ToolHelper.damageItem(stack, entityLiving, this.getToolStats().getToolDamagePerBlockBreak(stack));
            }
            if (entityLiving instanceof Player && this.playSoundOnBlockDestroy() && entityLiving.m_6144_()) {
                this.playSound((Player)entityLiving);
            }
        }
        return true;
    }

    default public boolean definition$isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        if (toRepair.m_41773_() == 0) {
            return false;
        }
        Item item = repair.m_41720_();
        if (item instanceof IGTTool) {
            IGTTool gtTool = (IGTTool)item;
            return this.getToolMaterial(toRepair) == gtTool.getToolMaterial(repair);
        }
        UnificationEntry entry = ChemicalHelper.getUnificationEntry((ItemLike)repair.m_41720_());
        if (entry == null || entry.material == null) {
            return false;
        }
        if (entry.material == this.getToolMaterial(toRepair)) {
            if (VanillaRecipeHelper.isMaterialWood(entry.material)) {
                return entry.tagPrefix == TagPrefix.planks;
            }
            if (entry.tagPrefix == TagPrefix.plate) {
                return true;
            }
            if (entry.material.hasProperty(PropertyKey.INGOT)) {
                return entry.tagPrefix == TagPrefix.ingot;
            }
            if (entry.material.hasProperty(PropertyKey.GEM)) {
                return entry.tagPrefix == TagPrefix.gem;
            }
        }
        return false;
    }

    default public Multimap<Attribute, AttributeModifier> definition$getDefaultAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(Item.f_41374_, "Weapon modifier", (double)this.getTotalAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(Item.f_41375_, "Weapon modifier", Math.max(-3.9, (double)this.getTotalAttackSpeed(stack)), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    default public int definition$getHarvestLevel(ItemStack stack, GTToolType toolClass, @Nullable Player player, @Nullable BlockState blockState) {
        return this.getToolClasses(stack).contains(toolClass) ? this.getTotalHarvestLevel(stack) : -1;
    }

    default public boolean definition$canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.getToolStats().getBehaviors().stream().anyMatch(behavior -> behavior.canDisableShield(stack, shield, entity, attacker));
    }

    default public boolean definition$doesSneakBypassUse(@Nonnull ItemStack stack, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull Player player) {
        return this.getToolStats().doesSneakBypassUse();
    }

    default public boolean definition$shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return oldStack.m_41720_() != newStack.m_41720_() || oldStack.m_41773_() < newStack.m_41773_();
    }

    default public boolean definition$hasCraftingRemainingItem(ItemStack stack) {
        return stack.m_41783_() == null || !stack.m_41783_().m_128471_("DisallowContainerItem");
    }

    default public ItemStack definition$getCraftingRemainingItem(ItemStack stack) {
        if (!this.definition$hasCraftingRemainingItem(stack)) {
            return ItemStack.f_41583_;
        }
        stack = stack.m_41777_();
        Player player = ForgeHooks.getCraftingPlayer();
        ToolHelper.damageItemWhenCrafting(stack, (LivingEntity)player);
        this.playCraftingSound(player, stack);
        if (stack.m_41619_()) {
            return this.getToolStats().getBrokenStack();
        }
        return stack;
    }

    default public boolean definition$shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (this.getCharge(oldStack) != this.getCharge(newStack)) {
            return slotChanged;
        }
        return !oldStack.equals(newStack);
    }

    default public boolean definition$onEntitySwing(LivingEntity entityLiving, ItemStack stack) {
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.onEntitySwing(entityLiving, stack));
        return false;
    }

    default public boolean definition$canDestroyBlockInCreative(Level world, BlockPos pos, ItemStack stack, Player player) {
        return true;
    }

    default public boolean definition$isDamaged(ItemStack stack) {
        return this.definition$getDamage(stack) > 0;
    }

    default public int definition$getDamage(ItemStack stack) {
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.m_128425_("Damage", 3)) {
            return toolTag.m_128451_("Damage");
        }
        toolTag.m_128405_("Damage", 0);
        return 0;
    }

    default public int definition$getMaxDamage(ItemStack stack) {
        return this.getTotalMaxDurability(stack);
    }

    default public void definition$setDamage(ItemStack stack, int durability) {
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        toolTag.m_128405_("Damage", durability);
    }

    default public double definition$getDurabilityForDisplay(ItemStack stack) {
        int damage = stack.m_41773_();
        int maxDamage = stack.m_41776_();
        if (damage == 0) {
            return 1.0;
        }
        return (double)(maxDamage - damage) / (double)maxDamage;
    }

    default public void definition$init() {
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.init(this));
    }

    default public InteractionResult definition$onItemUseFirst(ItemStack stack, UseOnContext context) {
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            if (behavior.onItemUseFirst(stack, context) != InteractionResult.SUCCESS) continue;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    default public InteractionResult definition$onItemUse(UseOnContext context) {
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            if (behavior.onItemUse(context) != InteractionResult.SUCCESS) continue;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    default public InteractionResultHolder<ItemStack> definition$use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_() && ToolHelper.getMaxAoEDefinition(stack) != AoESymmetrical.none()) {
            ItemStack heldItem = player.m_21120_(hand);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                HeldItemUIFactory.INSTANCE.openUI(serverPlayer, hand);
            }
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            if (behavior.onItemRightClick(world, player, hand).m_19089_() != InteractionResult.SUCCESS) continue;
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    default public void definition$fillItemCategory(CreativeModeTab category, @Nonnull NonNullList<ItemStack> items) {
        if (this.isElectric()) {
            items.add((Object)this.get(Integer.MAX_VALUE));
        } else {
            items.add((Object)this.get());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void definition$appendHoverText(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> tooltip, TooltipFlag flag) {
        CompoundTag behaviorsTag;
        Item item = stack.m_41720_();
        if (!(item instanceof IGTTool)) {
            return;
        }
        IGTTool tool = (IGTTool)item;
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null) {
            return;
        }
        IGTToolDefinition toolStats = tool.getToolStats();
        if (this.isElectric()) {
            tooltip.add((Component)Component.m_237110_((String)"metaitem.generic.electric_item.tooltip", (Object[])new Object[]{this.getCharge(stack), this.getMaxCharge(stack), GTValues.VNF[this.getElectricTier()]}));
        }
        if (!tagCompound.m_128471_("Unbreakable")) {
            int damageRemaining = tool.getTotalMaxDurability(stack) - stack.m_41773_() + 1;
            if (toolStats.isSuitableForCrafting(stack)) {
                tooltip.add((Component)Component.m_237110_((String)"item.gtceu.tool.tooltip.crafting_uses", (Object[])new Object[]{FormattingUtil.formatNumbers(damageRemaining / Math.max(1, toolStats.getToolDamagePerCraft(stack)))}));
            }
            tooltip.add((Component)Component.m_237110_((String)"item.gtceu.tool.tooltip.general_uses", (Object[])new Object[]{FormattingUtil.formatNumbers(damageRemaining)}));
        }
        if (toolStats.isSuitableForAttacking(stack)) {
            tooltip.add((Component)Component.m_237110_((String)"item.gtceu.tool.tooltip.attack_damage", (Object[])new Object[]{FormattingUtil.formatNumbers(2.0f + tool.getTotalAttackDamage(stack))}));
            tooltip.add((Component)Component.m_237110_((String)"item.gtceu.tool.tooltip.attack_speed", (Object[])new Object[]{FormattingUtil.formatNumbers(4.0f + tool.getTotalAttackSpeed(stack))}));
        }
        if (toolStats.isSuitableForBlockBreak(stack)) {
            tooltip.add((Component)Component.m_237110_((String)"item.gtceu.tool.tooltip.mining_speed", (Object[])new Object[]{FormattingUtil.formatNumbers(tool.getTotalToolSpeed(stack))}));
            int harvestLevel = tool.getTotalHarvestLevel(stack);
            String harvestName = "item.gtceu.tool.harvest_level." + harvestLevel;
            if (I18n.m_118936_((String)harvestName)) {
                tooltip.add((Component)Component.m_237110_((String)"item.gtceu.tool.tooltip.harvest_level_extra", (Object[])new Object[]{harvestLevel, Component.m_237115_((String)harvestName)}));
            } else {
                tooltip.add((Component)Component.m_237110_((String)"item.gtceu.tool.tooltip.harvest_level", (Object[])new Object[]{harvestLevel}));
            }
        }
        boolean addedBehaviorNewLine = false;
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (aoeDefinition != AoESymmetrical.none()) {
            addedBehaviorNewLine = tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237110_((String)"item.gtceu.tool.behavior.aoe_mining", (Object[])new Object[]{aoeDefinition.column * 2 + 1, aoeDefinition.row * 2 + 1, aoeDefinition.layer + 1}));
        }
        if ((behaviorsTag = ToolHelper.getBehaviorsTag(stack)).m_128471_("RelocateMinedBlocks")) {
            if (!addedBehaviorNewLine) {
                addedBehaviorNewLine = true;
                tooltip.add((Component)Component.m_237113_((String)""));
            }
            tooltip.add((Component)Component.m_237115_((String)"item.gtceu.tool.behavior.relocate_mining"));
        }
        if (!addedBehaviorNewLine && !toolStats.getBehaviors().isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)""));
        }
        toolStats.getBehaviors().forEach(behavior -> behavior.addInformation(stack, world, tooltip, flag));
        String uniqueTooltip = "item.gtceu.tool." + BuiltInRegistries.f_257033_.m_7981_((Object)this.m_5456_()).m_135815_() + ".tooltip";
        if (I18n.m_118936_((String)uniqueTooltip)) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)uniqueTooltip));
        }
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237110_((String)"item.gtceu.tool.usable_as", (Object[])new Object[]{this.getToolClassNames(stack).stream().filter(s -> I18n.m_118936_((String)("gtceu.tool.class." + s))).map(s -> Component.m_237115_((String)("gtceu.tool.class." + s))).collect(Component::m_237119_, FormattingUtil::combineComponents, FormattingUtil::combineComponents)}));
        if (!tagCompound.m_128471_("Unbreakable")) {
            if (GTUtil.isShiftDown()) {
                Material material = this.getToolMaterial(stack);
                ArrayList<MutableComponent> repairItems = new ArrayList<MutableComponent>();
                if (!VanillaRecipeHelper.isMaterialWood(material)) {
                    if (material.hasProperty(PropertyKey.INGOT)) {
                        repairItems.add(TagPrefix.ingot.getLocalizedName(material));
                    } else if (material.hasProperty(PropertyKey.GEM)) {
                        repairItems.add(TagPrefix.gem.getLocalizedName(material));
                    }
                }
                if (!ChemicalHelper.get(TagPrefix.plate, material).m_41619_()) {
                    repairItems.add(TagPrefix.plate.getLocalizedName(material));
                }
                if (!repairItems.isEmpty()) {
                    tooltip.add((Component)Component.m_237110_((String)"item.gtceu.tool.tooltip.repair_material", (Object[])new Object[]{repairItems.stream().collect(Component::m_237119_, FormattingUtil::combineComponents, FormattingUtil::combineComponents)}));
                }
            } else {
                tooltip.add((Component)Component.m_237115_((String)"item.gtceu.tool.tooltip.repair_info"));
            }
        }
        if (this.isElectric()) {
            tooltip.add((Component)Component.m_237115_((String)"item.gtceu.tool.replace_tool_head"));
        }
    }

    default public boolean definition$canApplyAtEnchantingTable(@Nonnull ItemStack stack, Enchantment enchantment) {
        if (stack.m_41619_()) {
            return false;
        }
        switch (enchantment.m_44704_()) {
            case "enchantment.cofhcore.smashing": {
                return false;
            }
            case "enchantment.autosmelt": 
            case "enchantment.cofhcore.smelting": 
            case "enchantment.as.smelting": {
                return this.getToolStats().getAoEDefinition(stack) == AoESymmetrical.none() && !ToolHelper.getBehaviorsTag(stack).m_128441_("TreeFelling");
            }
        }
        if (this.isElectric() && (enchantment instanceof MendingEnchantment || enchantment instanceof DigDurabilityEnchantment)) {
            return false;
        }
        if (enchantment.f_44672_ == null) {
            return true;
        }
        switch (enchantment.f_44672_) {
            case DIGGER: {
                return this.getToolStats().isSuitableForBlockBreak(stack);
            }
            case WEAPON: {
                return this.getToolStats().isSuitableForAttacking(stack);
            }
            case BREAKABLE: {
                return stack.m_41783_() != null && !stack.m_41783_().m_128471_("Unbreakable");
            }
        }
        ToolProperty property = this.getToolProperty(stack);
        if (property == null) {
            return false;
        }
        if (!property.getEnchantments().isEmpty() && property.getEnchantments().containsKey((Object)enchantment)) {
            return true;
        }
        return this.getToolStats().isEnchantable(stack) && this.getToolStats().canApplyEnchantment(stack, enchantment);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getColor(ItemStack stack, int tintIndex) {
        return tintIndex % 2 == 1 ? this.getToolMaterial(stack).getMaterialRGB() : 0xFFFFFF;
    }

    default public void playCraftingSound(Player player, ItemStack stack) {
        if (ConfigHolder.INSTANCE.client.toolCraftingSounds && this.getSound() != null && player != null && this.canPlaySound(stack)) {
            this.setLastCraftingSoundTime(stack);
            this.playSound(player);
        }
    }

    default public void setLastCraftingSoundTime(ItemStack stack) {
        ToolHelper.getToolTag(stack).m_128405_("LastCraftingUse", (int)System.currentTimeMillis());
    }

    default public boolean canPlaySound(ItemStack stack) {
        return Math.abs((int)System.currentTimeMillis() - ToolHelper.getToolTag(stack).m_128451_("LastCraftingUse")) > 1000;
    }

    default public void playSound(Player player) {
        if (ConfigHolder.INSTANCE.client.toolUseSounds && this.getSound() != null) {
            player.m_9236_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, this.getSound().getMainEvent(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    default public ModularUI createUI(Player entityPlayer, HeldItemUIFactory.HeldItemHolder holder) {
        CompoundTag tag = ToolHelper.getBehaviorsTag(holder.getHeld());
        AoESymmetrical defaultDefinition = ToolHelper.getMaxAoEDefinition(holder.getHeld());
        return new ModularUI(120, 80, (IUIHolder)holder, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new LabelWidget(6, 10, "item.gtceu.tool.aoe.columns")).widget((Widget)new LabelWidget(49, 10, "item.gtceu.tool.aoe.rows")).widget((Widget)new LabelWidget(79, 10, "item.gtceu.tool.aoe.layers")).widget((Widget)new ButtonWidget(15, 24, 20, 20, (IGuiTexture)new TextTexture("+"), data -> {
            AoESymmetrical.increaseColumn(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget((Widget)new ButtonWidget(15, 44, 20, 20, (IGuiTexture)new TextTexture("-"), data -> {
            AoESymmetrical.decreaseColumn(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget((Widget)new ButtonWidget(50, 24, 20, 20, (IGuiTexture)new TextTexture("+"), data -> {
            AoESymmetrical.increaseRow(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget((Widget)new ButtonWidget(50, 44, 20, 20, (IGuiTexture)new TextTexture("-"), data -> {
            AoESymmetrical.decreaseRow(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget((Widget)new ButtonWidget(85, 24, 20, 20, (IGuiTexture)new TextTexture("+"), data -> {
            AoESymmetrical.increaseLayer(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget((Widget)new ButtonWidget(85, 44, 20, 20, (IGuiTexture)new TextTexture("-"), data -> {
            AoESymmetrical.decreaseLayer(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget((Widget)new LabelWidget(23, 65, () -> Integer.toString(1 + 2 * AoESymmetrical.getColumn(ToolHelper.getBehaviorsTag(holder.getHeld()), defaultDefinition)))).widget((Widget)new LabelWidget(58, 65, () -> Integer.toString(1 + 2 * AoESymmetrical.getRow(ToolHelper.getBehaviorsTag(holder.getHeld()), defaultDefinition)))).widget((Widget)new LabelWidget(93, 65, () -> Integer.toString(1 + AoESymmetrical.getLayer(ToolHelper.getBehaviorsTag(holder.getHeld()), defaultDefinition))));
    }

    default public Set<GTToolType> getToolClasses(ItemStack stack) {
        return new HashSet<GTToolType>(this.getToolType().toolClasses);
    }

    default public Set<String> getToolClassNames(ItemStack stack) {
        return this.getToolClasses(stack).stream().flatMap(type -> type.toolClassNames.stream()).collect(Collectors.toSet());
    }

    @Nullable
    default public ICapabilityProvider definition$initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        ArrayList<ICapabilityProvider> providers = new ArrayList<ICapabilityProvider>();
        if (this.isElectric()) {
            final ElectricStats item = ElectricStats.createElectricItem(0L, this.getElectricTier());
            providers.add(new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @org.jetbrains.annotations.Nullable Direction arg) {
                    return item.getCapability(stack, capability);
                }
            });
        }
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            if (!(behavior instanceof IComponentCapability)) continue;
            final IComponentCapability componentCapability = (IComponentCapability)((Object)behavior);
            providers.add(new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @org.jetbrains.annotations.Nullable Direction arg) {
                    return componentCapability.getCapability(stack, capability);
                }
            });
        }
        if (providers.isEmpty()) {
            return null;
        }
        if (providers.size() == 1) {
            return (ICapabilityProvider)providers.get(0);
        }
        return new CombinedCapabilityProvider(providers);
    }

    default public boolean definition$isCorrectToolForDrops(ItemStack stack, BlockState state) {
        Item item = stack.m_41720_();
        if (item instanceof IGTTool) {
            Tier tier2;
            IGTTool gtTool = (IGTTool)item;
            boolean isCorrectToolType = gtTool.getToolClasses(stack).stream().anyMatch(type -> type.harvestTags.stream().anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0)));
            if (!isCorrectToolType) {
                return false;
            }
            int totalLevel = gtTool.getTotalHarvestLevel(stack);
            List<Tier> tiers = TierSortingRegistry.getSortedTiers().stream().filter(tier -> tier.m_6604_() == totalLevel).toList();
            Tier tier3 = tier2 = !tiers.isEmpty() ? tiers.get(tiers.size() - 1) : null;
            if (tier2 == null) {
                return false;
            }
            return TierSortingRegistry.isCorrectTierForDrops((Tier)tier2, (BlockState)state);
        }
        return stack.m_41720_().m_8096_(state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor tintColor() {
        return (itemStack, index) -> {
            Item patt40739$temp = itemStack.m_41720_();
            if (patt40739$temp instanceof IGTTool) {
                IGTTool item = (IGTTool)patt40739$temp;
                Material material = item.getMaterial();
                return switch (index) {
                    case -101, 0 -> {
                        if (item.getToolClasses(itemStack).contains(GTToolType.CROWBAR) && itemStack.m_41782_() && ToolHelper.getToolTag(itemStack).m_128425_("TintColor", 3)) {
                            yield ToolHelper.getToolTag(itemStack).m_128451_("TintColor");
                        }
                        yield -1;
                    }
                    case -111, 1 -> material.getMaterialARGB();
                    case -121, 2 -> {
                        if (material.getMaterialSecondaryARGB() != -1) {
                            yield material.getMaterialSecondaryARGB();
                        }
                        yield material.getMaterialARGB();
                    }
                    default -> -1;
                };
            }
            return -1;
        };
    }
}

