/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.misc;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidVeinSavedData;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.FluidVeinWorldEntry;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.BedrockOreVeinSavedData;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.OreVeinWorldEntry;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;

public abstract class ProspectorMode<T> {
    public static ProspectorMode<String> ORE = new ProspectorMode<String>("metaitem.prospector.mode.ores", 16){
        private final Map<BlockState, String> BLOCK_CACHE = new HashMap<BlockState, String>();
        private final Map<String, IGuiTexture> ICON_CACHE = new HashMap<String, IGuiTexture>();

        public void scan(String[][][] storage, LevelChunk chunk) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            TagKey<Block> oreTag = TagUtil.createBlockTag("ores");
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = chunk.m_151558_() - 1; y >= chunk.m_141937_(); --y) {
                        pos.m_122178_(x, y, z);
                        BlockState state = chunk.m_8055_((BlockPos)pos);
                        if (!state.m_204336_(oreTag)) continue;
                        String itemName = this.BLOCK_CACHE.computeIfAbsent(state, blockState -> {
                            Object name = BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_()).toString();
                            UnificationEntry entry = ChemicalHelper.getUnificationEntry((ItemLike)blockState.m_60734_());
                            if (entry != null && entry.material != null) {
                                name = "material_" + entry.material.toString();
                            }
                            return name;
                        });
                        storage[x][z] = (String[])ArrayUtils.add((Object[])storage[x][z], (Object)itemName);
                    }
                }
            }
        }

        @Override
        public int getItemColor(String item) {
            Material mat;
            if (item.startsWith("material_") && (mat = GTMaterials.get(item.substring(9))) != null) {
                return mat.getMaterialRGB();
            }
            return ((Block)BuiltInRegistries.f_256975_.m_7745_((ResourceLocation)new ResourceLocation((String)item))).m_284356_().f_283871_;
        }

        @Override
        public IGuiTexture getItemIcon(String item) {
            return this.ICON_CACHE.computeIfAbsent(item, name -> {
                Material mat;
                if (name.startsWith("material_") && (mat = GTMaterials.get(name.substring(9))) != null) {
                    ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                    for (TagPrefix oreTag : TagPrefix.ORES.keySet()) {
                        for (Block block : ChemicalHelper.getBlocks(new UnificationEntry(oreTag, mat))) {
                            list.add(new ItemStack((ItemLike)block));
                        }
                    }
                    return new ItemStackTexture((ItemStack[])list.toArray(ItemStack[]::new)).scale(0.8f);
                }
                return new ItemStackTexture(new ItemStack[]{new ItemStack((ItemLike)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(name)))}).scale(0.8f);
            });
        }

        @Override
        public String getDescriptionId(String item) {
            Material mat;
            if (item.startsWith("material_") && (mat = GTMaterials.get(item.substring(9))) != null) {
                return mat.getUnlocalizedName();
            }
            return ((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(item))).m_7705_();
        }

        @Override
        public String getUniqueID(String item) {
            return item;
        }

        @Override
        public void serialize(String item, FriendlyByteBuf buf) {
            buf.m_130070_(item);
        }

        @Override
        public String deserialize(FriendlyByteBuf buf) {
            return buf.m_130277_();
        }

        @Override
        public Class<String> getItemClass() {
            return String.class;
        }

        @Override
        public void appendTooltips(List<String[]> items, List<Component> tooltips, String selected) {
            HashMap<String, Integer> counter = new HashMap<String, Integer>();
            for (String[] array : items) {
                for (String item2 : array) {
                    if (!"[all]".equals(selected) && !selected.equals(this.getUniqueID(item2))) continue;
                    counter.put(item2, counter.getOrDefault(item2, 0) + 1);
                }
            }
            counter.forEach((item, count) -> tooltips.add((Component)Component.m_237115_((String)this.getDescriptionId((String)item)).m_130946_(" --- " + count)));
        }
    };
    public static ProspectorMode<FluidInfo> FLUID = new ProspectorMode<FluidInfo>("metaitem.prospector.mode.fluid", 1){

        public void scan(FluidInfo[][][] storage, LevelChunk chunk) {
            ServerLevel serverLevel;
            FluidVeinWorldEntry fluidVein;
            Level level = chunk.m_62953_();
            if (level instanceof ServerLevel && (fluidVein = BedrockFluidVeinSavedData.getOrCreate(serverLevel = (ServerLevel)level).getFluidVeinWorldEntry(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_)).getDefinition() != null) {
                int left = 100 * fluidVein.getOperationsRemaining() / 100000;
                storage[0][0] = new FluidInfo[]{new FluidInfo(fluidVein.getDefinition().getStoredFluid().get(), left, fluidVein.getFluidYield())};
            }
        }

        @Override
        public int getItemColor(FluidInfo item) {
            FluidStack fluidStack = FluidStack.create((Fluid)item.fluid, (long)item.yield);
            if (fluidStack.getFluid() == Fluids.f_76195_) {
                return -36864;
            }
            return FluidHelper.getColor((FluidStack)fluidStack);
        }

        @Override
        public IGuiTexture getItemIcon(FluidInfo item) {
            return new ItemStackTexture(new Item[]{item.fluid.m_6859_()});
        }

        @Override
        public String getDescriptionId(FluidInfo item) {
            return FluidStack.create((Fluid)item.fluid, (long)item.yield).getDisplayName().getString();
        }

        @Override
        public String getUniqueID(FluidInfo item) {
            return BuiltInRegistries.f_257020_.m_7981_((Object)item.fluid).toString();
        }

        @Override
        public void serialize(FluidInfo item, FriendlyByteBuf buf) {
            buf.m_130070_(BuiltInRegistries.f_257020_.m_7981_((Object)item.fluid).toString());
            buf.m_130130_(item.left);
            buf.m_130130_(item.yield);
        }

        @Override
        public FluidInfo deserialize(FriendlyByteBuf buf) {
            return new FluidInfo((Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(buf.m_130277_())), buf.m_130242_(), buf.m_130242_());
        }

        @Override
        public Class<FluidInfo> getItemClass() {
            return FluidInfo.class;
        }

        @Override
        public void appendTooltips(List<FluidInfo[]> items, List<Component> tooltips, String selected) {
            for (FluidInfo[] array : items) {
                for (FluidInfo item : array) {
                    tooltips.add((Component)Component.m_237115_((String)this.getDescriptionId(item)).m_130946_(" --- %s (%s%%)".formatted(item.yield, item.left)));
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void drawSpecialGrid(GuiGraphics graphics, FluidInfo[] items, int x, int y, int width, int height) {
            if (items.length > 0) {
                FluidInfo item = items[0];
                double progress = (double)item.left * 1.0 / (double)Math.max(Math.min(item.left, 100), 1);
                float drawnU = (float)ProgressTexture.FillDirection.DOWN_TO_UP.getDrawnU(progress);
                float drawnV = (float)ProgressTexture.FillDirection.DOWN_TO_UP.getDrawnV(progress);
                float drawnWidth = (float)ProgressTexture.FillDirection.DOWN_TO_UP.getDrawnWidth(progress);
                float drawnHeight = (float)ProgressTexture.FillDirection.DOWN_TO_UP.getDrawnHeight(progress);
                DrawerHelper.drawFluidForGui((GuiGraphics)graphics, (FluidStack)FluidStack.create((Fluid)item.fluid(), (long)item.left), (long)100L, (int)((int)((float)x + drawnU * (float)width)), (int)((int)((float)y + drawnV * (float)height)), (int)((int)((float)width * drawnWidth)), (int)((int)((float)height * drawnHeight)));
            }
        }
    };
    public static ProspectorMode<OreInfo> BEDROCK_ORE = new ProspectorMode<OreInfo>("metaitem.prospector.mode.bedrock_ore", 1){

        public void scan(OreInfo[][][] storage, LevelChunk chunk) {
            ServerLevel serverLevel;
            OreVeinWorldEntry oreVein;
            Level level = chunk.m_62953_();
            if (level instanceof ServerLevel && (oreVein = BedrockOreVeinSavedData.getOrCreate(serverLevel = (ServerLevel)level).getOreVeinWorldEntry(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_)).getDefinition() != null) {
                int left = 100 * oreVein.getOperationsRemaining() / 100000;
                for (Map.Entry<Integer, Material> entry : oreVein.getDefinition().getBedrockVeinMaterials()) {
                    storage[0][0] = (OreInfo[])ArrayUtils.add((Object[])storage[0][0], (Object)new OreInfo(entry.getValue(), entry.getKey(), left, oreVein.getOreYield()));
                }
            }
        }

        @Override
        public int getItemColor(OreInfo item) {
            return item.material.getMaterialRGB();
        }

        @Override
        public IGuiTexture getItemIcon(OreInfo item) {
            Material material = item.material;
            ItemStack stack = ChemicalHelper.get(TagPrefix.get(ConfigHolder.INSTANCE.machines.bedrockOreDropTagPrefix), material);
            if (stack.m_41619_()) {
                stack = ChemicalHelper.get(TagPrefix.crushed, material);
            }
            if (stack.m_41619_()) {
                stack = ChemicalHelper.get(TagPrefix.gem, material);
            }
            if (stack.m_41619_()) {
                stack = ChemicalHelper.get(TagPrefix.ore, material);
            }
            return new ItemStackTexture(new ItemStack[]{stack}).scale(0.8f);
        }

        @Override
        public String getDescriptionId(OreInfo item) {
            return item.material.getUnlocalizedName();
        }

        @Override
        public String getUniqueID(OreInfo item) {
            return item.material.getName();
        }

        @Override
        public void serialize(OreInfo item, FriendlyByteBuf buf) {
            buf.m_130085_(item.material.getResourceLocation());
            buf.m_130130_(item.weight);
            buf.m_130130_(item.left);
            buf.m_130130_(item.yield);
        }

        @Override
        public OreInfo deserialize(FriendlyByteBuf buf) {
            ResourceLocation materialId = buf.m_130281_();
            return new OreInfo((Material)GTCEuAPI.materialManager.getRegistry(materialId.m_135827_()).get(materialId.m_135815_()), buf.m_130242_(), buf.m_130242_(), buf.m_130242_());
        }

        @Override
        public Class<OreInfo> getItemClass() {
            return OreInfo.class;
        }

        @Override
        public void appendTooltips(List<OreInfo[]> items, List<Component> tooltips, String selected) {
            for (OreInfo[] array : items) {
                int totalWeight = Arrays.stream(array).mapToInt(OreInfo::weight).sum();
                for (OreInfo item : array) {
                    float chance = (float)item.weight / (float)totalWeight * 100.0f;
                    tooltips.add((Component)Component.m_237115_((String)this.getDescriptionId(item)).m_130946_(" (").m_7220_((Component)Component.m_237110_((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{FormattingUtil.formatNumber2Places(chance)})).m_130946_(") --- %s (%s%%)".formatted(item.yield, item.left)));
                }
            }
        }
    };
    public final String unlocalizedName;
    public final int cellSize;

    ProspectorMode(@Nonnull String unlocalizedName, int cellSize) {
        this.unlocalizedName = unlocalizedName;
        this.cellSize = cellSize;
    }

    public abstract void scan(T[][][] var1, LevelChunk var2);

    public abstract int getItemColor(T var1);

    public abstract IGuiTexture getItemIcon(T var1);

    public abstract String getDescriptionId(T var1);

    public abstract String getUniqueID(T var1);

    public abstract void serialize(T var1, FriendlyByteBuf var2);

    public abstract T deserialize(FriendlyByteBuf var1);

    public abstract Class<T> getItemClass();

    public abstract void appendTooltips(List<T[]> var1, List<Component> var2, String var3);

    @OnlyIn(value=Dist.CLIENT)
    public void drawSpecialGrid(GuiGraphics graphics, T[] items, int x, int y, int width, int height) {
    }

    public record OreInfo(Material material, int weight, int left, int yield) {
    }

    public record FluidInfo(Fluid fluid, int left, int yield) {
    }
}

