/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.fancy;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PageSwitcher
implements IFancyUIProvider {
    private final Consumer<IFancyUIProvider> onPageSwitched;
    private List<IFancyUIProvider> pages = List.of();
    private IFancyUIProvider currentPage = null;

    public PageSwitcher(Consumer<IFancyUIProvider> onPageSwitched) {
        this.onPageSwitched = onPageSwitched;
    }

    public void setPageList(List<IFancyUIProvider> allPages, IFancyUIProvider currentPage) {
        this.pages = allPages;
        this.currentPage = currentPage;
    }

    @Override
    public Widget createMainPage(FancyMachineUIWidget widget) {
        WidgetGroup container = new WidgetGroup(0, 0, 176, 166);
        DraggableScrollableWidgetGroup scrollableGroup = new DraggableScrollableWidgetGroup(10, 10, 156, 146);
        scrollableGroup.setYScrollBarWidth(8);
        scrollableGroup.setYBarStyle((IGuiTexture)GuiTextures.SLIDER_BACKGROUND_VERTICAL, (IGuiTexture)GuiTextures.BUTTON);
        container.addWidget((Widget)scrollableGroup);
        int currentY = 0;
        for (IFancyUIProvider page : this.pages) {
            WidgetGroup pageWidget = new WidgetGroup(0, currentY, 146, 24);
            pageWidget.addWidget((Widget)new ButtonWidget(0, 0, 146, 24, (IGuiTexture)GuiTextures.BACKGROUND, clickData -> this.onPageSwitched.accept(page)));
            pageWidget.addWidget((Widget)new ImageWidget(2, 2, 20, 20, page.getTabIcon()));
            pageWidget.addWidget((Widget)new ImageWidget(24, 2, 118, 20, (IGuiTexture)new TextTexture(ChatFormatting.BLACK.toString() + page.getTitle().getString()).setDropShadow(false).setWidth(118).setType(TextTexture.TextType.LEFT_ROLL_ALWAYS)));
            scrollableGroup.addWidget((Widget)pageWidget);
            currentY += 28;
        }
        return container;
    }

    @Override
    public IGuiTexture getTabIcon() {
        return new TextTexture("+").setDropShadow(false).setColor(ChatFormatting.BLACK.m_126665_().intValue());
    }

    @Override
    public Component getTitle() {
        return Component.m_237115_((String)"gtceu.gui.title_bar.page_switcher");
    }

    @Override
    public boolean hasPlayerInventory() {
        return false;
    }
}

