/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.editor;

import com.gregtechceu.gtceu.api.gui.editor.UIMainPanel;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.data.UIProject;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.tool.WidgetToolBox;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.TabButton;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

@LDLRegister(name="rtui", group="editor.gtceu")
public class RecipeTypeUIProject
extends UIProject {
    @Nullable
    protected GTRecipeType recipeType;

    private RecipeTypeUIProject() {
        this(null, null);
    }

    public RecipeTypeUIProject(Resources resources, WidgetGroup root) {
        super(resources, root);
    }

    public RecipeTypeUIProject(CompoundTag tag) {
        super(tag);
    }

    public RecipeTypeUIProject newEmptyProject() {
        return new RecipeTypeUIProject(Resources.defaultResource(), new WidgetGroup(30, 30, 200, 200));
    }

    public UIProject loadProject(File file) {
        try {
            CompoundTag tag = NbtIo.m_128953_((File)file);
            if (tag != null) {
                return new RecipeTypeUIProject(tag);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        if (this.recipeType != null) {
            tag.m_128359_("recipe_type", this.recipeType.registryName.toString());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        if (tag.m_128441_("recipe_type")) {
            this.recipeType = (GTRecipeType)GTRegistries.RECIPE_TYPES.get(new ResourceLocation(tag.m_128461_("recipe_type")));
        }
    }

    public void onLoad(Editor editor) {
        editor.getResourcePanel().loadResource(this.getResources(), false);
        editor.getTabPages().addTab(new TabButton(50, 16, 60, 14).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GREEN.rectTexture().setBottomRadius(10.0f).transform(0.0f, 0.4f), new TextTexture("Main")}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_RED.rectTexture().setBottomRadius(10.0f).transform(0.0f, 0.4f), new TextTexture("Main")})), (WidgetGroup)new UIMainPanel(editor, this.root, this.recipeType == null ? null : this.recipeType.registryName.m_214298_()));
        for (WidgetToolBox.Default tab : WidgetToolBox.Default.TABS) {
            editor.getToolPanel().addNewToolBox("ldlib.gui.editor.group." + tab.groupName, tab.icon, (WidgetGroup)tab.createToolBox());
        }
    }

    public void attachMenu(Editor editor, String name, TreeBuilder.Menu menu) {
        if (name.equals("file")) {
            if (this.recipeType == null) {
                menu.remove("ldlib.gui.editor.menu.save");
            } else {
                menu.remove("ldlib.gui.editor.menu.save");
                menu.leaf((IGuiTexture)Icons.SAVE, "ldlib.gui.editor.menu.save", () -> {
                    File path = new File(LDLib.getLDLibDir(), "assets/%s/ui/recipe_type".formatted(this.recipeType.registryName.m_135827_()));
                    path.mkdirs();
                    this.saveProject(new File(path, this.recipeType.registryName.m_135815_() + "." + this.getRegisterUI().name()));
                    this.recipeType.getRecipeUI().reloadCustomUI();
                });
            }
        } else if (name.equals("template_tab")) {
            LinkedHashMap<String, List> categories = new LinkedHashMap<String, List>();
            for (GTRecipeType recipeType : GTRegistries.RECIPE_TYPES) {
                categories.computeIfAbsent(recipeType.group, group -> new ArrayList()).add(recipeType);
            }
            categories.forEach((groupName, recipeTypes) -> menu.branch(groupName, m -> {
                for (GTRecipeType recipeType : recipeTypes) {
                    ItemStackTexture icon = recipeType.getIconSupplier() != null ? new ItemStackTexture(new ItemStack[]{recipeType.getIconSupplier().get()}) : new ItemStackTexture(new Item[]{Items.f_42127_});
                    m.leaf((IGuiTexture)icon, recipeType.registryName.m_214298_(), () -> {
                        this.root.clearAllWidgets();
                        if (recipeType.getRecipeUI().hasCustomUI()) {
                            CompoundTag nbt = recipeType.getRecipeUI().getCustomUI();
                            IConfigurableWidget.deserializeNBT((IConfigurableWidget)this.root, (CompoundTag)nbt.m_128469_("root"), (Resources)Resources.fromNBT((CompoundTag)nbt.m_128469_("resources")), (boolean)false);
                        } else {
                            WidgetGroup widget = recipeType.getRecipeUI().createEditableUITemplate(false, false).createDefault();
                            this.root.setSize(widget.getSize());
                            for (Widget children : widget.widgets) {
                                this.root.addWidget(children);
                            }
                        }
                        this.setRecipeType(recipeType);
                    });
                }
            }));
        }
    }

    @Nullable
    public GTRecipeType getRecipeType() {
        return this.recipeType;
    }

    public void setRecipeType(@Nullable GTRecipeType recipeType) {
        this.recipeType = recipeType;
    }
}

