/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.fluids;

import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.attribute.FluidAttribute;
import com.gregtechceu.gtceu.api.fluids.attribute.IAttributedFluid;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class GTFluid
extends FlowingFluid
implements IAttributedFluid {
    private final Collection<FluidAttribute> attributes = new ObjectLinkedOpenHashSet();
    private final FluidState state;
    private final Supplier<? extends Item> bucketItem;
    private final Supplier<? extends Fluid> stillFluid;
    private final Supplier<? extends Fluid> flowingFluid;
    private final Supplier<? extends LiquidBlock> block;
    private final int burnTime;

    public GTFluid(@NotNull FluidState state, Supplier<? extends Fluid> stillFluid, Supplier<? extends Fluid> flowingFluid, Supplier<? extends LiquidBlock> block, Supplier<? extends Item> bucket, int burnTime) {
        this.state = state;
        this.stillFluid = stillFluid;
        this.flowingFluid = flowingFluid;
        this.block = block;
        this.bucketItem = bucket;
        this.burnTime = burnTime;
    }

    @Override
    public void addAttribute(@NotNull FluidAttribute attribute) {
        this.attributes.add(attribute);
    }

    protected boolean m_5486_(net.minecraft.world.level.material.FluidState state, BlockGetter level, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !this.m_6212_(fluid);
    }

    public int m_6718_(LevelReader level) {
        return 5;
    }

    protected float m_6752_() {
        return 10.0f;
    }

    protected int m_6719_(LevelReader level) {
        return 4;
    }

    protected int m_6713_(LevelReader level) {
        return 1;
    }

    protected BlockState m_5804_(net.minecraft.world.level.material.FluidState state) {
        if (this.block != null && this.block.get() != null) {
            return (BlockState)this.block.get().m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(GTFluid.m_76092_((net.minecraft.world.level.material.FluidState)state)));
        }
        return Blocks.f_50016_.m_49966_();
    }

    public Fluid m_5615_() {
        return this.flowingFluid != null && this.flowingFluid.get() != null ? this.flowingFluid.get() : Fluids.f_76191_;
    }

    public Fluid m_5613_() {
        return this.stillFluid != null && this.stillFluid.get() != null ? this.stillFluid.get() : Fluids.f_76191_;
    }

    public Item m_6859_() {
        return this.bucketItem != null && this.bucketItem.get() != null ? this.bucketItem.get() : Items.f_41852_;
    }

    protected boolean m_6760_(Level world) {
        return false;
    }

    protected void m_7456_(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.m_155947_() ? level.m_7702_(pos) : null;
        Block.m_49892_((BlockState)state, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    public boolean m_6212_(Fluid fluid) {
        boolean still = this.m_5613_() == fluid;
        boolean flowing = this.m_5615_() == fluid;
        return still || flowing;
    }

    @Override
    public Collection<FluidAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public FluidState getState() {
        return this.state;
    }

    public int getBurnTime() {
        return this.burnTime;
    }
}

