/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.properties;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class OreProperty
implements IMaterialProperty<OreProperty> {
    private final List<Material> oreByProducts = new ArrayList<Material>();
    private int oreMultiplier;
    private int byProductMultiplier;
    private boolean emissive;
    @Nullable
    private Material directSmeltResult;
    @Nullable
    private Material washedIn;
    private int washedAmount = 100;
    private final List<Material> separatedInto = new ArrayList<Material>();

    public OreProperty(int oreMultiplier, int byProductMultiplier) {
        this.oreMultiplier = oreMultiplier;
        this.byProductMultiplier = byProductMultiplier;
        this.emissive = false;
    }

    public OreProperty(int oreMultiplier, int byProductMultiplier, boolean emissive) {
        this.oreMultiplier = oreMultiplier;
        this.byProductMultiplier = byProductMultiplier;
        this.emissive = emissive;
    }

    public OreProperty() {
        this(1, 1);
    }

    public void setOreMultiplier(int multiplier) {
        this.oreMultiplier = multiplier;
    }

    public int getOreMultiplier() {
        return this.oreMultiplier;
    }

    public void setByProductMultiplier(int multiplier) {
        this.byProductMultiplier = multiplier;
    }

    public int getByProductMultiplier() {
        return this.byProductMultiplier;
    }

    public boolean isEmissive() {
        return this.emissive;
    }

    public void setEmissive(boolean emissive) {
        this.emissive = emissive;
    }

    public void setDirectSmeltResult(@Nullable Material m) {
        this.directSmeltResult = m;
    }

    @Nullable
    public Material getDirectSmeltResult() {
        return this.directSmeltResult;
    }

    public void setWashedIn(@Nullable Material m) {
        this.washedIn = m;
    }

    public void setWashedIn(@Nullable Material m, int washedAmount) {
        this.washedIn = m;
        this.washedAmount = washedAmount;
    }

    public Pair<Material, Integer> getWashedIn() {
        return Pair.of((Object)this.washedIn, (Object)this.washedAmount);
    }

    public void setSeparatedInto(Material ... materials) {
        this.separatedInto.addAll(Arrays.asList(materials));
    }

    @Nullable
    public List<Material> getSeparatedInto() {
        return this.separatedInto;
    }

    public void setOreByProducts(Material ... materials) {
        this.oreByProducts.addAll(Arrays.asList(materials));
    }

    public List<Material> getOreByProducts() {
        return this.oreByProducts;
    }

    @Nullable
    public final Material getOreByProduct(int index) {
        if (this.oreByProducts.isEmpty()) {
            return null;
        }
        return this.oreByProducts.get(Mth.m_14045_((int)index, (int)0, (int)(this.oreByProducts.size() - 1)));
    }

    @NotNull
    public final Material getOreByProduct(int index, @NotNull Material fallback) {
        Material material = this.getOreByProduct(index);
        return material != null ? material : fallback;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        properties.ensureSet(PropertyKey.DUST, true);
        if (this.directSmeltResult != null) {
            this.directSmeltResult.getProperties().ensureSet(PropertyKey.DUST, true);
        }
        if (this.washedIn != null) {
            this.washedIn.getProperties().ensureSet(PropertyKey.FLUID, true);
        }
        this.separatedInto.forEach(m -> m.getProperties().ensureSet(PropertyKey.DUST, true));
        this.oreByProducts.forEach(m -> m.getProperties().ensureSet(PropertyKey.DUST, true));
    }
}

