/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability;

import com.gregtechceu.gtceu.api.capability.IPlatformEnergyStorage;
import com.gregtechceu.gtceu.config.ConfigHolder;

public class PlatformEnergyCompat {
    public static int ratio(boolean nativeToEu) {
        return nativeToEu ? ConfigHolder.INSTANCE.compat.energy.platformToEuRatio : ConfigHolder.INSTANCE.compat.energy.euToPlatformRatio;
    }

    public static int toNative(long eu, int ratio) {
        return (int)PlatformEnergyCompat.toNativeLong(eu, ratio);
    }

    public static long toNativeLong(long eu, int ratio) {
        return eu * (long)ratio;
    }

    public static long toNativeBounded(long eu, int ratio, int max) {
        return Math.min((long)max, PlatformEnergyCompat.toNativeLong(eu, ratio));
    }

    public static long toEu(long nat, int ratio) {
        return nat / (long)ratio;
    }

    public static long insertEu(IPlatformEnergyStorage storage, long amountEU) {
        int euToNativeRatio = PlatformEnergyCompat.ratio(false);
        long nativeSent = storage.insert(PlatformEnergyCompat.toNativeLong(amountEU, euToNativeRatio), true);
        return PlatformEnergyCompat.toEu(storage.insert(nativeSent - nativeSent % (long)euToNativeRatio, false), euToNativeRatio);
    }

    public static long extractEu(IPlatformEnergyStorage storage, long amountEU) {
        int euToNativeRatio = PlatformEnergyCompat.ratio(false);
        long extract = storage.extract(PlatformEnergyCompat.toNativeLong(amountEU, euToNativeRatio), true);
        return PlatformEnergyCompat.toEu(storage.extract(extract - extract % (long)euToNativeRatio, false), euToNativeRatio);
    }
}

