/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.block;

import com.gregtechceu.gtceu.api.block.AppearanceBlock;
import com.gregtechceu.gtceu.api.block.BlockProperties;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IToolable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.api.pipenet.IPipeType;
import com.gregtechceu.gtceu.api.pipenet.LevelPipeNet;
import com.gregtechceu.gtceu.api.pipenet.PipeNet;
import com.gregtechceu.gtceu.client.model.PipeModel;
import com.gregtechceu.gtceu.client.renderer.block.PipeBlockRenderer;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.item.CoverPlaceBehavior;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.client.renderer.IBlockRendererProvider;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class PipeBlock<PipeType extends Enum<PipeType>, NodeDataType, WorldPipeNetType extends LevelPipeNet<NodeDataType, ? extends PipeNet<NodeDataType>>>
extends AppearanceBlock
implements EntityBlock,
IBlockRendererProvider {
    public final PipeType pipeType;

    public PipeBlock(BlockBehaviour.Properties properties, PipeType pipeType) {
        super(properties);
        this.pipeType = pipeType;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{BlockProperties.SERVER_TICK}));
    }

    public final PipeBlockEntity<PipeType, NodeDataType> newBlockEntity(BlockPos pos, BlockState state) {
        return (PipeBlockEntity)this.getBlockEntityType().m_155264_(pos, state);
    }

    public abstract WorldPipeNetType getWorldPipeNet(ServerLevel var1);

    public abstract BlockEntityType<? extends PipeBlockEntity<PipeType, NodeDataType>> getBlockEntityType();

    public abstract NodeDataType createRawData(BlockState var1, @Nullable ItemStack var2);

    public NodeDataType createProperties(BlockState state, @Nullable ItemStack stack) {
        return ((IPipeType)this.pipeType).modifyProperties(this.createRawData(state, stack));
    }

    public abstract NodeDataType createProperties(IPipeNode<PipeType, NodeDataType> var1);

    public abstract NodeDataType getFallbackType();

    @Nullable
    public abstract PipeBlockRenderer getRenderer(BlockState var1);

    protected abstract PipeModel getPipeModel();

    public void updateActiveNodeStatus(@NotNull Level worldIn, BlockPos pos, IPipeNode<PipeType, NodeDataType> pipeTile) {
        int activeConnections;
        boolean isActiveNodeNow;
        boolean modeChanged;
        if (worldIn.f_46443_) {
            return;
        }
        Object pipeNet = ((LevelPipeNet)((Object)this.getWorldPipeNet((ServerLevel)worldIn))).getNetFromPos(pos);
        if (pipeNet != null && pipeTile != null && (modeChanged = ((PipeNet)pipeNet).markNodeAsActive(pos, isActiveNodeNow = (activeConnections = pipeTile.getConnections()) != 0))) {
            this.onActiveModeChange(worldIn, pos, isActiveNodeNow, false);
        }
    }

    @Nullable
    public IPipeNode<PipeType, NodeDataType> getPipeTile(BlockGetter level, BlockPos pos) {
        IPipeNode pipeTile;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IPipeNode && ((IPipeType)(pipeTile = (IPipeNode)blockEntity).getPipeType()).type().equals((Object)((IPipeType)this.pipeType).type())) {
            return pipeTile;
        }
        return null;
    }

    protected void onActiveModeChange(Level world, BlockPos pos, boolean isActiveNow, boolean isInitialChange) {
    }

    public boolean canConnect(IPipeNode<PipeType, NodeDataType> selfTile, Direction facing) {
        if (selfTile.getPipeLevel().m_8055_(selfTile.getPipePos().m_121945_(facing)).m_60734_() == Blocks.f_50016_) {
            return false;
        }
        CoverBehavior cover = selfTile.getCoverContainer().getCoverAtSide(facing);
        if (cover != null && !cover.canPipePassThrough()) {
            return false;
        }
        BlockEntity other = selfTile.getNeighbor(facing);
        if (other instanceof IPipeNode) {
            IPipeNode node = (IPipeNode)other;
            cover = node.getCoverContainer().getCoverAtSide(facing.m_122424_());
            if (cover != null && !cover.canPipePassThrough()) {
                return false;
            }
            return this.canPipesConnect(selfTile, facing, (IPipeNode)other);
        }
        return this.canPipeConnectToBlock(selfTile, facing, other);
    }

    public abstract boolean canPipesConnect(IPipeNode<PipeType, NodeDataType> var1, Direction var2, IPipeNode<PipeType, NodeDataType> var3);

    public abstract boolean canPipeConnectToBlock(IPipeNode<PipeType, NodeDataType> var1, Direction var2, @Nullable BlockEntity var3);

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        IPipeNode<PipeType, NodeDataType> pipeTile = this.getPipeTile((BlockGetter)level, pos);
        if (pipeTile != null && placer instanceof Player) {
            Player player = (Player)placer;
            ItemStack offhand = placer.m_21206_();
            for (int i = 0; i < DyeColor.values().length; ++i) {
                if (!offhand.m_150930_((Item)GTItems.SPRAY_CAN_DYES[i].get())) continue;
                ((IInteractionItem)((ComponentItem)((Object)GTItems.SPRAY_CAN_DYES[i].get())).getComponents().get(0)).useOn(new UseOnContext(player, InteractionHand.OFF_HAND, new BlockHitResult(Vec3.f_82478_, player.m_6350_(), pos, false)));
                break;
            }
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.m_186460_(pos, (Block)this, 1);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.f_46443_) {
            return;
        }
        IPipeNode<PipeType, NodeDataType> pipeTile = this.getPipeTile((BlockGetter)level, pos);
        if (pipeTile != null) {
            Direction facing = GTUtil.getFacingToNeighbor(pos, fromPos);
            if (facing == null) {
                return;
            }
            if (!ConfigHolder.INSTANCE.machines.gt6StylePipesCables) {
                boolean canConnect;
                boolean open = pipeTile.isConnected(facing);
                boolean bl = canConnect = pipeTile.getCoverContainer().getCoverAtSide(facing) != null || this.canConnect(pipeTile, facing);
                if (!open && canConnect && state.m_60734_() != block) {
                    pipeTile.setConnection(facing, true, false);
                }
                if (open && !canConnect) {
                    pipeTile.setConnection(facing, false, false);
                }
                this.updateActiveNodeStatus(level, pos, pipeTile);
            }
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.m_155947_() && !pState.m_60713_(pNewState.m_60734_())) {
            pLevel.m_46747_(pPos);
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                ((LevelPipeNet)((Object)this.getWorldPipeNet(serverLevel))).removeNode(pPos);
            }
        }
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        IPipeNode<PipeType, NodeDataType> pipeTile = this.getPipeTile((BlockGetter)level, pos);
        if (pipeTile != null) {
            pipeTile.getCoverContainer().dropAllCovers();
        }
        super.m_6786_(level, pos, state);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ((LevelPipeNet)((Object)this.getWorldPipeNet(serverLevel))).removeNode(pos);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        IPipeNode<PipeType, NodeDataType> pipeTile = this.getPipeTile((BlockGetter)level, pos);
        if (pipeTile != null) {
            int activeConnections = pipeTile.getConnections();
            boolean isActiveNode = activeConnections != 0;
            ((LevelPipeNet)((Object)this.getWorldPipeNet(level))).addNode(pos, this.createRawData(state, null), 0, activeConnections, isActiveNode);
            this.onActiveModeChange((Level)level, pos, isActiveNode, true);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        BlockEntity entity = level.m_7702_(pos);
        Set<GTToolType> types = ToolHelper.getToolTypes(itemStack);
        if (entity instanceof IToolable) {
            IToolable toolable = (IToolable)entity;
            if (!types.isEmpty() && ToolHelper.canUse(itemStack)) {
                Pair<GTToolType, InteractionResult> result = toolable.onToolClick(types, itemStack, new UseOnContext(player, hand, hit));
                if (result.getSecond() == InteractionResult.CONSUME && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ToolHelper.playToolSound((GTToolType)result.getFirst(), serverPlayer);
                    if (!serverPlayer.m_7500_()) {
                        ToolHelper.damageItem(itemStack, (LivingEntity)serverPlayer, 1);
                    }
                }
                return (InteractionResult)result.getSecond();
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext context) {
        int connections;
        block4: {
            VoxelShape shape;
            block5: {
                block6: {
                    BlockItem blockItem;
                    EntityCollisionContext entityCtx;
                    Entity entity;
                    IPipeNode<PipeType, NodeDataType> pipeNode = this.getPipeTile(pLevel, pPos);
                    connections = 0;
                    if (pipeNode == null) break block4;
                    connections = pipeNode.getVisualConnections();
                    shape = this.getPipeModel().getShapes(connections);
                    shape = Shapes.m_83124_((VoxelShape)shape, (VoxelShape[])pipeNode.getCoverContainer().addCoverCollisionBoundingBox());
                    if (!(context instanceof EntityCollisionContext) || !((entity = (entityCtx = (EntityCollisionContext)context).m_193113_()) instanceof Player)) break block5;
                    Player player = (Player)entity;
                    ICoverable coverable = pipeNode.getCoverContainer();
                    ItemStack held = player.m_21205_();
                    Set<GTToolType> types = Set.of(GTToolType.WIRE_CUTTER, GTToolType.WRENCH);
                    BlockEntity tile = pLevel.m_7702_(pPos);
                    if (tile instanceof PipeBlockEntity) {
                        PipeBlockEntity pipeTile = (PipeBlockEntity)tile;
                        types = Set.of(pipeTile.getPipeTuneTool());
                    }
                    if (types.stream().anyMatch(type -> type.itemTags.stream().anyMatch(arg_0 -> ((ItemStack)held).m_204117_(arg_0)))) break block6;
                    if (CoverPlaceBehavior.isCoverBehaviorItem(held, coverable::hasAnyCover, coverDef -> ICoverable.canPlaceCover(coverDef, coverable))) break block6;
                    Item item = held.m_41720_();
                    if (!(item instanceof BlockItem) || !((item = (blockItem = (BlockItem)item).m_40614_()) instanceof PipeBlock)) break block5;
                    PipeBlock pipeBlock = (PipeBlock)item;
                    if (!((IPipeType)pipeBlock.pipeType).type().equals((Object)((IPipeType)this.pipeType).type())) break block5;
                }
                return Shapes.m_83144_();
            }
            return shape;
        }
        return this.getPipeModel().getShapes(connections);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (blockEntityType == this.getBlockEntityType() && !level.f_46443_ && ((Boolean)state.m_61143_((Property)BlockProperties.SERVER_TICK)).booleanValue()) {
            return (pLevel, pPos, pState, pTile) -> {
                if (pTile instanceof IPipeNode) {
                    IPipeNode pipeNode = (IPipeNode)pTile;
                    pipeNode.serverTick();
                }
            };
        }
        return null;
    }

    @Override
    public BlockState getBlockAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState sourceState, BlockPos sourcePos) {
        BlockState appearance;
        IPipeNode<PipeType, NodeDataType> pipe = this.getPipeTile((BlockGetter)level, pos);
        if (pipe != null && (appearance = pipe.getCoverContainer().getBlockAppearance(state, level, pos, side, sourceState, sourcePos)) != null) {
            return appearance;
        }
        return super.getBlockAppearance(state, level, pos, side, sourceState, sourcePos);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        LootParams context = builder.m_287286_(LootContextParams.f_81461_, (Object)state).m_287235_(LootContextParamSets.f_81421_);
        BlockEntity tileEntity = (BlockEntity)context.m_287267_(LootContextParams.f_81462_);
        if (tileEntity instanceof IPipeNode) {
            IPipeNode pipeTile = (IPipeNode)tileEntity;
            for (Direction direction : GTUtil.DIRECTIONS) {
                pipeTile.getCoverContainer().removeCover(direction, null);
            }
        }
        return super.m_49635_(state, builder);
    }
}

