/*
 * Decompiled with CFR 0.152.
 */
package lykrast.glassential;

import java.util.function.Supplier;
import lykrast.glassential.blocks.DarkEtherealGlassBlock;
import lykrast.glassential.blocks.EtherealGlassBlock;
import lykrast.glassential.blocks.RedstoneGlassBlock;
import lykrast.glassential.blocks.TooltipGlassBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="glassential")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="glassential")
public class Glassential {
    public static final String MODID = "glassential";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"glassential");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"glassential");
    public static final RegistryObject<Item> GLASS_DARK_ETHEREAL = Glassential.makeBlock("glass_dark_ethereal", () -> new DarkEtherealGlassBlock(Glassential.glassProp().m_60910_(), false));
    public static final RegistryObject<Item> GLASS_DARK_ETHEREAL_REVERSE = Glassential.makeBlock("glass_dark_ethereal_reverse", () -> new DarkEtherealGlassBlock(Glassential.glassProp().m_60910_(), true));
    public static final RegistryObject<Item> GLASS_ETHEREAL = Glassential.makeBlock("glass_ethereal", () -> new EtherealGlassBlock(Glassential.glassProp().m_60910_(), false));
    public static final RegistryObject<Item> GLASS_ETHEREAL_REVERSE = Glassential.makeBlock("glass_ethereal_reverse", () -> new EtherealGlassBlock(Glassential.glassProp().m_60910_(), true));
    public static final RegistryObject<Item> GLASS_GHOSTLY = Glassential.makeBlock("glass_ghostly", () -> new TooltipGlassBlock(Glassential.glassProp().m_60910_(), "tooltip.glassential.ghostly"));
    public static final RegistryObject<Item> GLASS_LIGHT = Glassential.makeBlock("glass_light", () -> new TooltipGlassBlock(Glassential.glassProp().m_60953_(b -> 15), "tooltip.glassential.light"));
    public static final RegistryObject<Item> GLASS_REDSTONE = Glassential.makeBlock("glass_redstone", () -> new RedstoneGlassBlock(Glassential.glassProp()));

    public Glassential() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerTabItems);
        BLOCKS.register(bus);
        ITEMS.register(bus);
    }

    private static RegistryObject<Item> makeBlock(String name, Supplier<Block> block) {
        RegistryObject regged = BLOCKS.register(name, block);
        RegistryObject item = ITEMS.register(name, () -> new BlockItem((Block)regged.get(), new Item.Properties()));
        return item;
    }

    private static BlockBehaviour.Properties glassProp() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60922_(Glassential::neverAllowSpawn).m_60924_(Glassential::isntSolid).m_60960_(Glassential::isntSolid).m_60971_(Glassential::isntSolid);
    }

    private static Boolean neverAllowSpawn(BlockState state, BlockGetter reader, BlockPos pos, EntityType<?> entity) {
        return false;
    }

    private static boolean isntSolid(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    private void registerTabItems(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            event.accept(GLASS_DARK_ETHEREAL);
            event.accept(GLASS_DARK_ETHEREAL_REVERSE);
            event.accept(GLASS_ETHEREAL);
            event.accept(GLASS_ETHEREAL_REVERSE);
            event.accept(GLASS_GHOSTLY);
            event.accept(GLASS_LIGHT);
        }
        if (event.getTabKey() == CreativeModeTabs.f_257028_) {
            event.accept(GLASS_REDSTONE);
        }
    }
}

