/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.common.block;

import cy.jdkdigital.generatorgalore.common.block.entity.GeneratorBlockEntity;
import cy.jdkdigital.generatorgalore.util.GeneratorObject;
import cy.jdkdigital.generatorgalore.util.GeneratorUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class Generator
extends BaseEntityBlock {
    GeneratorObject generator;

    public Generator(BlockBehaviour.Properties properties, GeneratorObject generator) {
        super(properties);
        this.generator = generator;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_, BlockStateProperties.f_61443_});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : Generator.m_152132_(blockEntityType, this.generator.getBlockEntityType().get(), GeneratorBlockEntity::tick);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    @NotNull
    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new GeneratorBlockEntity(this.generator, pos, state);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GeneratorBlockEntity) {
            GeneratorBlockEntity generatorBlockEntity = (GeneratorBlockEntity)blockEntity;
            if (this.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID) && player.m_21120_(hand).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent() && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)pos, null)) {
                return InteractionResult.CONSUME;
            }
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)generatorBlockEntity, packetBuffer -> packetBuffer.m_130064_(pos));
        }
        return InteractionResult.CONSUME;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean something) {
        BlockEntity generatorTile = level.m_7702_(pos);
        if (generatorTile instanceof GeneratorBlockEntity) {
            GeneratorBlockEntity generatorBlockEntity = (GeneratorBlockEntity)generatorTile;
            generatorBlockEntity.refreshConnectedTileEntityCache();
        }
        super.m_6807_(state, level, pos, newState, something);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        BlockEntity generatorTile = level.m_7702_(pos);
        if (generatorTile instanceof GeneratorBlockEntity) {
            GeneratorBlockEntity generatorBlockEntity = (GeneratorBlockEntity)generatorTile;
            generatorBlockEntity.refreshConnectedTileEntityCache();
        }
        return super.m_7417_(state, direction, newState, level, pos, facingPos);
    }

    public void m_214162_(BlockState pState, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            double d2;
            double d1;
            double d0;
            int i;
            if (random.m_188503_(11) == 0) {
                block5: for (i = 0; i < random.m_188503_(1) + 1; ++i) {
                    switch (this.generator.getFuelType()) {
                        case FLUID: {
                            continue block5;
                        }
                        case FOOD: {
                            d0 = (double)pos.m_123341_() + 0.4 + (double)random.m_188501_() * 0.2;
                            d1 = (double)pos.m_123342_() + 0.7 + (double)random.m_188501_() * 0.3;
                            d2 = (double)pos.m_123343_() + 0.4 + (double)random.m_188501_() * 0.2;
                            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
                            continue block5;
                        }
                        case ENCHANTMENT: {
                            continue block5;
                        }
                        default: {
                            level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, (double)(random.m_188501_() / 2.0f), 5.0E-5, (double)(random.m_188501_() / 2.0f));
                        }
                    }
                }
            }
            if (random.m_188503_(55) == 0) {
                for (i = 0; i < level.f_46441_.m_188503_(2) + 2; ++i) {
                    d0 = (double)pos.m_123341_() + 0.5;
                    d1 = pos.m_123342_();
                    d2 = (double)pos.m_123343_() + 0.5;
                    if (random.m_188500_() < 0.1) {
                        level.m_7785_(d0, d1, d2, SoundEvents.f_12472_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    }
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1 + 1.1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void m_6810_(BlockState oldState, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (oldState.m_60734_() != newState.m_60734_() && (tileEntity = worldIn.m_7702_(pos)) != null) {
            tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)handler.getStackInSlot(slot));
                }
            });
        }
        super.m_6810_(oldState, worldIn, pos, newState, isMoving);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)pLevel.m_7702_(pPos));
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        pTooltip.add((Component)Component.m_237110_((String)"generatorgalore.screen.generation_rate", (Object[])new Object[]{this.generator.getGenerationRate()}).m_130940_(ChatFormatting.BLUE));
        pTooltip.add((Component)Component.m_237110_((String)"generatorgalore.screen.transfer_rate", (Object[])new Object[]{this.generator.getTransferRate()}).m_130940_(ChatFormatting.BLUE));
        pTooltip.add((Component)Component.m_237110_((String)"generatorgalore.screen.max_energy", (Object[])new Object[]{this.generator.getBufferCapacity()}).m_130940_(ChatFormatting.BLUE));
        pTooltip.add((Component)Component.m_237110_((String)"generatorgalore.screen.fuel_type", (Object[])new Object[]{this.generator.getFuelType()}).m_130940_(ChatFormatting.BLUE));
    }
}

