/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.integrations;

import cy.jdkdigital.generatorgalore.common.recipe.SolidFuelRecipe;
import cy.jdkdigital.generatorgalore.integrations.JeiPlugin;
import cy.jdkdigital.generatorgalore.util.GeneratorObject;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SolidFuelRecipeCategory
implements IRecipeCategory<SolidFuelRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final GeneratorObject generator;

    public SolidFuelRecipeCategory(IGuiHelper guiHelper, GeneratorObject generator) {
        this.generator = generator;
        ResourceLocation location = new ResourceLocation("generatorgalore", "textures/gui/jei/solid_fuel_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("generatorgalore", this.generator.getId().m_135815_() + "_generator"))));
    }

    @NotNull
    public RecipeType<SolidFuelRecipe> getRecipeType() {
        return JeiPlugin.FUEL_RECIPE_TYPES.get(this.generator);
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"generatorgalore.recipe.solid_fuel");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SolidFuelRecipe recipe, @NotNull IFocusGroup iFocusGroup) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 0, 41).addItemStacks(Arrays.asList(recipe.generator().m_43908_()))).setSlotName("generator");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 18, 41).addItemStacks(recipe.fuels().stream().flatMap(ingredient -> Arrays.stream(ingredient.m_43908_())).toList())).setSlotName("fuels");
    }

    public void draw(@NotNull SolidFuelRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics poseStack, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        poseStack.drawString(minecraft.f_91062_, "Rate: " + recipe.rate() + "FE/t", 37.0f, 14.0f, 0x404040, false);
        poseStack.drawString(minecraft.f_91062_, "Burntime: " + recipe.burnTime(), 37.0f, 32.0f, 0x404040, false);
        poseStack.drawString(minecraft.f_91062_, "Total: " + (int)(recipe.rate() * (float)recipe.burnTime()) + "FE", 37.0f, 50.0f, 0x404040, false);
    }
}

