/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.integrations;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.generatorgalore.common.recipe.FluidFuelRecipe;
import cy.jdkdigital.generatorgalore.common.recipe.SolidFuelRecipe;
import cy.jdkdigital.generatorgalore.init.ModTags;
import cy.jdkdigital.generatorgalore.integrations.FluidFuelRecipeCategory;
import cy.jdkdigital.generatorgalore.integrations.SolidFuelRecipeCategory;
import cy.jdkdigital.generatorgalore.registry.GeneratorRegistry;
import cy.jdkdigital.generatorgalore.util.GeneratorObject;
import cy.jdkdigital.generatorgalore.util.GeneratorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.library.plugins.vanilla.cooking.fuel.FuelRecipeMaker;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = new ResourceLocation("generatorgalore", "generatorgalore");
    public static RecipeType<SolidFuelRecipe> SOLID_FUEL_RECIPE_TYPE = RecipeType.create((String)"generatorgalore", (String)"solid_fuels", SolidFuelRecipe.class);
    public static Map<GeneratorObject, RecipeType<SolidFuelRecipe>> FUEL_RECIPE_TYPES = new HashMap<GeneratorObject, RecipeType<SolidFuelRecipe>>();
    public static Map<GeneratorObject, RecipeType<FluidFuelRecipe>> FLUID_FUEL_RECIPE_TYPES = new HashMap<GeneratorObject, RecipeType<FluidFuelRecipe>>();

    public JeiPlugin() {
        GeneratorRegistry.generators.forEach((resourceLocation, generator) -> {
            if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
                FLUID_FUEL_RECIPE_TYPES.put((GeneratorObject)generator, (RecipeType<FluidFuelRecipe>)RecipeType.create((String)"generatorgalore", (String)(generator.getId().m_135815_() + "_fuels"), FluidFuelRecipe.class));
            } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.SOLID) && generator.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG) && generator.getFuelList() == null) {
                if (generator.getId().m_135815_().equals("iron")) {
                    FUEL_RECIPE_TYPES.put((GeneratorObject)generator, SOLID_FUEL_RECIPE_TYPE);
                }
            } else {
                FUEL_RECIPE_TYPES.put((GeneratorObject)generator, (RecipeType<SolidFuelRecipe>)RecipeType.create((String)"generatorgalore", (String)(generator.getId().m_135815_() + "_fuels"), SolidFuelRecipe.class));
            }
        });
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        GeneratorRegistry.generators.forEach((resourceLocation, generator) -> {
            if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)generator.getBlockSupplier().get()), new RecipeType[]{FLUID_FUEL_RECIPE_TYPES.get(generator)});
            } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.SOLID) && generator.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG) && generator.getFuelList() == null) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)generator.getBlockSupplier().get()), new RecipeType[]{SOLID_FUEL_RECIPE_TYPE});
            } else {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)generator.getBlockSupplier().get()), new RecipeType[]{FUEL_RECIPE_TYPES.get(generator)});
            }
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        AtomicBoolean hasRegisteredGeneric = new AtomicBoolean(false);
        GeneratorRegistry.generators.forEach((resourceLocation, generator) -> {
            if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
                registration.addRecipeCategories(new IRecipeCategory[]{new FluidFuelRecipeCategory(guiHelper, (GeneratorObject)generator)});
            } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.SOLID) && generator.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG) && generator.getFuelList() == null) {
                if (!hasRegisteredGeneric.get()) {
                    registration.addRecipeCategories(new IRecipeCategory[]{new SolidFuelRecipeCategory(guiHelper, GeneratorRegistry.generators.get(new ResourceLocation("generatorgalore", "iron")))});
                    hasRegisteredGeneric.set(true);
                }
            } else {
                registration.addRecipeCategories(new IRecipeCategory[]{new SolidFuelRecipeCategory(guiHelper, (GeneratorObject)generator)});
            }
        });
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List vanillaFuelRecipes = FuelRecipeMaker.getFuelRecipes((IIngredientManager)registration.getIngredientManager());
        List<ItemStack> foodList = registration.getIngredientManager().getAllItemStacks().stream().filter(stack -> {
            FoodProperties foodProperties = stack.m_41720_().getFoodProperties(stack, null);
            return foodProperties != null;
        }).toList();
        List enchantmentList = ForgeRegistries.ENCHANTMENTS.getValues().stream().map(enchantment -> {
            ArrayList books = new ArrayList();
            IntStream.range(0, enchantment.m_6586_()).forEach(i -> books.add(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, i + 1))));
            return books;
        }).flatMap(Collection::stream).toList();
        List basePotions = PotionBrewing.f_43496_.stream().flatMap(potionItem -> Arrays.stream(potionItem.m_43908_())).toList();
        List potionList = ForgeRegistries.POTIONS.getValues().stream().map(potion -> {
            ArrayList<ItemStack> potions = new ArrayList<ItemStack>();
            if (potion != Potions.f_43598_) {
                for (ItemStack input : basePotions) {
                    ItemStack result = PotionUtils.m_43549_((ItemStack)input.m_41777_(), (Potion)potion);
                    potions.add(result);
                }
            }
            return potions;
        }).flatMap(Collection::stream).toList();
        GeneratorRegistry.generators.forEach((resourceLocation, generator) -> {
            Ingredient genIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)generator.getBlockSupplier().get()});
            String idPrefix = ForgeRegistries.BLOCKS.getKey((Object)generator.getBlockSupplier().get()).m_135815_();
            AtomicInteger i = new AtomicInteger();
            if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
                ITag fluids;
                ArrayList<FluidFuelRecipe> fuelRecipes = new ArrayList<FluidFuelRecipe>();
                if (!generator.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG) && !(fluids = ForgeRegistries.FLUIDS.tags().getTag(ModTags.getFluidTag(generator.getFuelTag()))).isEmpty()) {
                    List<FluidStack> fluidStacks = fluids.stream().map(fluid -> new FluidStack(fluid, 10000)).toList();
                    fuelRecipes.add(new FluidFuelRecipe(new ResourceLocation("generatorgalore", idPrefix + "_fuels_" + i.getAndIncrement()), fluidStacks, genIngredient, (float)generator.getGenerationRate(), (float)generator.getConsumptionRate()));
                }
                registration.addRecipes(FLUID_FUEL_RECIPE_TYPES.get(generator), fuelRecipes);
            } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.SOLID) && generator.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG) && generator.getFuelList() == null) {
                ArrayList fuelRecipes = new ArrayList();
                vanillaFuelRecipes.forEach(fuelingRecipe -> fuelRecipes.add(new SolidFuelRecipe(new ResourceLocation("generatorgalore", idPrefix + "_" + ForgeRegistries.ITEMS.getKey((Object)((ItemStack)fuelingRecipe.getInputs().get(0)).m_41720_()).m_135815_() + "_" + i.getAndIncrement()), List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{(ItemStack)fuelingRecipe.getInputs().get(0)})), genIngredient, (float)generator.getGenerationRate(), (int)((double)fuelingRecipe.getBurnTime() * generator.getConsumptionRate()))));
                registration.addRecipes(SOLID_FUEL_RECIPE_TYPE, fuelRecipes);
            } else {
                ArrayList<SolidFuelRecipe> fuelRecipes = new ArrayList<SolidFuelRecipe>();
                if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.SOLID)) {
                    if (generator.getFuelList() != null) {
                        generator.getFuelList().forEach((itemId, fuel) -> fuelRecipes.add(new SolidFuelRecipe(new ResourceLocation("generatorgalore", idPrefix + "_" + itemId.m_135815_() + "_" + i.getAndIncrement()), List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(itemId)})), genIngredient, fuel.rate(), fuel.burnTime())));
                    } else if (!generator.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG)) {
                        fuelRecipes.add(new SolidFuelRecipe(new ResourceLocation("generatorgalore", idPrefix + "_fuels"), List.of(Ingredient.m_204132_(ModTags.getItemTag(generator.getFuelTag()))), genIngredient, (float)generator.getGenerationRate(), (int)generator.getConsumptionRate()));
                    }
                } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FOOD)) {
                    foodList.forEach(stack -> {
                        Pair<Float, Integer> rate = GeneratorUtil.calculateFoodGenerationRate(generator, stack);
                        fuelRecipes.add(new SolidFuelRecipe(new ResourceLocation("generatorgalore", idPrefix + "_" + ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_() + "_" + i.getAndIncrement()), List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack})), genIngredient, ((Float)rate.getFirst()).floatValue(), (Integer)rate.getSecond()));
                    });
                } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.ENCHANTMENT)) {
                    enchantmentList.forEach(stack -> {
                        Pair<Float, Integer> rate = GeneratorUtil.calculateEnchantmentGenerationRate(generator, stack);
                        fuelRecipes.add(new SolidFuelRecipe(new ResourceLocation("generatorgalore", idPrefix + "_" + ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_() + "_" + i.getAndIncrement()), List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack})), genIngredient, ((Float)rate.getFirst()).floatValue(), (Integer)rate.getSecond()));
                    });
                } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.POTION)) {
                    potionList.forEach(stack -> {
                        Pair<Float, Integer> rate = GeneratorUtil.calculatePotionGenerationRate(generator, stack);
                        fuelRecipes.add(new SolidFuelRecipe(new ResourceLocation("generatorgalore", idPrefix + "_" + ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_() + "_" + i.getAndIncrement()), List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack})), genIngredient, ((Float)rate.getFirst()).floatValue(), (Integer)rate.getSecond()));
                    });
                }
                registration.addRecipes(FUEL_RECIPE_TYPES.get(generator), fuelRecipes);
            }
        });
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
    }
}

