/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.common.container;

import cy.jdkdigital.generatorgalore.cap.ControlledEnergyStorage;
import cy.jdkdigital.generatorgalore.common.block.entity.GeneratorBlockEntity;
import cy.jdkdigital.generatorgalore.common.container.AbstractContainer;
import cy.jdkdigital.generatorgalore.common.container.ManualItemHandler;
import cy.jdkdigital.generatorgalore.common.container.ManualSlotItemHandler;
import cy.jdkdigital.generatorgalore.util.GeneratorUtil;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class GeneratorMenu
extends AbstractContainer {
    public final GeneratorBlockEntity blockEntity;
    public static final int SLOT_FUEL = 0;

    public GeneratorMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, GeneratorMenu.getTileEntity(playerInventory, data));
    }

    public GeneratorMenu(int id, Inventory inventory, final GeneratorBlockEntity blockEntity) {
        super(blockEntity.generator.getMenuType().get(), id);
        this.blockEntity = blockEntity;
        this.m_38884_(new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> blockEntity.litTime;
                    case 1 -> blockEntity.litDuration;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        blockEntity.litTime = value;
                        break;
                    }
                    case 1: {
                        blockEntity.litDuration = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return blockEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
            }

            public void m_6422_(int value) {
                blockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> {
                    if (handler.getEnergyStored() > 0) {
                        handler.extractEnergy(handler.getEnergyStored(), false);
                    }
                    if (value > 0 && handler instanceof ControlledEnergyStorage) {
                        ControlledEnergyStorage controlledEnergyStorage = (ControlledEnergyStorage)((Object)handler);
                        controlledEnergyStorage.receiveEnergy(value, false, true);
                    }
                });
            }
        });
        if (this.blockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
            this.m_38884_(new ContainerData(){

                public int m_6413_(int i) {
                    return i == 0 ? blockEntity.fluidId : blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).map(fluidHandler -> fluidHandler.getFluidInTank(0).getAmount()).orElse(0);
                }

                public void m_8050_(int i, int value) {
                    switch (i) {
                        case 0: {
                            blockEntity.fluidId = value;
                        }
                        case 1: {
                            blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fluidHandler -> {
                                FluidStack fluid = fluidHandler.getFluidInTank(0);
                                if (fluid.isEmpty()) {
                                    fluidHandler.fill(new FluidStack((Fluid)BuiltInRegistries.f_257020_.m_7942_(blockEntity2.fluidId), value), IFluidHandler.FluidAction.EXECUTE);
                                } else {
                                    fluid.setAmount(value);
                                }
                            });
                        }
                    }
                }

                public int m_6499_() {
                    return 2;
                }
            });
        }
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
            if (inv instanceof ManualItemHandler) {
                ManualItemHandler itemHandler = (ManualItemHandler)((Object)inv);
                this.m_38897_((Slot)new ManualSlotItemHandler(itemHandler, 0, 80, 54));
            }
        });
        this.layoutPlayerInventorySlots(inventory, 0, 8, 84);
    }

    private static GeneratorBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof GeneratorBlockEntity) {
            return (GeneratorBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity != null && player.m_20275_((double)this.blockEntity.m_58899_().m_123341_() + 0.5, (double)this.blockEntity.m_58899_().m_123342_() + 0.5, (double)this.blockEntity.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    public int getLitProgress() {
        int i = this.blockEntity.litDuration;
        if (i == 0) {
            i = 200;
        }
        return this.blockEntity.litTime * 13 / i;
    }
}

